-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local NET_DEV_FUNC_TYPE_FC = 2
local NET_CARD_TYPE_TEAM = 7
local NET_CARD_TYPE_BRIDGE = 8

local rsp = cjson.json_object_new_object()
rsp.NetCard = cjson.json_object_new_object()
rsp.FCCard = cjson.json_object_new_object()
rsp.Bridge = cjson.json_object_new_object()
rsp.Team = cjson.json_object_new_object()

local rsp_table = {
    NetCard = {},
    FCCard = {},
    Bridge = {},
    Team = {}
}

local function get_rsp_table(src)
    return {
        ["@odata.id"] = src["@odata.id"],
        ["DeviceLocator"] = src["DeviceLocator"],
        ["Name"] = src["Name"]
    }
end

for i in pairs(Input) do
    if Input[i].NetDevFuncCapabilities == NET_DEV_FUNC_TYPE_FC then
        table.insert(rsp_table.FCCard, get_rsp_table(Input[i]))
    elseif Input[i].Type == NET_CARD_TYPE_TEAM then
        table.insert(rsp_table.Team, get_rsp_table(Input[i]))
    elseif Input[i].Type == NET_CARD_TYPE_BRIDGE then
        table.insert(rsp_table.Bridge, get_rsp_table(Input[i]))
    else
        table.insert(rsp_table.NetCard, get_rsp_table(Input[i]))
    end
end

rsp.NetCard = cjson.json_object_from_table(rsp_table.NetCard)
rsp.FCCard = cjson.json_object_from_table(rsp_table.FCCard)
rsp.Bridge = cjson.json_object_from_table(rsp_table.Bridge)
rsp.Team = cjson.json_object_from_table(rsp_table.Team)

return rsp