function get_nvme_smart()
    -- 获取协议和媒体类型
    local protocol = ProcessingFlow[2].Destination.Protocol
    local media_type = ProcessingFlow[2].Destination.MediaType

    -- 如果不是NVMe设备（MediaType=1且Protocol=6），直接返回lua_nil
    if media_type ~= 1 or protocol ~= 6 then
        return lua_nil
    end

    -- 辅助函数：根据条件返回nil或正常值
    local function get_value_or_nil(value, special_value)
        return value == special_value and null or value
    end

    local power_on_hours = ProcessingFlow[2].Destination.PowerOnHours
    local available_spare = ProcessingFlow[3].Destination.AvailableSparePercent
    local percentage_used = ProcessingFlow[3].Destination.PercentageUsed
    local critical_warning = ProcessingFlow[3].Destination.CriticalWarning

    -- 使用cjson接口构建NVMeSMART属性对象
    local nvme_smart = cjson.json_object_new_object()
    nvme_smart.PowerOnHours = get_value_or_nil(power_on_hours, 4294967295)
    nvme_smart.AvailableSparePercent = get_value_or_nil(available_spare, 255)
    nvme_smart.PercentageUsed = get_value_or_nil(percentage_used, 255)

    -- 使用cjson接口构建CriticalWarnings对象
    local critical_warnings = cjson.json_object_new_object()
    critical_warnings.PMRUnreliable = critical_warning == 255 and null or ((critical_warning & 32) ~= 0)
    critical_warnings.PowerBackupFailed = critical_warning == 255 and null or ((critical_warning & 16) ~= 0)
    critical_warnings.MediaInReadOnly = critical_warning == 255 and null or ((critical_warning & 8) ~= 0)
    critical_warnings.OverallSubsystemDegraded = critical_warning == 255 and null or ((critical_warning & 4) ~= 0)
    critical_warnings.SpareCapacityWornOut = critical_warning == 255 and null or ((critical_warning & 1) ~= 0)

    nvme_smart.CriticalWarnings = critical_warnings

    return nvme_smart
end

return get_nvme_smart()