-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local board_type = ProcessingFlow[2].Destination.BoardType
local valid_type = {CpuBoard = true, NpuBoard = true}

if not valid_type[board_type] then
    return null
end

local power_watts = ProcessingFlow[2].Destination.PowerWatts
if board_type == 'NpuBoard' then
    power_watts = ProcessingFlow[14].Destination.PowerWatts
end

-- 当两个npu功率都无法获取时，NpuBoard的功率为65535
if power_watts == 0 or power_watts == 65535 then
    return null
end

return power_watts