-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local multi_logic_unit = ProcessingFlow[2].Destination.MultiLogicUnit
local multi_logic_ver = ProcessingFlow[2].Destination.MultiLogicVersion

if not multi_logic_unit or type(multi_logic_unit) ~= "table" or
    not multi_logic_ver or type(multi_logic_ver) ~= "table" then
    return nil
end

local result = {}
for k, v in pairs(multi_logic_ver) do
    local item = {}
    item.Name = k
    item.Version = v
    item.PositionId = multi_logic_unit[k]
    table.insert(result, item)
end

return result