-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local role_table = {
    ['No Access'] = 0,
    ['Common User'] = 2,
    ['Operator'] = 3,
    ['Administrator'] = 4,
    ['Custom Role 1'] = 5,
    ['Custom Role 2'] = 6,
    ['Custom Role 3'] = 7,
    ['Custom Role 4'] = 8,
    ['Custom Role 5'] = 9,
    ['Custom Role 6'] = 10,
    ['Custom Role 7'] = 11,
    ['Custom Role 8'] = 12,
    ['Custom Role 9'] = 13,
    ['Custom Role 10'] = 14,
    ['Custom Role 11'] = 15,
    ['Custom Role 12'] = 16,
    ['Custom Role 13'] = 17,
    ['Custom Role 14'] = 18,
    ['Custom Role 15'] = 19,
    ['Custom Role 16'] = 20,
    [''] = 2 -- 新增组未带角色，默认为普通角色
}

local role_ids = {}

for i = 1, 5 do
    local role_id = (ReqBodyOriginal.LdapGroups[i] or {}).GroupRole or ''
    role_ids[i] = role_table[role_id]
end

return role_ids