-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

function m.get_lanes_map(input)
    local lanes_map = {}
    for k, _ in pairs(input) do
        lanes_map[k] = k
    end
    return lanes_map
end

function m.get_lane_mappings_name(optical_id)
    local adapter_node_id, port_id = string.match(optical_id, '(.+)Port(.+)')
    return string.format('OpticalModule %s Port%s Lane Mapping Collection', adapter_node_id, port_id)
end

function m.get_lane_mapping_name(optical_id, lane_id)
    local adapter_node_id, port_id = string.match(optical_id, '(.+)Port(.+)')
    return string.format('OpticalModule %s Port%s LaneMapping %s', adapter_node_id, port_id, lane_id)
end

function m.get_related_port_lane(net_port_lane, lane_id)
    local id = tonumber(lane_id)
    return string.format('Lane_%s/to/NetWorkPort_%s/Lane_%s',
        id, net_port_lane[id][1] + 1, net_port_lane[id][2])
end

return m