-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}
local log = require 'mc.logging'
local context = require 'mc.context'

local TPCM_MICROCOMPONENT_PATH <const> = '/bmc/kepler/tpcm/MicroComponent'
local MDB_SERVICE_PATH <const> = '/bmc/kepler/MdbService'
local MDB_INTF <const> = 'bmc.kepler.Mdb'

function m.get_tpcm_supported(tcm_precense)
    -- 若TCM不在位，则返回false
    if not tcm_precense then
        return false
    end

    local ok, obj = pcall(mdb.get_object, bus, MDB_SERVICE_PATH, MDB_INTF)
    if not ok then
        log:info('Invalid Mdb Path, err: %s', obj)
        return false
    end

    -- TCM在位场景，则需要检查TPCM是否支持
    local ret, valid = pcall(function()
        return obj:IsValidPath(context.get_context(), TPCM_MICROCOMPONENT_PATH)
    end)
    if not ret then
        log:info('Invalid Mdb Method, err: %s', valid)
        return false
    end

    return valid.Result
end


return m