-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local json = require 'cjson'
local context = require 'mc.context'

local m = {}

function m.get_dynamic_power_equipment_body(power_distribution_name)
    -- 定义name到equipment_type的映射关系
    local equipment_type_map = {
        ElectricalBuses = {"Bus"},
        FloorPDUs = {"FloorPDU"},
        TransferSwitches = {"AutomaticTransferSwitch", "ManualTransferSwitch"},
        PowerShelves = {"PowerShelf"},
        Switchgear = {"Switchgear"},
        RackPDUs = {"RackPDU"}
    }

    -- 获取对应的equipment_type列表
    local equipment_types = equipment_type_map[power_distribution_name]
    if not equipment_types then
        return lua_nil
    end

    -- 对于TransferSwitches，需要检查两种类型，只要有一种存在就返回资源链接
    for _, equipment_type in ipairs(equipment_types) do
        local path = bus:call('bmc.kepler.maca', '/bmc/kepler/MdbService', 'bmc.kepler.Mdb', 'GetPath',
        'a{ss}ssb', context.new(), "bmc.kepler.PowerEquipment.PowerDistribution",
        json.encode({EquipmentType = equipment_type}), false)

        if path ~= '' then
            return {
                ["@odata.id"] = "/redfish/v1/PowerEquipment/" .. power_distribution_name
            }
        end
    end

    -- 所有类型都不存在，返回lua_nil
    return lua_nil
end

return m