-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

local location_reference_value = {
    ["Bottom"] = 1,
    ["Front"] = 1,
    ["Left"] = 1,
    ["Middle"] = 1,
    ["Rear"] = 1,
    ["Right"] = 1,
    ["Top"] = 1
}

function m.get_location_list(ServiceLabel, Reference)
    local location_list = {}
    local part_location_list = {}
    if ServiceLabel and ServiceLabel ~= "" then
        part_location_list["ServiceLabel"] = ServiceLabel
    end
    if Reference and Reference ~= "" and location_reference_value[Reference] then
        part_location_list["Reference"] = Reference
    end

    if not next(part_location_list) then
        return lua_nil
    end
    location_list['PartLocation'] = part_location_list

    return location_list
end

return m