-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

function m.get_health_rollup(leak_detector_paths)
    local health_rollup = null
    if not leak_detector_paths or not next(leak_detector_paths) then
        return health_rollup
    end
    health_rollup = 0
    for _, v in ipairs(leak_detector_paths) do
        local obj = mdb.get_object(bus, v, 'bmc.kepler.Chassis.LeakDetection.LeakDetector')
        if health_rollup < obj.State then
            health_rollup = obj.State
        end
    end

    return health_rollup
end

return m