-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

function m.get_vlan(paths)

    if #paths == 0 or #paths >= 2 then
        return lua_nil
    end

    if #paths == 1 then
        local VLAN = {}
        for _, v in ipairs(paths) do
            local obj = mdb.get_object(bus, v, 'bmc.kepler.Systems.NetworkPort.VLAN')
            VLAN = {
                VLANId = obj.VLANId,
                VLANEnable = obj.VLANEnabled,
                VLANPriority = obj.VLANPriority
            }
            return VLAN
        end
    end
end

return m