-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local log = require 'mc.logging'
local mdb_service = require 'mc.mdb.mdb_service'

local m = {}

function m.is_valid_power_distribution_id(power_distribution_id)
    local path = '/bmc/kepler/PowerEquipment/PowerDistributions/' .. power_distribution_id

    local ok, rsp = pcall(mdb_service.is_valid_path, bus, path)
    if not ok then
        log:error('Invalid power distribution id(%s), err(%s)', power_distribution_id, rsp.message)
        return false
    end

    return rsp.Result
end

function m.is_valid_circuit_id(power_distribution_id, circuit_id)
    local path = '/bmc/kepler/PowerEquipment/PowerDistributions/' .. power_distribution_id .. '/Circuits/' ..
        circuit_id

    local ok, rsp = pcall(mdb_service.is_valid_path, bus, path)
    if not ok then
        log:error('Invalid circuit id(%s), power distribution id(%s), err(%s)', circuit_id, power_distribution_id,
            rsp.message)
        return false
    end

    return rsp.Result
end

return m
