-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local utils = require 'mc.utils'

local VIRTUAL_MEDIA_CD_PATH = '/bmc/kepler/Managers/1/VirtualMedia/CD'
local VIRTUAL_MEDIA_CD_INTF = 'bmc.kepler.Managers.VirtualMedia.CD'
local SYSTEM_VIRTUAL_MEDIA_CD_PATH = '/bmc/kepler/Systems/%s/VirtualMedia/CD'
local SYSTEM_VIRTUAL_MEDIA_CD_INTF = 'bmc.kepler.Systems.VirtualMedia.CD'
local DEFAULT_CONNECT_NUM = 0
local DEFAULT_IMAGE_URL = ''
local DEFAULT_USERNAME = ''
local DEFAULT_PASSWORD = ''

local m = {}

function m.check_vmm_connect(system_id)
    local ok, virtual_media_cd_obj
    if not system_id or system_id == cjson.null then
        ok, virtual_media_cd_obj = pcall(mdb.get_object, bus, VIRTUAL_MEDIA_CD_PATH, VIRTUAL_MEDIA_CD_INTF)
    else
        local path = string.format(SYSTEM_VIRTUAL_MEDIA_CD_PATH, system_id)
        ok, virtual_media_cd_obj = pcall(mdb.get_object, bus, path, SYSTEM_VIRTUAL_MEDIA_CD_INTF)
    end
    if not ok then
        return false
    end

    return virtual_media_cd_obj.ConnectNum ~= 0
end

function m.get_vmm_infos(system_id)
    local ok, virtual_media_cd_obj
    local res = cjson.json_object_new_object()
    if not system_id then
        ok, virtual_media_cd_obj = pcall(mdb.get_object, bus, VIRTUAL_MEDIA_CD_PATH, VIRTUAL_MEDIA_CD_INTF)
    else
        local path = string.format(SYSTEM_VIRTUAL_MEDIA_CD_PATH, system_id)
        ok, virtual_media_cd_obj = pcall(mdb.get_object, bus, path, SYSTEM_VIRTUAL_MEDIA_CD_INTF)
    end
    if not ok then
        res['ConnectNum'] = DEFAULT_CONNECT_NUM
        res['ImageUrl'] = DEFAULT_IMAGE_URL
    else
        res['ConnectNum'] = virtual_media_cd_obj.ConnectNum
        res['ImageUrl'] = virtual_media_cd_obj.Image
    end
    return res
end

function m.get_insert_media_params(uri)
    local params = cjson.json_object_new_object()
    local supported_auth_protocols = {'https', 'cifs'}
    local protocol, rest = string.match(uri, "(%a)%://(.+)$")
    if protocol and utils.array_contains(supported_auth_protocols, protocol) then
        local username, password, tmp_rest = string.match(rest, "(%a)%:(.+)@(.*)$")
        params['UserName'] = username or DEFAULT_USERNAME
        params['Password'] = password or DEFAULT_PASSWORD
        params['ProtocolType'] = protocol
        params['Image'] = protocol .. '://' .. tmp_rest
    else
        params['UserName'] = DEFAULT_USERNAME
        params['Password'] = DEFAULT_PASSWORD
        params['ProtocolType'] = protocol
        params['Image'] = uri
    end
    return params
end

return m
