-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local file_sec = require 'utils.file'
local m = {}


-- 从文件获取bios全打印开关的状态
-- ","SYSDBGLevel":"result","
function m.get_bios_print_state()
    local path = '/data/opt/currentvalue.json'
    local fp = file_sec.open_s(path, 'r')
    if not fp then
        return {false}
    end
    local buf = fp:read('a')
    fp:close()
    local _, pos = string.find(buf, '"SYSDBGLevel":')
    if pos then
        local _, next_pos = string.find(buf, '"', pos + 1)
        local _, end_pos = string.find(buf, '"', next_pos + 1)
        if end_pos then
            local result = string.sub(buf, next_pos + 1, end_pos - 1)
            return {true, result}
        else
            return {false}
        end
    else
        return {false}
    end
end

function m.check_privilege(user_privilege, target_privilege)
    for _, v in ipairs(user_privilege) do
        if v == target_privilege then
            return true
        end
    end

    error(base_messages.InsufficientPrivilege())
end


return m
