*openUBMC 支持ProcessorMetrics与MemoryMetrics资源升级功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.3.0</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>Minwell</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/10/28</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/10/28</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>Minwell</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
`Redfish` 标准接口作为行业标准，为数据中心硬件管理提供了标准化、统一化的解决方案。在实际业务场景中，管理员需要实时、精准地获取处理器和内存的各项指标数据，以便及时调整资源分配、优化系统性能。然而openUBMC现有的接口在获取处理器和内存信息时不够全面。因此，依据 `Redfish` 标准接口新增 `ProcessorMetrics` 与`MemoryMetrics`查询接口，并分别在这两个接口下新增 `OperatingSpeedMHz` 属性，有助于支撑上层网管系统的统筹优化。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本次功能实现主要是依据 `Redfish` 标准接口规范，新增 `ProcessorMetrics` 与`MemoryMetrics`查询接口。采用 `HTTP` 协议进行通信，支持标准的 `HTTP` 动词 `GET`操作。通过该接口，可以向服务器发送请求，获取处理器相关的各项指标数据。​
在两个接口返回的数据结构中，新增 `OperatingSpeedMHz` 属性。该属性用于展示处理器当前的运行频率数值，单位为 MHz。在获取处理器信息的 `JSON` 数据结构中，`OperatingSpeedMHz` 属性将作为一个独立的字段存在，与其他处理器相关属性一同返回。
## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
### 1.3.1 场景触发条件及对象
使用角色：系统管理员
使用工具：Redfish工具
使用技能：具备基本的BMC管理经验
### 1.3.2 使用时间及频度
使用时间：系统运行期间持续监控，故障诊断时查询历史数据
#### 1.3.3 主要场景及子场景
实时查看处理器当前的运行频率数值
实时查看内存当前的运行频率数值

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1.1 | ProcessorMetrics 查询接口     | 依据 Redfish 标准，提供获取处理器相关指标数据的接口。 |
| 1.2 | OperatingSpeedMHz 属性        | 在接口返回数据中新增该属性，用于展示处理器当前运行频率数值。  |
| 2.1 | MemoryMetrics 查询接口下的OperatingSpeedMHz 属性      | 在接口返回数据中新增该属性，用于展示内存当前运行频率数值。 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
本方案旨在依据 Redfish 标准接口，新增 ProcessorMetrics 与 MemoryMetrics 查询接口，并分别展示 OperatingSpeedMHz 属性，完善处理器与内存性能指标监控功能。通过在现有代码架构中相关模块，实现对处理器与内存运行频率等关键指标的准确获取与查询。

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
本方案的整体实现围绕 Redfish 标准展开，关键点包括新增 ProcessorMetrics 与 MemoryMetrics 查询接口、并在接口中添加 OperatingSpeedMHz 属性。实现策略为：首先，按照 Redfish 规范定义 ProcessorMetrics 与 MemoryMetrics 查询接口的路径、请求方法和响应格式；其次，在接口响应数据中新增 OperatingSpeedMHz 属性，用于返回处理器当前运行频率；最后，通过数据采集模块实时获取处理器运行频率数据，并分别同步更新至 ProcessorMetrics 与 MemoryMetrics 资源中，确保查询接口返回数据的准确性和时效性。

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
从开发角度来看，系统代码结构将在现有rackmount中 `Redfish` 服务模块基础上进行扩展。新增 `ProcessorMetrics` 与 `MemoryMetrics` 接口相关的代码。代码按照 Redfish 标准规范定义接口的相关信息，如 URL、请求参数、响应参数等。

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
系统启动时，Redfish 服务模块初始化，同时加载新增的 `ProcessorMetrics` 与 `MemoryMetrics` 资源相关组件，完成接口注册和资源初始化。在运行期间，数据采集模块按照设定的时间间隔实时采集处理器运行频率数据，并将数据发送至 `ProcessorMetrics` 与 `MemoryMetrics`  资源的数据更新接口。`ProcessorMetrics` 与 `MemoryMetrics`  资源收到数据后，更新 OperatingSpeedMHz 属性的值。当外部工具或系统通过 Redfish 协议发送查询请求至 `ProcessorMetrics` 与 `MemoryMetrics`  接口时，Redfish 服务模块处理该请求，从 `ProcessorMetrics` 与 `MemoryMetrics`  资源中获取相关数据（包括 `OperatingSpeedMHz` 属性值），并按照 Redfish 标准格式返回给请求方。

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
本功能涉及与系统内部的处理器与内存数据采集模块存在接口依赖，需要该模块提供处理器运行频率与内存运行评率的实时数据。经确认，当前处理器与内存数据采集模块已具备采集处理器运行频率的能力，且其输出的数据格式和接口调用方式能够满足本需求的开发诉求，无需对该模块进行额外修改。

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
本功能不涉及与平台 SDK 的依赖关系，仅基于系统内部现有的数据采集和 Redfish 服务框架进行开发。

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 新增 ProcessorMetrics 查询接口及 OperatingSpeedMHz 属性| NA | NA | NA | NA | NA | NA | 是，新增 `ProcessorMetrics` 与 `MemoryMetrics` 查询接口，在接口响应中包含 OperatingSpeedMHz 属性 |
### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
当前功能对现有在网的功能无影响。新增的 `ProcessorMetrics` 与 `MemoryMetrics` 查询接口及 OperatingSpeedMHz 属性是在 Redfish 标准框架下的扩展，不会改变现有接口的功能和响应格式，现有基于 Redfish 标准的管理工具和系统能够正常识别和处理新增的接口及属性，无需对现有功能进行调整。
### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 |	用例名称 |	参与者 |	前置条件 |	操作步骤  |	预期结果 |
| ---- | ---- | ---- | --- | ------ | ---------------- | 
| 1 |	查询ProcessorMetrics数据（包含 OperatingSpeedMHz） |	数据中心管理员 / 系统运维人员 / 服务器研发人员	| 系统正常运行，Redfish 服务启动	 | 1. 通过 Redfish 客户端发送 GET 请求至 ProcessorMetrics 接口；2. 等待接口响应	| 接口返回包含 OperatingSpeedMHz 属性的 ProcessorMetrics 数据，且 OperatingSpeedMHz 属性值为当前处理器的运行频率|
| 2 |	查询 MemoryMetrics 数据（包含 OperatingSpeedMHz） |	数据中心管理员 / 系统运维人员 / 服务器研发人员	| 系统正常运行，Redfish 服务启动	 | 1. 通过 Redfish 客户端发送 GET 请求至 MemoryMetrics 接口；2. 等待接口响应	| 接口返回包含 OperatingSpeedMHz 属性的 MemoryMetrics 数据，且 OperatingSpeedMHz 属性值为当前内存的运行频率|

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
本方案采用模块化设计，新增的 `ProcessorMetrics` 与 `MemoryMetrics` 查询接口及 OperatingSpeedMHz 属性相关代码独立于现有功能模块。后续若需新增类似的处理器性能指标属性或其他资源的 metrics 查询接口，可参照本方案的实现方式，在现有框架下进行扩展，无需对整体架构进行大规模调整，具有良好的扩展性。
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
本方案中涉及的 Redfish 接口开发规范、数据采集与处理机制等均为通用处理方式。其中，数据采集模块的调用方式、接口响应格式的定义等可在其他类似的资源监控功能开发中重用，数据处理管道可被其他数据处理需求重用
### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
可直接验证
### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
本功能涉及资料修改，需要在 Redfish 接口文档中新增 `ProcessorMetrics` 与 `MemoryMetrics` 查询接口的相关说明，包括接口路径、请求方法、响应参数（含 OperatingSpeedMHz 属性的定义和说明）等内容，以便用户了解和使用该接口
### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | DC场景 | 数据采集模块故障，无法获取处理器运行频率 |	接口返回的 OperatingSpeedMHz 属性值不准确或为空 |	一般 |	增加数据采集模块故障检测机制，当检测到故障时，接口返回特定标识（如 - 1）表示数据无效
| 2 | AC场景 | 网络波动导致查询请求超时 |	客户端无法及时获取处理器 metrics 数据 |	低 |	客户端实现请求重试机制，服务端优化接口响应速度	
3	 | BMC 场景 |	BMC 重启 |	重启期间接口无法响应请求 |	中	 | 重启完成后，自动恢复接口服务，并重新初始化数据	| 系统默认支持该功能	开发工程师	
4 |	服务重启 |	Redfish 服务重启 |	重启期间接口无法响应请求 |	中 |	服务重启完成后，自动重新注册接口并加载数据	|
5| 	数据获取异常状态 |	处理器运行频率异常（如超出正常范围）	| 接口返回异常的 OperatingSpeedMHz 属性值	| 低 |	在接口文档中说明属性值的正常范围
### 2.2.7 安全性分析
| 安全合规项 |	是否涉及 |	现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） |	是 |	采用 Redfish 标准的访问控制机制，通过用户认证和授权管理，限制对查询接口的访问权限，只有授权用户才能进行查询操作 |
| 敏感数据	| 否 |	无 |
| 日志（操作日志、维护日志、安全日志、运行日志） |	否 |	无 |
| 文档 |	是 |	提供完善的接口文档，说明接口的使用方法、安全注意事项等 |
| 加密及算法 |	是	| 采用 HTTPS 协议对接口通信进行加密，确保数据传输的安全性 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 |	否 |	无 |
| 新增对外接口入参校验	| 是	| 对接口的查询参数进行校验，防止无效参数或恶意参数导致的系统异常 | 
| 新增开源及三方软件引入 |	否 |	无 |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
本功能通过在 Redfish 服务中新增 `ProcessorMetrics` 与 `MemoryMetrics` 资源接口，实现对处理器和内存相关指标数据的查询。该接口遵循 Redfish 规范定义的路径
`/redfish/v1/Systems/{ComputerSystemId}/Processors/{ProcessorId}/ProcessorMetrics`
`/redfish/v1/Systems/{ComputerSystemId}/Memory/{MemoryId}/MemoryMetrics`
支持 GET 请求方法，用于返回处理器或内存的 metrics 数据，包括新增的 OperatingSpeedMHz 属性。
## 3.1【功能编号】支持ProcessorMetrics资源升级
### 3.1.1 功能实现设计
本功能通过在 Redfish 服务中新增 ProcessorMetrics 接口，实现对处理器相关指标数据的查询。该接口遵循 Redfish 规范定义的路径
`/redfish/v1/Systems/{ComputerSystemId}/Processors/{ProcessorId}/ProcessorMetrics`
支持 GET 请求方法，用于返回处理器的 metrics 数据，包括新增的 OperatingSpeedMHz 属性。
### 3.1.2 功能详细设计
接口路径定义：按照 Redfish 标准，定义 ProcessorMetrics 查询接口路径为
`/redfish/v1/Systems/{ComputerSystemId}/Processors/{ProcessorId}/ProcessorMetrics`
其中{ComputerSystemId}为系统标识，{ProcessorId}为处理器标识。
请求方法：仅支持 GET 方法，用于查询处理器 metrics 数据。
响应格式设计：响应数据采用 JSON 格式，包含处理器的各类指标信息，新增的OperatingSpeedMHz属性用于表示处理器当前运行频率，数据类型为整数，单位为 MHz。示例响应如下：
``` json
{
  "@odata.context": "/redfish/v1/$metadata#ProcessorMetrics.ProcessorMetrics",
  "@odata.id": "/redfish/v1/Systems/1/Processors/1/Metrics",
  "@odata.type": "#ProcessorMetrics.v1_0_0.ProcessorMetrics",
  "Id": "Metrics",
  "Name": "Processor Metrics",
  "OperatingSpeedMHz": 2800
}
```
数据获取流程：Redfish 服务在接收到 GET 请求后，调用内部处理器数据采集模块的接口，获取对应处理器的运行频率，封装成上述 JSON 格式后返回给请求方。其中`OperatingSpeedMHz`属性的获取路径为`bmc.kepler.Systems.Processor.CPU`下的`CurrentSpeedMHz`
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
不涉及
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->

## 3.2【功能编号】支持MemoryMetrics资源升级
### 3.2.1 功能实现设计
本功能通过在 Redfish 服务中新增 ProcessorMetrics 接口，实现对处理器相关指标数据的查询。该接口遵循 Redfish 规范定义的路径
`/redfish/v1/Systems/{ComputerSystemId}/Memory/{MemoryId}/MemoryMetrics`
支持 GET 请求方法，用于返回内存的 metrics 数据，包括新增的 OperatingSpeedMHz 属性。
### 3.2.2 功能详细设计
接口路径定义：按照 Redfish 标准，定义 ProcessorMetrics 查询接口路径为
`/redfish/v1/Systems/{ComputerSystemId}/Memory/{MemoryId}/MemoryMetrics`
其中{ComputerSystemId}为系统标识，{MemoryId}为内存标识。
请求方法：仅支持 GET 方法，用于查询处理器 metrics 数据。
响应格式设计：响应数据采用 JSON 格式，包含处理器的各类指标信息，新增的OperatingSpeedMHz属性用于表示处理器当前运行频率，数据类型为整数，单位为 MHz。示例响应如下：
``` json
{
  "@odata.context": "/redfish/v1/$metadata#ProcessorMetrics.ProcessorMetrics",
  "@odata.id": "/redfish/v1/Systems/1/Memory/011/Metrics",
  "@odata.type": "#MemoryMetrics.v1_0_0.MemoryMetrics",
  "Id": "Metrics",
  "Name": "Memory Metrics",
  "OperatingSpeedMHz": 2800
}
```
数据获取流程：Redfish 服务在接收到 GET 请求后，调用内部内存数据采集模块的接口，获取对应内存的运行频率，封装成上述 JSON 格式后返回给请求方。其中`OperatingSpeedMHz`属性的获取路径为`bmc.kepler.Systems.Memory`下的`OperatingSpeedMHz`
### 3.2.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
不涉及
#### 3.2.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
#### 3.2.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->