-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local skynet = require 'skynet'
local mdb = require 'mc.mdb'
local log = require 'mc.logging'

local cases = {}

require 'rack_mgmt.json_types.HeartBeat'

local function test_heart_beat_init(bus)
    log:info('==> test rack mgmt heartbeat init start ...')

    local path = '/bmc/kepler/Managers/1/HeartBeat/HeartBeat_IRM_01'
    local intf = 'bmc.kepler.Managers.HeartBeat'
    local ok, obj
    for i = 1, 10 do
        ok, obj = pcall(mdb.get_object, bus, path, intf)
        if ok then
            break
        end
        skynet.sleep(100)
    end
    assert(ok, 'actual: ' .. (not ok and obj or 'unknown error'))
    assert(obj.Name == 'IRMHeartBeat', 'actual: ' .. obj.Name)
    assert(obj.Status == 'OK', 'actual: ' .. obj.Status)

    log:info('==> test rack mgmt heartbeat init completed ...')
end

function cases.test_entry(bus)
    log:info('==> test rack mgmt heartbeat cases start ...')

    test_heart_beat_init(bus)

    log:info('==> test rack mgmt heartbeat cases completed ...')
end

return cases