-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_psu_slot_object = require 'device.psu_slot'
local psu_service = require 'psu_service'

TestPsuService = {}

local function mock_psu_slot_collection()
    
end

function TestPsuService:test_delete_psu_slot_object()
    local mock_data = {
        psu_slot = {{'psu1'}, {'psu2'}, {'psu3'}, {'psu4'}, {'psu5'}, {'psu6'}}
    }
    local objects = {
        {'psu1'}, {'psu2'}, {'psu3'}
    }
    local old_collection = c_psu_slot_object.fold
    c_psu_slot_object.collection.objects = objects
    c_psu_slot_object.collection.fold = function (_, fn)
        for _, obj in ipairs(c_psu_slot_object.collection.objects or {}) do
            fn(nil, obj)
        end
    end
    local ok = pcall(function()
        return psu_service.delete_psu_slot_object(mock_data)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(#mock_data.psu_slot, 3)
    return function ()
        c_psu_slot_object.collection = old_collection
    end
end