-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local skynet = require 'skynet'
local base_msg = require 'messages.base'
local enums = require 'macros.power_mgmt_enums'
local power_supplies_service = require 'power_supplies_service'

TestpPowerSuppliesService = {}

local db = {
    select = function ()
        return {
            first = function ()
                return {}
            end
        }
    end,
    PowerSupplies = function()
        return {
            save = function()
                return
            end
        }
    end
}

power_supplies_service.db = db

function TestpPowerSuppliesService:test_get_retransfer_delay_seconds()
    local power_suppliest_mock = {
        db = {
            select = function ()
                local db_table = {
                    first = function ()
                        return {RetransferDelaySeconds = 1800}
                    end
                }
                return db_table
            end
        }
    }
    
    local ok, rsp = pcall(function ()
        return power_supplies_service.get_retransfer_delay_seconds(power_suppliest_mock)
    end)
    lu.assertTrue(ok)
    lu.assertEquals(rsp, 1800)
end
