-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local skynet = require 'skynet'
local base_msg = require 'messages.base'
local enums = require 'macros.power_mgmt_enums'
local power_mgmt_metric = require 'power_mgmt_metric'

TestPowerMgmtMetric = {}

function TestPowerMgmtMetric:test_get_system_inputpower_consumption()
    local power_mgmt_metric_mock = {}

    local c_psu_object = require 'device.psu'
    local origin_fold_func = c_psu_object.collection.fold
    local psu_objs = {
        {
            InputPowerWatts = 100
        },
        {
            InputPowerWatts = 200
        }
    }
    c_psu_object.collection.fold = function (_, func, acc)
        local exit_loop = false
        for _, psu_obj in pairs(psu_objs) do
            acc, exit_loop = func(acc, psu_obj)
            if exit_loop then
                break
            end
        end
        return acc
    end


    local ok, rsp = pcall(function ()
        return power_mgmt_metric.get_system_inputpower_consumption(power_mgmt_metric_mock)
    end)
    lu.assertTrue(ok)
    lu.assertEquals(rsp, 300)

    c_psu_object.collection.fold = origin_fold_func
end

function TestPowerMgmtMetric:test_get_system_rated_power()
    local power_mgmt_metric_mock = {}

    local c_psu_object = require 'device.psu'
    local origin_fold_func = c_psu_object.collection.fold
    local psu_objs = {
        {
            Rate = 1000
        },
        {
            Rate = 2000
        }
    }
    c_psu_object.collection.fold = function (_, func, acc)
        local exit_loop = false
        for _, psu_obj in pairs(psu_objs) do
            acc, exit_loop = func(acc, psu_obj)
            if exit_loop then
                break
            end
        end
        return acc
    end


    local ok, rsp = pcall(function ()
        return power_mgmt_metric.get_system_rated_power(power_mgmt_metric_mock)
    end)
    lu.assertTrue(ok)
    lu.assertEquals(rsp, 3000)

    c_psu_object.collection.fold = origin_fold_func
end