local lu = require 'luaunit'
local power_distribution_mgmt = require 'power_distribution_mgmt'
local skynet = require 'skynet'
local power_mgmt_utils = require 'power_mgmt_utils'
local enums = require 'macros.power_mgmt_enums'
local c_psu_object = require 'device.psu'

-- PowerDistributionMgmt 测试用例
TestPowerDistributionMgmt = {}

local function mock_cabinet_software_type()
    local old_get_instance = power_mgmt_utils.get_instance
    power_mgmt_utils.get_instance = function ()
        return {
            get_chassis_type = function ()
                return enums.SOFTWARE_TYPE.CABINET
            end
        }
    end
    return function ()
        power_mgmt_utils.get_instance = old_get_instance
    end
end

-- 场景：新增 PowerDistribution 对象时，按 Id 正常加入缓存
function TestPowerDistributionMgmt:test_object_add_callback_add_new_object()
    local power_distribution_mgmt = require 'power_distribution_mgmt'
    power_distribution_mgmt.power_distribution_objs = {}
    local obj = {
        path = '/bmc/kepler/Systems/1/PowerMgmt/PowerDistribution/01',
        EquipmentType = 'PowerDistribution'
    }
    power_distribution_mgmt:object_add_callback(obj)
    lu.assertEquals(power_distribution_mgmt.power_distribution_objs[1], obj)
end

-- 场景：重复添加相同 Id 的 PowerDistribution 对象时，保持原有对象不被覆盖
function TestPowerDistributionMgmt:test_object_add_callback_duplicate_id()
    local power_distribution_mgmt = require 'power_distribution_mgmt'
    local origin = {
        path = '/bmc/kepler/Systems/1/PowerMgmt/PowerDistribution/02',
        EquipmentType = 'PowerDistribution'
    }
    power_distribution_mgmt.power_distribution_objs = { [2] = origin }
    local new_obj = {
        path = '/bmc/kepler/Systems/1/PowerMgmt/PowerDistribution/02',
        EquipmentType = 'PowerDistribution'
    }
    power_distribution_mgmt:object_add_callback(new_obj)
    lu.assertEquals(power_distribution_mgmt.power_distribution_objs[2], origin)
end