-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local pmbus_upgrade = require 'device_tree.adapters.power_mgmt.protocol.upgrade.pmbus_upgrade'
local fw_def = require 'device_tree.adapters.power_mgmt.protocol.upgrade.fw_def'

TestPmbusUpgrade = {}

upgrade = pmbus_upgrade(self).new()

function TestPmbusUpgrade:test_switch_app()
    local _, rsp = pcall(upgrade.switch_app, upgrade, 1)
    lu.assertFalse(rsp)
end

function TestPmbusUpgrade:test_restart_app_check()
    soft_info = {soft_id = fw_def.FIRMWARE.QB_SOFT}
    local _, rsp = pcall(upgrade.restart_app_check, upgrade, soft_info)
    lu.assertTrue(rsp == "")
end