-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

TestPmbusQb900 = {}

local psu_slot = {
    ['SlotNumber'] = 1,
    ['PsuChip'] = {
        ['bmc.kepler.Chip.BlockIO'] = {}
    }
}

function TestPmbusQb900:test_status_input()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)

    -- 打桩
    pmbus.get_status_input = function()
        return 0x90
    end
    pmbus.get_status_temperature = function()
        return 0x00
    end
    pmbus.get_status_vout = function()
        return 0x00
    end
    pmbus.get_status_iout = function()
        return 0x00
    end

    local health_event = pmbus:get_health_event()
    lu.assertEquals(0x10, health_event.event)
    lu.assertEquals(1, pmbus:check_input_loss(health_event.event))
end

function TestPmbusQb900:test_status_temperature()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)

    -- 打桩
    pmbus.get_status_input = function()
        return 0x00
    end
    pmbus.get_status_temperature = function()
        return 0xf0
    end
    pmbus.get_status_vout = function()
        return 0x00
    end
    pmbus.get_status_iout = function()
        return 0x00
    end

    local health_event = pmbus:get_health_event()
    lu.assertEquals(health_event.event, 0x08)
    lu.assertEquals(pmbus:check_input_loss(health_event.event), 0)
    lu.assertEquals(health_event.temper_fault, 0xf0)
end

function TestPmbusQb900:test_get_output_current_amps()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)
    -- 打桩
    pmbus.chip_read = function()
        return string.pack('H', 0x8c)
    end

    local output_current = pmbus:get_output_current_amps()
    lu.assertEquals(output_current, 1.4)
end

function TestPmbusQb900:test_check_input_loss()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)

    lu.assertEquals(pmbus:check_input_loss(0x00), 0)
    lu.assertEquals(pmbus:check_input_loss(0x10), 1)
end

function TestPmbusQb900:test_get_status_cml()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)
    -- 打桩
    pmbus.chip_read = function()
        return string.pack('H', 0x7e)
    end
    local status_cml = pmbus:get_status_cml()
    lu.assertEquals(status_cml, 0x7e)
end

function TestPmbusQb900:test_get_soft_version()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)

    -- 打桩 utils，避免访问真实 frequency_limit_log
    pmbus.utils = {
        frequency_limit_log = function(...) end
    }

    lu.assertEquals(pmbus:get_soft_version(nil), nil)
end

function TestPmbusQb900:test_get_firmware_version()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)

    -- 打桩
    pmbus.chip_read = function()
        return string.pack('H', 0xf3)
    end
    lu.assertEquals(pmbus:get_firmware_version(), 'QB:0f3')
end

function TestPmbusQb900:test_get_output_voltage()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)
    -- 打桩
    pmbus.chip_read = function()
        return string.pack('H', 0x8B)
    end
    local output_voltage = pmbus:get_output_current_amps()
    lu.assertEquals(output_voltage, 1.39)
end

function TestPmbusQb900:test_get_power_supply_type()
    local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus_qb900'.new(psu_slot)
    -- 打桩
    pmbus.chip_wordread = function()
        return 1
    end
    lu.assertEquals(pmbus:get_power_supply_type(), 1)
end
