-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local log_service = require 'log_service'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local skynet = require 'skynet'

local log_def = {
    PS_POWER_DROP_FLAG = 0
}

TestLogService = {}

function TestLogService:test_log_dump()
    local path = './'
    local ok = pcall(function ()
        log_service:dump_psu_info(path)
    end)
    lu.assertTrue(ok)
end

function TestLogService:test_init()

    local tmp = {
        db = {
            AclostRecordTable = function()
                return{
                    Id = "AclostRecord",
                    ResetFlag = 1,
                    Flag = 0,
                    CurTime = 0
                }
            end
        },
        gpio_work = {
            start_module = function(module)
            end
        },
        get_ac_lost_flag = function()end,
        aclost_int_task = function(aclost_record)end
    }

    local tmp2= {
        g_test_mode = 0,
        aclost_record = {
            ResetFlag = 0,
            ShieldAclostEventRecord = 1
        },
        sync_reset_type = function() return 0 end
    }

    local ok = pcall(function ()
        log_service.init(tmp)
    end)
    lu.assertTrue(ok)
    log_service.g_test_mode = 0
    log_service.aclost_int_task({})
    log_service.get_ac_lost_flag(tmp2)
end

function TestLogService:test_aclost_check_task()
    local aclost_record = {
        Id = "AclostRecord",
        ResetFlag = 1,
        Flag = 85,
        CurTime = 0}
    local bus
    local ok = pcall(function ()
        log_service:aclost_check_task(bus, aclost_record)
    end)
    lu.assertTrue(ok)
end

function TestLogService:test_aclost_check_task_1()
    local aclost_record = {
        Id = "AclostRecord",
        ResetFlag = 2,
        Flag = 85,
        CurTime = 0}
    local bus
    local ok = pcall(function ()
        log_service:aclost_check_task(bus, aclost_record)
    end)
    lu.assertTrue(ok)
end

function TestLogService:test_cal_ac_timestamps()
    log_service.event_time = 31536666
    log_service.event_time_source = "gpio"
    local ok, time = pcall(function ()
        return log_service:cal_ac_timestamps()
    end)
    lu.assertTrue(ok)
    lu.assertEquals(time, "1971-01-01 08:11:06 UTC")

    log_service.event_time = 31536666
    log_service.event_time_source = ""
    local ok, time = pcall(function ()
        return log_service:cal_ac_timestamps()
    end)
    lu.assertTrue(ok)
    lu.assertEquals(time, "1971-01-01 08:16:06 UTC")

    log_service.event_time = 0
    local ok, time = pcall(function ()
        return log_service:cal_ac_timestamps()
    end)
    lu.assertTrue(ok)
    lu.assertEquals(time, os.date("%Y-%m-%d %H:%M:%S UTC", os.time() - 180))
end

function TestLogService:test_dump_log()
    local path = '/'
    log_service.dump_psu_info = function (path)
        return false
    end
    log_service.dump_objs_info = function (path)
        return false
    end
    local ok = pcall(function ()
        log_service:dump_log(path)
    end)
    lu.assertTrue(ok)
end