-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local life_prediction_model = require 'life_prediction_model'

TestLifePredictionModel = {}

function TestLifePredictionModel:test_predicted_lifespan_normal()
    local model_params = {
        [0x0100] = 100,
        [0x0101] = 200,
        [0x0102] = 150
    }
    local ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan(model_params)
    end)
    lu.assertTrue(ok)
    lu.assertNotNil(lifespan)
    lu.assertIsNumber(lifespan)
    -- 验证计算公式: 260000000 - (4.76*100 + 7.32*200 + 11.1*150)
    -- = 260000000 - (476 + 1464 + 1665) = 260000000 - 3605 = 259996395
    lu.assertTrue(lifespan > 0)
end

function TestLifePredictionModel:test_predicted_lifespan_nil_params()
    local ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan(nil)
    end)
    lu.assertTrue(ok)
    lu.assertNil(lifespan)
end

function TestLifePredictionModel:test_predicted_lifespan_invalid_type()
    local ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan("invalid")
    end)
    lu.assertTrue(ok)
    lu.assertNil(lifespan)

    ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan(123)
    end)
    lu.assertTrue(ok)
    lu.assertNil(lifespan)
end

function TestLifePredictionModel:test_predicted_lifespan_invalid_index()
    local model_params = {
        [0x9999] = 100
    }
    local ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan(model_params)
    end)
    lu.assertTrue(ok)
    lu.assertNil(lifespan)
end

function TestLifePredictionModel:test_predicted_lifespan_ceil()
    local model_params = {
        [0x0100] = 1
    }
    local ok, lifespan = pcall(function()
        return life_prediction_model.predicted_lifespan(model_params)
    end)
    lu.assertTrue(ok)
    lu.assertNotNil(lifespan)
    lu.assertIsNumber(lifespan)
    -- 验证结果向上取整
    lu.assertEquals(lifespan, math.ceil(260000000 - 4.76))
end

function TestLifePredictionModel:test_get_model_level()
    local ok, level = pcall(function()
        return life_prediction_model.get_model_level()
    end)
    lu.assertTrue(ok)
    -- 深度5档、频率6档、温度8档: 5 << 8 | 6 << 4 | 8 = 0x568
    lu.assertEquals(level, 0x568)
end

