-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local power_mgmt_mock = (require 'debug.lualib.power_mgmt_mock').get_instance()

TestPowerMgmtInit = {}

function TestPowerMgmtInit:test_creat_dump_task_1()
    local tmp = {
        psu_instance = {
            get_psu_property = function(s, psu_id, path)
                return ''
            end
        },
        task = {
            create = function (psu_id, path)
                return 1
            end
        }
    }
    local task_id = power_mgmt_mock.creat_dump_task(tmp)
    lu.assertEquals(task_id, 1)
end

function TestPowerMgmtInit:test_creat_dump_task_2()
    local tmp = {
        psu_instance = {
            get_psu_property = function(s, psu_id, path)
                return ''
            end
        },
        task = {
            create = function (psu_id, path)
                return nil
            end
        }
    }
    local ok = pcall(function()
        return power_mgmt_mock.creat_dump_task(tmp)
    end)
    lu.assertEquals(ok, false)
end

function TestPowerMgmtInit:test_destroy_dump_task()
    local tmp = {
        task = {
            destroy_task_by_id = function (task_id)
                return
            end
        }
    }
    local ok = pcall(function()
        return power_mgmt_mock.destroy_dump_task(tmp, 1)
    end)
    lu.assertEquals(ok, true)
end

function TestPowerMgmtInit:test_write_ps_black_box_log()
    local tmp = {
        utils_instance = {
            get_bmc_time = function()
                return '2025-06-21'
            end
        },
        psu_instance = {
            psm_get_black_box_info = function(psu_id)
                return {
                    [1] = {
                        serial_number = 1,
                        black_box_max_length = 32,
                        black_box_data = 'ssssssssssssssssssssssssssssssss'
                    }
                }
            end
        }
    }
    local ok = pcall(function()
        return power_mgmt_mock.write_ps_black_box_log(tmp, 1)
    end)
    lu.assertEquals(ok, true)
end

function TestPowerMgmtInit:test_dump_psu_blackbox()
    local tmp = {
        creat_dump_task = function(psu_id)
            return 1
        end,
        write_ps_black_box_log = function(psu_id)
            return
        end,
        destrop_dump_task = function(task_id)
            return
        end
    }
    local task_id = power_mgmt_mock.dump_psu_blackbox(tmp, 1)
    lu.assertEquals(task_id, 1)
end