-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local enums = require 'macros.power_mgmt_enums'

TestFp1600 = {}
local E_OK = nil -- 函数执行成功返回nil
local E_FAILED = '' -- 空错误信息

local psu_slot = {
    ['SlotNumber'] = 1,
    ['PsuChip'] = {
        ['bmc.kepler.Chip.BlockIO'] = {}
    }
}

function TestFp1600:test_output_voltage_050302()
    local pmbus = require 'device_tree.adapters.14060876_00000001050302064319.PsuSlot'
    -- 打桩
    pmbus.get_power_supply_info = function(parameter)
        return enums.POWER_MODEL.FP1600
    end
    pmbus.prop_value = {}
    pmbus.prop_value['output_voltage'] = 0
    pmbus.protocol = {}
    pmbus.protocol['get_input_voltage'] = function()
        return 45
    end
    pmbus.protocol['get_output_voltage'] = function()
        return pmbus.prop_value['output_voltage']
    end
    function pmbus:dal_refresh_property(prop, value)
        self.prop_value[prop] = value
    end

    local rsp, _ = pmbus:get_output_voltage()

    lu.assertEquals(rsp, E_OK)
    lu.assertEquals(10, pmbus.protocol['get_output_voltage']())

    
    pmbus.protocol['get_input_voltage'] = function()
        return 47.25
    end
    rsp, _ = pmbus:get_output_voltage()

    lu.assertEquals(rsp, E_OK)
    lu.assertEquals(11, pmbus.protocol['get_output_voltage']())
end

function TestFp1600:test_status_input_080302()
    local pmbus = require 'device_tree.adapters.14060876_00000001080302064319.PsuSlot'
    -- 打桩
    pmbus.get_power_supply_info = function(parameter)
        return enums.POWER_MODEL.FP1600
    end
    pmbus.prop_value = {}
    pmbus.prop_value['output_voltage'] = 0
    pmbus.protocol = {}
    pmbus.protocol['get_input_voltage'] = function()
        return 45
    end
    pmbus.protocol['get_output_voltage'] = function()
        return pmbus.prop_value['output_voltage']
    end
    function pmbus:dal_refresh_property(prop, value)
        self.prop_value[prop] = value
    end

    local rsp, _ = pmbus:get_output_voltage()

    lu.assertEquals(rsp, E_OK)
    lu.assertEquals(10, pmbus.protocol['get_output_voltage']())

    
    pmbus.protocol['get_input_voltage'] = function()
        return 47.25
    end
    rsp, _ = pmbus:get_output_voltage()

    lu.assertEquals(rsp, E_OK)
    lu.assertEquals(11, pmbus.protocol['get_output_voltage']())
end