-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local enums = require 'macros.power_mgmt_enums'

TestCanbusPah = {}

function TestCanbusPah:test_canbus_ms_channel_switch()
    local canbus_pah = require 'device_tree.adapters.power_mgmt.protocol.canbus_pah'
    -- 打桩
    canbus_pah.utils = {}
    canbus_pah.utils.frequency_limit_log = function(level, interval_s, fmt, ...)
        return 1
    end
    canbus_pah.canbus_chip = {}
    canbus_pah.canbus_chip.main_channel_fail_nums = 1
    canbus_pah.canbus_chip.main_channel = 0
    canbus_pah.canbus_chip.current_channel = 1
    local flag = 0
    local ok = pcall(function()
        return canbus_pah.canbus_ms_channel_switch(canbus_pah, flag)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel_fail_nums, 0)
    flag = 1
    ok = pcall(function()
        return canbus_pah.canbus_ms_channel_switch(canbus_pah, flag)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel_fail_nums, 1)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel, 0)
    lu.assertEquals(canbus_pah.canbus_chip.current_channel, 1)
    canbus_pah.canbus_chip.main_channel = 1
    ok = pcall(function()
        return canbus_pah.canbus_ms_channel_switch(canbus_pah, flag)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel_fail_nums, 2)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel, 1)
    lu.assertEquals(canbus_pah.canbus_chip.current_channel, 1)
end

function TestCanbusPah:test_canbus_check_ms_channel()
    local canbus_pah = require 'device_tree.adapters.power_mgmt.protocol.canbus_pah'
    -- 打桩
    canbus_pah.canbus_chip = {}
    canbus_pah.canbus_chip.can0_chip = {}
    canbus_pah.canbus_chip.can1_chip = {}
    canbus_pah.canbus_chip.can0_chip.WriteRead = function()
        return 1
    end
    local ok, value = pcall(function()
        return canbus_pah.canbus_check_ms_channel(canbus_pah, 0)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(value, '')
end

function TestCanbusPah:test_canbus_recover_to_main_channel()
    local canbus_pah = require 'device_tree.adapters.power_mgmt.protocol.canbus_pah'
    -- 打桩
    canbus_pah.canbus_chip = {}
    canbus_pah.canbus_chip.current_channel = 0
    canbus_pah.canbus_chip.main_channel = 0
    local ok = pcall(function()
        return canbus_pah.canbus_recover_to_main_channel(canbus_pah)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah.canbus_chip.current_channel, 0)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel, 0)
    canbus_pah.canbus_check_ms_channel = function()
        return nil
    end
    canbus_pah.canbus_chip.current_channel = 0
    canbus_pah.canbus_chip.main_channel = 1
    canbus_pah.canbus_chip.main_channel_fail_nums = 10
    ok = pcall(function()
        return canbus_pah.canbus_recover_to_main_channel(canbus_pah)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah.canbus_chip.current_channel, 1)
    lu.assertEquals(canbus_pah.canbus_chip.main_channel_fail_nums, 0)
end

function TestCanbusPah:test_chip_write_read()
    local canbus_pah = require 'device_tree.adapters.power_mgmt.protocol.canbus_pah'
    -- 打桩
    canbus_pah.canbus_chip.current_channel = 0
    canbus_pah.canbus_chip.can1_chip = {}
    canbus_pah.canbus_chip.can0_chip = {}
    canbus_pah.canbus_chip.can1_chip.WriteRead = function()
        return 1
    end
    local canbus_send_data = {
        cnt = 0,
        reserve = 0x0,
        ms = 0,
        cmd = 0,
        addr = 0x0,
        protocol = 0,
        frame_type = 0,
        sigid_and_error = 0,
        data = 0,
    }
    local ok, value = pcall(function()
        return canbus_pah.chip_write_read(canbus_pah, canbus_send_data)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(value, nil)
end