-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local enums = require 'macros.power_mgmt_enums'

local mock_protocol = {
    refresh_batch_query_info = function() return {} end,
    canbus_ms_channel_switch = function () end,
    can_get_canbus_basic_info = function () return true end,
    canbus_recover_to_main_channel = function () end,
}

local mock_psu = {
    protocol = mock_protocol,
    ps_id = 1,
    prop_value = {},
    scan_status = 0,
    refresh_info_nums = 0,
    read_fail_count = 0
}

TestCanbusPahMonitor = {}

function TestCanbusPahMonitor:test_refresh_batch_query_info()
    local canbus_pah_monitor = require 'device_tree.adapters.power_mgmt.protocol.monitor.canbus_pah'(mock_psu)
    -- 打桩
    canbus_pah_monitor.protocol = {}
    canbus_pah_monitor.protocol.refresh_batch_query_info = function ()
        return {}
    end
    canbus_pah_monitor.dal_refresh_property = function ()
        return
    end
    canbus_pah_monitor.protocol.canbus_ms_channel_switch = function ()
        return
    end
    local ok = pcall(function (...)
        canbus_pah_monitor.refresh_batch_query_info(canbus_pah_monitor)
    end)
    lu.assertEquals(ok, true)
end

function TestCanbusPahMonitor:test_update_health_event()
    local canbus_pah_monitor = require 'device_tree.adapters.power_mgmt.protocol.monitor.canbus_pah'(mock_psu)
    -- 打桩
    canbus_pah_monitor.dal_refresh_property = function ()
        return
    end
    local alarm_status = 3
    local ok, value = pcall(function (...)
        canbus_pah_monitor.update_health_event(canbus_pah_monitor, alarm_status)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(value, nil)
end

function TestCanbusPahMonitor:test_update_communication_status()
    local canbus_pah_monitor = require 'device_tree.adapters.power_mgmt.protocol.monitor.canbus_pah'(mock_psu)
    -- 打桩
    canbus_pah_monitor.refresh_info_nums = 10
    canbus_pah_monitor.read_fail_count = 1
    canbus_pah_monitor.protocol = {}
    canbus_pah_monitor.protocol.can_get_canbus_basic_info = function ()
        return {}
    end
    canbus_pah_monitor.dal_refresh_property = function ()
        return
    end
    local ok = pcall(function (...)
        canbus_pah_monitor.update_communication_status(canbus_pah_monitor)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(canbus_pah_monitor.refresh_info_nums, 0)
    lu.assertEquals(canbus_pah_monitor.read_fail_count, 0)
end