-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local singleton = require 'mc.singleton'
local class = require 'mc.class'

local power_supplies_service = class()

function power_supplies_service:ctor(db)
    self.db = db
end

function power_supplies_service:init()
    local db_data = self.db:select(self.db.PowerSupplies):first()
    if not db_data then
        db_data = self.db.PowerSupplies(
            {
                Id = 1,
                RetransferDelaySeconds = 1800 -- 默认值
            }
        )
        db_data:save()
        log:notice('Initializing the PowerSupplies database successfully')
    end
end

function power_supplies_service:get_retransfer_delay_seconds()
    local db_data = self.db:select(self.db.PowerSupplies):first()
    return db_data.RetransferDelaySeconds
end

function power_supplies_service:set_retransfer_delay_seconds(value)
    self.db.PowerSupplies(
        {
            Id = 1,
            RetransferDelaySeconds = value
        }
    ):save()
end

return singleton(power_supplies_service)