-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local singleton = require 'mc.singleton'
local c_psu_object = require 'device.psu'

local power_mgmt_metric = class()

function power_mgmt_metric:ctor()

end


function power_mgmt_metric:get_system_inputpower_consumption()
    local system_inputpower_consumption = 0 -- 所有电源输入功耗总和
    c_psu_object.collection:fold(function (_, psu_obj)
        system_inputpower_consumption = system_inputpower_consumption + psu_obj.InputPowerWatts
    end)

    return system_inputpower_consumption
end

function power_mgmt_metric:get_system_rated_power()
    local system_rated_power = 0 -- 所有电源额定功耗
    c_psu_object.collection:fold(function (_, psu_obj)
        system_rated_power = system_rated_power + psu_obj.Rate
    end)
    return system_rated_power
end

return singleton(power_mgmt_metric)