-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local c_psu_object = require 'device.psu'
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local skynet = require 'skynet'
local power_mgmt_utils = require 'power_mgmt_utils'
local enums = require 'macros.power_mgmt_enums'

local E_OK <const> = nil -- 函数执行成功返回nil
local E_FAILED <const> = '' -- 空错误信息

local power_distribution_mgmt = class()

function power_distribution_mgmt:ctor()
    self.power_distribution_objs = {}
end

function power_distribution_mgmt:object_add_callback(object)
    local id_str = string.match(object.path, "(%d+)$")
    local id = tonumber(id_str)
    if not id then
        log:error('Add PowerDistribution object failed, invalid path format: %s', object.path)
        return
    end
    if self.power_distribution_objs[id] then
        log:error('Add PowerDistribution object failed, duplicate Id: %s', id)
        return
    end
    self.power_distribution_objs[id] = object
    log:notice('Add PowerDistribution object successfully, Id: %s, EquipmentType: %s', id, object.EquipmentType)
end


function power_distribution_mgmt:init()

end

return singleton(power_distribution_mgmt)
