-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local Singleton = require 'mc.singleton'
local log = require 'mc.logging'

local power_mgmt = class()

function power_mgmt:ctor()
    self.obj = nil
end

function power_mgmt:set_obj(object)
    if not object then
        return
    end
    log:debug("Set power mgmt object successfully")
    self.obj = object
end

function power_mgmt:set_value(prop, value)
    log:debug("Set power mgmt prop: %s, value: %s", prop, value)
    self.obj[prop] = value
end

return Singleton(power_mgmt)