-- Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local custom_msg = require 'messages.custom'

local power_supplies = require 'power_supplies_service'
local utils = require 'power_mgmt_utils'

local customize_config = {}

local function customize_retransfer_delay_seconds(self, ctx, customize_data)
    local err_msg = string.format("/%s/%s", 'CustomSettings', 'BMCSet_RetransferDelaySeconds')
    local delay_seconds = customize_data.BMCSet_RetransferDelaySeconds.Value
    if delay_seconds < 10 or delay_seconds > 16200 then
        log:error('The BMCSet_RetransferDelaySeconds(%s) is invalid', delay_seconds)
        utils.operation_log(ctx, "Set retransfer delay seconds failed")
        error(custom_msg.CollectingConfigurationErrorDesc(err_msg))
    end
    power_supplies.get_instance():set_retransfer_delay_seconds(delay_seconds)
    utils.operation_log(ctx, "Set retransfer delay seconds successfully")
end

local config_customize_func_table = {
    ['BMCSet_RetransferDelaySeconds'] = { customize_func = customize_retransfer_delay_seconds }
}

function customize_config:on_import(ctx, customize_data)
    for prop, _ in pairs(customize_data) do
        local customize_table = config_customize_func_table[prop]
        if not customize_table then
            log:error('Customize prop [%s] is invalid', prop)
            goto continue
        end
        if customize_table.customize_func then
            customize_table.customize_func(self, ctx, customize_data)
        end
        ::continue::
    end
end

function customize_config:on_export(ctx)
    local ret = {}
    ret.BMCSet_RetransferDelaySeconds = power_supplies.get_instance():get_retransfer_delay_seconds()
    log:notice('Export customize config successfully')
    return ret
end

return customize_config
