-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Uart = {}

---@class Uart.PortTxConnectUartTxRsp
local TPortTxConnectUartTxRsp = {}
TPortTxConnectUartTxRsp.__index = TPortTxConnectUartTxRsp
TPortTxConnectUartTxRsp.group = {}

local function TPortTxConnectUartTxRsp_from_obj(obj)
    return setmetatable(obj, TPortTxConnectUartTxRsp)
end

function TPortTxConnectUartTxRsp.new()
    return TPortTxConnectUartTxRsp_from_obj({})
end
---@param obj Uart.PortTxConnectUartTxRsp
function TPortTxConnectUartTxRsp:init_from_obj(obj)

end

function TPortTxConnectUartTxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortTxConnectUartTxRsp.group)
end

TPortTxConnectUartTxRsp.from_obj = TPortTxConnectUartTxRsp_from_obj

TPortTxConnectUartTxRsp.proto_property = {}

TPortTxConnectUartTxRsp.default = {}

TPortTxConnectUartTxRsp.struct = {}

function TPortTxConnectUartTxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPortTxConnectUartTxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortTxConnectUartTxRsp.proto_property, errs, need_convert)
    return self
end

function TPortTxConnectUartTxRsp:unpack(_)
end

Uart.PortTxConnectUartTxRsp = TPortTxConnectUartTxRsp

---@class Uart.PortTxConnectUartTxReq
---@field SrcPort integer
---@field DestUart integer
local TPortTxConnectUartTxReq = {}
TPortTxConnectUartTxReq.__index = TPortTxConnectUartTxReq
TPortTxConnectUartTxReq.group = {}

local function TPortTxConnectUartTxReq_from_obj(obj)
    return setmetatable(obj, TPortTxConnectUartTxReq)
end

function TPortTxConnectUartTxReq.new(SrcPort, DestUart)
    return TPortTxConnectUartTxReq_from_obj({SrcPort = SrcPort, DestUart = DestUart})
end
---@param obj Uart.PortTxConnectUartTxReq
function TPortTxConnectUartTxReq:init_from_obj(obj)
    self.SrcPort = obj.SrcPort
    self.DestUart = obj.DestUart
end

function TPortTxConnectUartTxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortTxConnectUartTxReq.group)
end

TPortTxConnectUartTxReq.from_obj = TPortTxConnectUartTxReq_from_obj

TPortTxConnectUartTxReq.proto_property = {'SrcPort', 'DestUart'}

TPortTxConnectUartTxReq.default = {0, 0}

TPortTxConnectUartTxReq.struct = {
    {name = 'SrcPort', is_array = false, struct = nil}, {name = 'DestUart', is_array = false, struct = nil}
}

function TPortTxConnectUartTxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcPort', self.SrcPort, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestUart', self.DestUart, 'uint32', false, errs, need_convert)

    TPortTxConnectUartTxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortTxConnectUartTxReq.proto_property, errs, need_convert)
    return self
end

function TPortTxConnectUartTxReq:unpack(_)
    return self.SrcPort, self.DestUart
end

Uart.PortTxConnectUartTxReq = TPortTxConnectUartTxReq

---@class Uart.PortTxConnectPortRxRsp
local TPortTxConnectPortRxRsp = {}
TPortTxConnectPortRxRsp.__index = TPortTxConnectPortRxRsp
TPortTxConnectPortRxRsp.group = {}

local function TPortTxConnectPortRxRsp_from_obj(obj)
    return setmetatable(obj, TPortTxConnectPortRxRsp)
end

function TPortTxConnectPortRxRsp.new()
    return TPortTxConnectPortRxRsp_from_obj({})
end
---@param obj Uart.PortTxConnectPortRxRsp
function TPortTxConnectPortRxRsp:init_from_obj(obj)

end

function TPortTxConnectPortRxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortTxConnectPortRxRsp.group)
end

TPortTxConnectPortRxRsp.from_obj = TPortTxConnectPortRxRsp_from_obj

TPortTxConnectPortRxRsp.proto_property = {}

TPortTxConnectPortRxRsp.default = {}

TPortTxConnectPortRxRsp.struct = {}

function TPortTxConnectPortRxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPortTxConnectPortRxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortTxConnectPortRxRsp.proto_property, errs, need_convert)
    return self
end

function TPortTxConnectPortRxRsp:unpack(_)
end

Uart.PortTxConnectPortRxRsp = TPortTxConnectPortRxRsp

---@class Uart.PortTxConnectPortRxReq
---@field SrcPort integer
---@field DestPort integer
local TPortTxConnectPortRxReq = {}
TPortTxConnectPortRxReq.__index = TPortTxConnectPortRxReq
TPortTxConnectPortRxReq.group = {}

local function TPortTxConnectPortRxReq_from_obj(obj)
    return setmetatable(obj, TPortTxConnectPortRxReq)
end

function TPortTxConnectPortRxReq.new(SrcPort, DestPort)
    return TPortTxConnectPortRxReq_from_obj({SrcPort = SrcPort, DestPort = DestPort})
end
---@param obj Uart.PortTxConnectPortRxReq
function TPortTxConnectPortRxReq:init_from_obj(obj)
    self.SrcPort = obj.SrcPort
    self.DestPort = obj.DestPort
end

function TPortTxConnectPortRxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortTxConnectPortRxReq.group)
end

TPortTxConnectPortRxReq.from_obj = TPortTxConnectPortRxReq_from_obj

TPortTxConnectPortRxReq.proto_property = {'SrcPort', 'DestPort'}

TPortTxConnectPortRxReq.default = {0, 0}

TPortTxConnectPortRxReq.struct = {
    {name = 'SrcPort', is_array = false, struct = nil}, {name = 'DestPort', is_array = false, struct = nil}
}

function TPortTxConnectPortRxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcPort', self.SrcPort, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs, need_convert)

    TPortTxConnectPortRxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortTxConnectPortRxReq.proto_property, errs, need_convert)
    return self
end

function TPortTxConnectPortRxReq:unpack(_)
    return self.SrcPort, self.DestPort
end

Uart.PortTxConnectPortRxReq = TPortTxConnectPortRxReq

---@class Uart.UartRxConnectPortRxRsp
local TUartRxConnectPortRxRsp = {}
TUartRxConnectPortRxRsp.__index = TUartRxConnectPortRxRsp
TUartRxConnectPortRxRsp.group = {}

local function TUartRxConnectPortRxRsp_from_obj(obj)
    return setmetatable(obj, TUartRxConnectPortRxRsp)
end

function TUartRxConnectPortRxRsp.new()
    return TUartRxConnectPortRxRsp_from_obj({})
end
---@param obj Uart.UartRxConnectPortRxRsp
function TUartRxConnectPortRxRsp:init_from_obj(obj)

end

function TUartRxConnectPortRxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartRxConnectPortRxRsp.group)
end

TUartRxConnectPortRxRsp.from_obj = TUartRxConnectPortRxRsp_from_obj

TUartRxConnectPortRxRsp.proto_property = {}

TUartRxConnectPortRxRsp.default = {}

TUartRxConnectPortRxRsp.struct = {}

function TUartRxConnectPortRxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartRxConnectPortRxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartRxConnectPortRxRsp.proto_property, errs, need_convert)
    return self
end

function TUartRxConnectPortRxRsp:unpack(_)
end

Uart.UartRxConnectPortRxRsp = TUartRxConnectPortRxRsp

---@class Uart.UartRxConnectPortRxReq
---@field SrcUart integer
---@field DestPort integer
local TUartRxConnectPortRxReq = {}
TUartRxConnectPortRxReq.__index = TUartRxConnectPortRxReq
TUartRxConnectPortRxReq.group = {}

local function TUartRxConnectPortRxReq_from_obj(obj)
    return setmetatable(obj, TUartRxConnectPortRxReq)
end

function TUartRxConnectPortRxReq.new(SrcUart, DestPort)
    return TUartRxConnectPortRxReq_from_obj({SrcUart = SrcUart, DestPort = DestPort})
end
---@param obj Uart.UartRxConnectPortRxReq
function TUartRxConnectPortRxReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestPort = obj.DestPort
end

function TUartRxConnectPortRxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartRxConnectPortRxReq.group)
end

TUartRxConnectPortRxReq.from_obj = TUartRxConnectPortRxReq_from_obj

TUartRxConnectPortRxReq.proto_property = {'SrcUart', 'DestPort'}

TUartRxConnectPortRxReq.default = {0, 0}

TUartRxConnectPortRxReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil}, {name = 'DestPort', is_array = false, struct = nil}
}

function TUartRxConnectPortRxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs, need_convert)

    TUartRxConnectPortRxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartRxConnectPortRxReq.proto_property, errs, need_convert)
    return self
end

function TUartRxConnectPortRxReq:unpack(_)
    return self.SrcUart, self.DestPort
end

Uart.UartRxConnectPortRxReq = TUartRxConnectPortRxReq

---@class Uart.UartRxConnectUartTxRsp
local TUartRxConnectUartTxRsp = {}
TUartRxConnectUartTxRsp.__index = TUartRxConnectUartTxRsp
TUartRxConnectUartTxRsp.group = {}

local function TUartRxConnectUartTxRsp_from_obj(obj)
    return setmetatable(obj, TUartRxConnectUartTxRsp)
end

function TUartRxConnectUartTxRsp.new()
    return TUartRxConnectUartTxRsp_from_obj({})
end
---@param obj Uart.UartRxConnectUartTxRsp
function TUartRxConnectUartTxRsp:init_from_obj(obj)

end

function TUartRxConnectUartTxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartRxConnectUartTxRsp.group)
end

TUartRxConnectUartTxRsp.from_obj = TUartRxConnectUartTxRsp_from_obj

TUartRxConnectUartTxRsp.proto_property = {}

TUartRxConnectUartTxRsp.default = {}

TUartRxConnectUartTxRsp.struct = {}

function TUartRxConnectUartTxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartRxConnectUartTxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartRxConnectUartTxRsp.proto_property, errs, need_convert)
    return self
end

function TUartRxConnectUartTxRsp:unpack(_)
end

Uart.UartRxConnectUartTxRsp = TUartRxConnectUartTxRsp

---@class Uart.UartRxConnectUartTxReq
---@field SrcUart integer
---@field DestUart integer
local TUartRxConnectUartTxReq = {}
TUartRxConnectUartTxReq.__index = TUartRxConnectUartTxReq
TUartRxConnectUartTxReq.group = {}

local function TUartRxConnectUartTxReq_from_obj(obj)
    return setmetatable(obj, TUartRxConnectUartTxReq)
end

function TUartRxConnectUartTxReq.new(SrcUart, DestUart)
    return TUartRxConnectUartTxReq_from_obj({SrcUart = SrcUart, DestUart = DestUart})
end
---@param obj Uart.UartRxConnectUartTxReq
function TUartRxConnectUartTxReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestUart = obj.DestUart
end

function TUartRxConnectUartTxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartRxConnectUartTxReq.group)
end

TUartRxConnectUartTxReq.from_obj = TUartRxConnectUartTxReq_from_obj

TUartRxConnectUartTxReq.proto_property = {'SrcUart', 'DestUart'}

TUartRxConnectUartTxReq.default = {0, 0}

TUartRxConnectUartTxReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil}, {name = 'DestUart', is_array = false, struct = nil}
}

function TUartRxConnectUartTxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestUart', self.DestUart, 'uint32', false, errs, need_convert)

    TUartRxConnectUartTxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartRxConnectUartTxReq.proto_property, errs, need_convert)
    return self
end

function TUartRxConnectUartTxReq:unpack(_)
    return self.SrcUart, self.DestUart
end

Uart.UartRxConnectUartTxReq = TUartRxConnectUartTxReq

---@class Uart.SetParityBitRsp
local TSetParityBitRsp = {}
TSetParityBitRsp.__index = TSetParityBitRsp
TSetParityBitRsp.group = {}

local function TSetParityBitRsp_from_obj(obj)
    return setmetatable(obj, TSetParityBitRsp)
end

function TSetParityBitRsp.new()
    return TSetParityBitRsp_from_obj({})
end
---@param obj Uart.SetParityBitRsp
function TSetParityBitRsp:init_from_obj(obj)

end

function TSetParityBitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetParityBitRsp.group)
end

TSetParityBitRsp.from_obj = TSetParityBitRsp_from_obj

TSetParityBitRsp.proto_property = {}

TSetParityBitRsp.default = {}

TSetParityBitRsp.struct = {}

function TSetParityBitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetParityBitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetParityBitRsp.proto_property, errs, need_convert)
    return self
end

function TSetParityBitRsp:unpack(_)
end

Uart.SetParityBitRsp = TSetParityBitRsp

---@class Uart.SetParityBitReq
---@field UartId integer
---@field ParityBit integer
local TSetParityBitReq = {}
TSetParityBitReq.__index = TSetParityBitReq
TSetParityBitReq.group = {}

local function TSetParityBitReq_from_obj(obj)
    return setmetatable(obj, TSetParityBitReq)
end

function TSetParityBitReq.new(UartId, ParityBit)
    return TSetParityBitReq_from_obj({UartId = UartId, ParityBit = ParityBit})
end
---@param obj Uart.SetParityBitReq
function TSetParityBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.ParityBit = obj.ParityBit
end

function TSetParityBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetParityBitReq.group)
end

TSetParityBitReq.from_obj = TSetParityBitReq_from_obj

TSetParityBitReq.proto_property = {'UartId', 'ParityBit'}

TSetParityBitReq.default = {0, 0}

TSetParityBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil}, {name = 'ParityBit', is_array = false, struct = nil}
}

function TSetParityBitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParityBit', self.ParityBit, 'uint8', false, errs, need_convert)

    TSetParityBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetParityBitReq.proto_property, errs, need_convert)
    return self
end

function TSetParityBitReq:unpack(_)
    return self.UartId, self.ParityBit
end

Uart.SetParityBitReq = TSetParityBitReq

---@class Uart.SetStopBitRsp
local TSetStopBitRsp = {}
TSetStopBitRsp.__index = TSetStopBitRsp
TSetStopBitRsp.group = {}

local function TSetStopBitRsp_from_obj(obj)
    return setmetatable(obj, TSetStopBitRsp)
end

function TSetStopBitRsp.new()
    return TSetStopBitRsp_from_obj({})
end
---@param obj Uart.SetStopBitRsp
function TSetStopBitRsp:init_from_obj(obj)

end

function TSetStopBitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStopBitRsp.group)
end

TSetStopBitRsp.from_obj = TSetStopBitRsp_from_obj

TSetStopBitRsp.proto_property = {}

TSetStopBitRsp.default = {}

TSetStopBitRsp.struct = {}

function TSetStopBitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetStopBitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStopBitRsp.proto_property, errs, need_convert)
    return self
end

function TSetStopBitRsp:unpack(_)
end

Uart.SetStopBitRsp = TSetStopBitRsp

---@class Uart.SetStopBitReq
---@field UartId integer
---@field StopBit integer
local TSetStopBitReq = {}
TSetStopBitReq.__index = TSetStopBitReq
TSetStopBitReq.group = {}

local function TSetStopBitReq_from_obj(obj)
    return setmetatable(obj, TSetStopBitReq)
end

function TSetStopBitReq.new(UartId, StopBit)
    return TSetStopBitReq_from_obj({UartId = UartId, StopBit = StopBit})
end
---@param obj Uart.SetStopBitReq
function TSetStopBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.StopBit = obj.StopBit
end

function TSetStopBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStopBitReq.group)
end

TSetStopBitReq.from_obj = TSetStopBitReq_from_obj

TSetStopBitReq.proto_property = {'UartId', 'StopBit'}

TSetStopBitReq.default = {0, 0}

TSetStopBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil}, {name = 'StopBit', is_array = false, struct = nil}
}

function TSetStopBitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'StopBit', self.StopBit, 'uint8', false, errs, need_convert)

    TSetStopBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStopBitReq.proto_property, errs, need_convert)
    return self
end

function TSetStopBitReq:unpack(_)
    return self.UartId, self.StopBit
end

Uart.SetStopBitReq = TSetStopBitReq

---@class Uart.SetDataBitRsp
local TSetDataBitRsp = {}
TSetDataBitRsp.__index = TSetDataBitRsp
TSetDataBitRsp.group = {}

local function TSetDataBitRsp_from_obj(obj)
    return setmetatable(obj, TSetDataBitRsp)
end

function TSetDataBitRsp.new()
    return TSetDataBitRsp_from_obj({})
end
---@param obj Uart.SetDataBitRsp
function TSetDataBitRsp:init_from_obj(obj)

end

function TSetDataBitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDataBitRsp.group)
end

TSetDataBitRsp.from_obj = TSetDataBitRsp_from_obj

TSetDataBitRsp.proto_property = {}

TSetDataBitRsp.default = {}

TSetDataBitRsp.struct = {}

function TSetDataBitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDataBitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDataBitRsp.proto_property, errs, need_convert)
    return self
end

function TSetDataBitRsp:unpack(_)
end

Uart.SetDataBitRsp = TSetDataBitRsp

---@class Uart.SetDataBitReq
---@field UartId integer
---@field DataBit integer
local TSetDataBitReq = {}
TSetDataBitReq.__index = TSetDataBitReq
TSetDataBitReq.group = {}

local function TSetDataBitReq_from_obj(obj)
    return setmetatable(obj, TSetDataBitReq)
end

function TSetDataBitReq.new(UartId, DataBit)
    return TSetDataBitReq_from_obj({UartId = UartId, DataBit = DataBit})
end
---@param obj Uart.SetDataBitReq
function TSetDataBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.DataBit = obj.DataBit
end

function TSetDataBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDataBitReq.group)
end

TSetDataBitReq.from_obj = TSetDataBitReq_from_obj

TSetDataBitReq.proto_property = {'UartId', 'DataBit'}

TSetDataBitReq.default = {0, 0}

TSetDataBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil}, {name = 'DataBit', is_array = false, struct = nil}
}

function TSetDataBitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DataBit', self.DataBit, 'uint8', false, errs, need_convert)

    TSetDataBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDataBitReq.proto_property, errs, need_convert)
    return self
end

function TSetDataBitReq:unpack(_)
    return self.UartId, self.DataBit
end

Uart.SetDataBitReq = TSetDataBitReq

---@class Uart.SetBaudRateRsp
local TSetBaudRateRsp = {}
TSetBaudRateRsp.__index = TSetBaudRateRsp
TSetBaudRateRsp.group = {}

local function TSetBaudRateRsp_from_obj(obj)
    return setmetatable(obj, TSetBaudRateRsp)
end

function TSetBaudRateRsp.new()
    return TSetBaudRateRsp_from_obj({})
end
---@param obj Uart.SetBaudRateRsp
function TSetBaudRateRsp:init_from_obj(obj)

end

function TSetBaudRateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBaudRateRsp.group)
end

TSetBaudRateRsp.from_obj = TSetBaudRateRsp_from_obj

TSetBaudRateRsp.proto_property = {}

TSetBaudRateRsp.default = {}

TSetBaudRateRsp.struct = {}

function TSetBaudRateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBaudRateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBaudRateRsp.proto_property, errs, need_convert)
    return self
end

function TSetBaudRateRsp:unpack(_)
end

Uart.SetBaudRateRsp = TSetBaudRateRsp

---@class Uart.SetBaudRateReq
---@field UartId integer
---@field BaudRate integer
local TSetBaudRateReq = {}
TSetBaudRateReq.__index = TSetBaudRateReq
TSetBaudRateReq.group = {}

local function TSetBaudRateReq_from_obj(obj)
    return setmetatable(obj, TSetBaudRateReq)
end

function TSetBaudRateReq.new(UartId, BaudRate)
    return TSetBaudRateReq_from_obj({UartId = UartId, BaudRate = BaudRate})
end
---@param obj Uart.SetBaudRateReq
function TSetBaudRateReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.BaudRate = obj.BaudRate
end

function TSetBaudRateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBaudRateReq.group)
end

TSetBaudRateReq.from_obj = TSetBaudRateReq_from_obj

TSetBaudRateReq.proto_property = {'UartId', 'BaudRate'}

TSetBaudRateReq.default = {0, 0}

TSetBaudRateReq.struct = {
    {name = 'UartId', is_array = false, struct = nil}, {name = 'BaudRate', is_array = false, struct = nil}
}

function TSetBaudRateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BaudRate', self.BaudRate, 'uint32', false, errs, need_convert)

    TSetBaudRateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBaudRateReq.proto_property, errs, need_convert)
    return self
end

function TSetBaudRateReq:unpack(_)
    return self.UartId, self.BaudRate
end

Uart.SetBaudRateReq = TSetBaudRateReq

---@class Uart.UartCloseRsp
local TUartCloseRsp = {}
TUartCloseRsp.__index = TUartCloseRsp
TUartCloseRsp.group = {}

local function TUartCloseRsp_from_obj(obj)
    return setmetatable(obj, TUartCloseRsp)
end

function TUartCloseRsp.new()
    return TUartCloseRsp_from_obj({})
end
---@param obj Uart.UartCloseRsp
function TUartCloseRsp:init_from_obj(obj)

end

function TUartCloseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartCloseRsp.group)
end

TUartCloseRsp.from_obj = TUartCloseRsp_from_obj

TUartCloseRsp.proto_property = {}

TUartCloseRsp.default = {}

TUartCloseRsp.struct = {}

function TUartCloseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartCloseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartCloseRsp.proto_property, errs, need_convert)
    return self
end

function TUartCloseRsp:unpack(_)
end

Uart.UartCloseRsp = TUartCloseRsp

---@class Uart.UartCloseReq
---@field UartId integer
local TUartCloseReq = {}
TUartCloseReq.__index = TUartCloseReq
TUartCloseReq.group = {}

local function TUartCloseReq_from_obj(obj)
    return setmetatable(obj, TUartCloseReq)
end

function TUartCloseReq.new(UartId)
    return TUartCloseReq_from_obj({UartId = UartId})
end
---@param obj Uart.UartCloseReq
function TUartCloseReq:init_from_obj(obj)
    self.UartId = obj.UartId
end

function TUartCloseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartCloseReq.group)
end

TUartCloseReq.from_obj = TUartCloseReq_from_obj

TUartCloseReq.proto_property = {'UartId'}

TUartCloseReq.default = {0}

TUartCloseReq.struct = {{name = 'UartId', is_array = false, struct = nil}}

function TUartCloseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)

    TUartCloseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartCloseReq.proto_property, errs, need_convert)
    return self
end

function TUartCloseReq:unpack(_)
    return self.UartId
end

Uart.UartCloseReq = TUartCloseReq

---@class Uart.UartOpenRsp
local TUartOpenRsp = {}
TUartOpenRsp.__index = TUartOpenRsp
TUartOpenRsp.group = {}

local function TUartOpenRsp_from_obj(obj)
    return setmetatable(obj, TUartOpenRsp)
end

function TUartOpenRsp.new()
    return TUartOpenRsp_from_obj({})
end
---@param obj Uart.UartOpenRsp
function TUartOpenRsp:init_from_obj(obj)

end

function TUartOpenRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartOpenRsp.group)
end

TUartOpenRsp.from_obj = TUartOpenRsp_from_obj

TUartOpenRsp.proto_property = {}

TUartOpenRsp.default = {}

TUartOpenRsp.struct = {}

function TUartOpenRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartOpenRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartOpenRsp.proto_property, errs, need_convert)
    return self
end

function TUartOpenRsp:unpack(_)
end

Uart.UartOpenRsp = TUartOpenRsp

---@class Uart.UartOpenReq
---@field UartId integer
---@field BaudRate integer
local TUartOpenReq = {}
TUartOpenReq.__index = TUartOpenReq
TUartOpenReq.group = {}

local function TUartOpenReq_from_obj(obj)
    return setmetatable(obj, TUartOpenReq)
end

function TUartOpenReq.new(UartId, BaudRate)
    return TUartOpenReq_from_obj({UartId = UartId, BaudRate = BaudRate})
end
---@param obj Uart.UartOpenReq
function TUartOpenReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.BaudRate = obj.BaudRate
end

function TUartOpenReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartOpenReq.group)
end

TUartOpenReq.from_obj = TUartOpenReq_from_obj

TUartOpenReq.proto_property = {'UartId', 'BaudRate'}

TUartOpenReq.default = {0, 0}

TUartOpenReq.struct = {
    {name = 'UartId', is_array = false, struct = nil}, {name = 'BaudRate', is_array = false, struct = nil}
}

function TUartOpenReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartId', self.UartId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BaudRate', self.BaudRate, 'uint32', false, errs, need_convert)

    TUartOpenReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartOpenReq.proto_property, errs, need_convert)
    return self
end

function TUartOpenReq:unpack(_)
    return self.UartId, self.BaudRate
end

Uart.UartOpenReq = TUartOpenReq

---@class Uart.QueryConnectionRsp
---@field UartConnection integer
---@field PortConnection integer
---@field UartPortEnable integer
local TQueryConnectionRsp = {}
TQueryConnectionRsp.__index = TQueryConnectionRsp
TQueryConnectionRsp.group = {}

local function TQueryConnectionRsp_from_obj(obj)
    return setmetatable(obj, TQueryConnectionRsp)
end

function TQueryConnectionRsp.new(UartConnection, PortConnection, UartPortEnable)
    return TQueryConnectionRsp_from_obj({
        UartConnection = UartConnection,
        PortConnection = PortConnection,
        UartPortEnable = UartPortEnable
    })
end
---@param obj Uart.QueryConnectionRsp
function TQueryConnectionRsp:init_from_obj(obj)
    self.UartConnection = obj.UartConnection
    self.PortConnection = obj.PortConnection
    self.UartPortEnable = obj.UartPortEnable
end

function TQueryConnectionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryConnectionRsp.group)
end

TQueryConnectionRsp.from_obj = TQueryConnectionRsp_from_obj

TQueryConnectionRsp.proto_property = {'UartConnection', 'PortConnection', 'UartPortEnable'}

TQueryConnectionRsp.default = {0, 0, 0}

TQueryConnectionRsp.struct = {
    {name = 'UartConnection', is_array = false, struct = nil},
    {name = 'PortConnection', is_array = false, struct = nil}, {name = 'UartPortEnable', is_array = false, struct = nil}
}

function TQueryConnectionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UartConnection', self.UartConnection, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PortConnection', self.PortConnection, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UartPortEnable', self.UartPortEnable, 'uint32', false, errs, need_convert)

    TQueryConnectionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryConnectionRsp.proto_property, errs, need_convert)
    return self
end

function TQueryConnectionRsp:unpack(_)
    return self.UartConnection, self.PortConnection, self.UartPortEnable
end

Uart.QueryConnectionRsp = TQueryConnectionRsp

---@class Uart.QueryConnectionReq
local TQueryConnectionReq = {}
TQueryConnectionReq.__index = TQueryConnectionReq
TQueryConnectionReq.group = {}

local function TQueryConnectionReq_from_obj(obj)
    return setmetatable(obj, TQueryConnectionReq)
end

function TQueryConnectionReq.new()
    return TQueryConnectionReq_from_obj({})
end
---@param obj Uart.QueryConnectionReq
function TQueryConnectionReq:init_from_obj(obj)

end

function TQueryConnectionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryConnectionReq.group)
end

TQueryConnectionReq.from_obj = TQueryConnectionReq_from_obj

TQueryConnectionReq.proto_property = {}

TQueryConnectionReq.default = {}

TQueryConnectionReq.struct = {}

function TQueryConnectionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TQueryConnectionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryConnectionReq.proto_property, errs, need_convert)
    return self
end

function TQueryConnectionReq:unpack(_)
end

Uart.QueryConnectionReq = TQueryConnectionReq

---@class Uart.PortConnectPortRsp
local TPortConnectPortRsp = {}
TPortConnectPortRsp.__index = TPortConnectPortRsp
TPortConnectPortRsp.group = {}

local function TPortConnectPortRsp_from_obj(obj)
    return setmetatable(obj, TPortConnectPortRsp)
end

function TPortConnectPortRsp.new()
    return TPortConnectPortRsp_from_obj({})
end
---@param obj Uart.PortConnectPortRsp
function TPortConnectPortRsp:init_from_obj(obj)

end

function TPortConnectPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortConnectPortRsp.group)
end

TPortConnectPortRsp.from_obj = TPortConnectPortRsp_from_obj

TPortConnectPortRsp.proto_property = {}

TPortConnectPortRsp.default = {}

TPortConnectPortRsp.struct = {}

function TPortConnectPortRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPortConnectPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortConnectPortRsp.proto_property, errs, need_convert)
    return self
end

function TPortConnectPortRsp:unpack(_)
end

Uart.PortConnectPortRsp = TPortConnectPortRsp

---@class Uart.PortConnectPortReq
---@field SrcPort integer
---@field DestPort integer
local TPortConnectPortReq = {}
TPortConnectPortReq.__index = TPortConnectPortReq
TPortConnectPortReq.group = {}

local function TPortConnectPortReq_from_obj(obj)
    return setmetatable(obj, TPortConnectPortReq)
end

function TPortConnectPortReq.new(SrcPort, DestPort)
    return TPortConnectPortReq_from_obj({SrcPort = SrcPort, DestPort = DestPort})
end
---@param obj Uart.PortConnectPortReq
function TPortConnectPortReq:init_from_obj(obj)
    self.SrcPort = obj.SrcPort
    self.DestPort = obj.DestPort
end

function TPortConnectPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortConnectPortReq.group)
end

TPortConnectPortReq.from_obj = TPortConnectPortReq_from_obj

TPortConnectPortReq.proto_property = {'SrcPort', 'DestPort'}

TPortConnectPortReq.default = {0, 0}

TPortConnectPortReq.struct = {
    {name = 'SrcPort', is_array = false, struct = nil}, {name = 'DestPort', is_array = false, struct = nil}
}

function TPortConnectPortReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcPort', self.SrcPort, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs, need_convert)

    TPortConnectPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortConnectPortReq.proto_property, errs, need_convert)
    return self
end

function TPortConnectPortReq:unpack(_)
    return self.SrcPort, self.DestPort
end

Uart.PortConnectPortReq = TPortConnectPortReq

---@class Uart.UartConnectPortRsp
local TUartConnectPortRsp = {}
TUartConnectPortRsp.__index = TUartConnectPortRsp
TUartConnectPortRsp.group = {}

local function TUartConnectPortRsp_from_obj(obj)
    return setmetatable(obj, TUartConnectPortRsp)
end

function TUartConnectPortRsp.new()
    return TUartConnectPortRsp_from_obj({})
end
---@param obj Uart.UartConnectPortRsp
function TUartConnectPortRsp:init_from_obj(obj)

end

function TUartConnectPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectPortRsp.group)
end

TUartConnectPortRsp.from_obj = TUartConnectPortRsp_from_obj

TUartConnectPortRsp.proto_property = {}

TUartConnectPortRsp.default = {}

TUartConnectPortRsp.struct = {}

function TUartConnectPortRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartConnectPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectPortRsp.proto_property, errs, need_convert)
    return self
end

function TUartConnectPortRsp:unpack(_)
end

Uart.UartConnectPortRsp = TUartConnectPortRsp

---@class Uart.UartConnectPortReq
---@field SrcUart integer
---@field DestPort integer
local TUartConnectPortReq = {}
TUartConnectPortReq.__index = TUartConnectPortReq
TUartConnectPortReq.group = {}

local function TUartConnectPortReq_from_obj(obj)
    return setmetatable(obj, TUartConnectPortReq)
end

function TUartConnectPortReq.new(SrcUart, DestPort)
    return TUartConnectPortReq_from_obj({SrcUart = SrcUart, DestPort = DestPort})
end
---@param obj Uart.UartConnectPortReq
function TUartConnectPortReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestPort = obj.DestPort
end

function TUartConnectPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectPortReq.group)
end

TUartConnectPortReq.from_obj = TUartConnectPortReq_from_obj

TUartConnectPortReq.proto_property = {'SrcUart', 'DestPort'}

TUartConnectPortReq.default = {0, 0}

TUartConnectPortReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil}, {name = 'DestPort', is_array = false, struct = nil}
}

function TUartConnectPortReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs, need_convert)

    TUartConnectPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectPortReq.proto_property, errs, need_convert)
    return self
end

function TUartConnectPortReq:unpack(_)
    return self.SrcUart, self.DestPort
end

Uart.UartConnectPortReq = TUartConnectPortReq

---@class Uart.UartConnectUartRsp
local TUartConnectUartRsp = {}
TUartConnectUartRsp.__index = TUartConnectUartRsp
TUartConnectUartRsp.group = {}

local function TUartConnectUartRsp_from_obj(obj)
    return setmetatable(obj, TUartConnectUartRsp)
end

function TUartConnectUartRsp.new()
    return TUartConnectUartRsp_from_obj({})
end
---@param obj Uart.UartConnectUartRsp
function TUartConnectUartRsp:init_from_obj(obj)

end

function TUartConnectUartRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectUartRsp.group)
end

TUartConnectUartRsp.from_obj = TUartConnectUartRsp_from_obj

TUartConnectUartRsp.proto_property = {}

TUartConnectUartRsp.default = {}

TUartConnectUartRsp.struct = {}

function TUartConnectUartRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUartConnectUartRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectUartRsp.proto_property, errs, need_convert)
    return self
end

function TUartConnectUartRsp:unpack(_)
end

Uart.UartConnectUartRsp = TUartConnectUartRsp

---@class Uart.UartConnectUartReq
---@field SrcUart integer
---@field DestUart integer
local TUartConnectUartReq = {}
TUartConnectUartReq.__index = TUartConnectUartReq
TUartConnectUartReq.group = {}

local function TUartConnectUartReq_from_obj(obj)
    return setmetatable(obj, TUartConnectUartReq)
end

function TUartConnectUartReq.new(SrcUart, DestUart)
    return TUartConnectUartReq_from_obj({SrcUart = SrcUart, DestUart = DestUart})
end
---@param obj Uart.UartConnectUartReq
function TUartConnectUartReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestUart = obj.DestUart
end

function TUartConnectUartReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectUartReq.group)
end

TUartConnectUartReq.from_obj = TUartConnectUartReq_from_obj

TUartConnectUartReq.proto_property = {'SrcUart', 'DestUart'}

TUartConnectUartReq.default = {0, 0}

TUartConnectUartReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil}, {name = 'DestUart', is_array = false, struct = nil}
}

function TUartConnectUartReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DestUart', self.DestUart, 'uint32', false, errs, need_convert)

    TUartConnectUartReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectUartReq.proto_property, errs, need_convert)
    return self
end

function TUartConnectUartReq:unpack(_)
    return self.SrcUart, self.DestUart
end

Uart.UartConnectUartReq = TUartConnectUartReq

Uart.interface = mdb.register_interface('bmc.kepler.Managers.Uart', {}, {
    UartConnectUart = {'a{ss}uu', '', TUartConnectUartReq, TUartConnectUartRsp},
    UartConnectPort = {'a{ss}uu', '', TUartConnectPortReq, TUartConnectPortRsp},
    PortConnectPort = {'a{ss}uu', '', TPortConnectPortReq, TPortConnectPortRsp},
    QueryConnection = {'a{ss}', 'uuu', TQueryConnectionReq, TQueryConnectionRsp},
    UartOpen = {'a{ss}yu', '', TUartOpenReq, TUartOpenRsp},
    UartClose = {'a{ss}y', '', TUartCloseReq, TUartCloseRsp},
    SetBaudRate = {'a{ss}yu', '', TSetBaudRateReq, TSetBaudRateRsp},
    SetDataBit = {'a{ss}yy', '', TSetDataBitReq, TSetDataBitRsp},
    SetStopBit = {'a{ss}yy', '', TSetStopBitReq, TSetStopBitRsp},
    SetParityBit = {'a{ss}yy', '', TSetParityBitReq, TSetParityBitRsp},
    UartRxConnectUartTx = {'a{ss}uu', '', TUartRxConnectUartTxReq, TUartRxConnectUartTxRsp},
    UartRxConnectPortRx = {'a{ss}uu', '', TUartRxConnectPortRxReq, TUartRxConnectPortRxRsp},
    PortTxConnectPortRx = {'a{ss}uu', '', TPortTxConnectPortRxReq, TPortTxConnectPortRxRsp},
    PortTxConnectUartTx = {'a{ss}uu', '', TPortTxConnectUartTxReq, TPortTxConnectUartTxRsp}
}, {})

return Uart
