-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local TransferConfiguration = {}

---@class TransferConfiguration.RetransferDelaySeconds
---@field RetransferDelaySeconds integer
local TRetransferDelaySeconds = {}
TRetransferDelaySeconds.__index = TRetransferDelaySeconds
TRetransferDelaySeconds.group = {}

local function TRetransferDelaySeconds_from_obj(obj)
    return setmetatable(obj, TRetransferDelaySeconds)
end

function TRetransferDelaySeconds.new(RetransferDelaySeconds)
    return TRetransferDelaySeconds_from_obj({RetransferDelaySeconds = RetransferDelaySeconds})
end
---@param obj TransferConfiguration.RetransferDelaySeconds
function TRetransferDelaySeconds:init_from_obj(obj)
    self.RetransferDelaySeconds = obj.RetransferDelaySeconds
end

function TRetransferDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRetransferDelaySeconds.group)
end

TRetransferDelaySeconds.from_obj = TRetransferDelaySeconds_from_obj

TRetransferDelaySeconds.proto_property = {'RetransferDelaySeconds'}

TRetransferDelaySeconds.default = {0}

TRetransferDelaySeconds.struct = {{name = 'RetransferDelaySeconds', is_array = false, struct = nil}}

function TRetransferDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RetransferDelaySeconds', self.RetransferDelaySeconds, 'uint32', false, errs,
        need_convert)

    TRetransferDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRetransferDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TRetransferDelaySeconds:unpack(_)
    return self.RetransferDelaySeconds
end

TransferConfiguration.RetransferDelaySeconds = TRetransferDelaySeconds

---@class TransferConfiguration.CurrentPowerSupplyCircuit
---@field CurrentPowerSupplyCircuit string
local TCurrentPowerSupplyCircuit = {}
TCurrentPowerSupplyCircuit.__index = TCurrentPowerSupplyCircuit
TCurrentPowerSupplyCircuit.group = {}

local function TCurrentPowerSupplyCircuit_from_obj(obj)
    return setmetatable(obj, TCurrentPowerSupplyCircuit)
end

function TCurrentPowerSupplyCircuit.new(CurrentPowerSupplyCircuit)
    return TCurrentPowerSupplyCircuit_from_obj({CurrentPowerSupplyCircuit = CurrentPowerSupplyCircuit})
end
---@param obj TransferConfiguration.CurrentPowerSupplyCircuit
function TCurrentPowerSupplyCircuit:init_from_obj(obj)
    self.CurrentPowerSupplyCircuit = obj.CurrentPowerSupplyCircuit
end

function TCurrentPowerSupplyCircuit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentPowerSupplyCircuit.group)
end

TCurrentPowerSupplyCircuit.from_obj = TCurrentPowerSupplyCircuit_from_obj

TCurrentPowerSupplyCircuit.proto_property = {'CurrentPowerSupplyCircuit'}

TCurrentPowerSupplyCircuit.default = {''}

TCurrentPowerSupplyCircuit.struct = {{name = 'CurrentPowerSupplyCircuit', is_array = false, struct = nil}}

function TCurrentPowerSupplyCircuit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentPowerSupplyCircuit', self.CurrentPowerSupplyCircuit, 'string', true, errs,
        need_convert)

    if self.CurrentPowerSupplyCircuit ~= nil then
        validate.Enum(prefix .. 'CurrentPowerSupplyCircuit', self.CurrentPowerSupplyCircuit, '', {
            'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant', 'ParityCrossRedundant'
        }, errs, need_convert)
    end

    TCurrentPowerSupplyCircuit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentPowerSupplyCircuit.proto_property, errs, need_convert)
    return self
end

function TCurrentPowerSupplyCircuit:unpack(_)
    return self.CurrentPowerSupplyCircuit
end

TransferConfiguration.CurrentPowerSupplyCircuit = TCurrentPowerSupplyCircuit

---@class TransferConfiguration.ExpectedPowerSupplyCircuit
---@field ExpectedPowerSupplyCircuit string
local TExpectedPowerSupplyCircuit = {}
TExpectedPowerSupplyCircuit.__index = TExpectedPowerSupplyCircuit
TExpectedPowerSupplyCircuit.group = {}

local function TExpectedPowerSupplyCircuit_from_obj(obj)
    return setmetatable(obj, TExpectedPowerSupplyCircuit)
end

function TExpectedPowerSupplyCircuit.new(ExpectedPowerSupplyCircuit)
    return TExpectedPowerSupplyCircuit_from_obj({ExpectedPowerSupplyCircuit = ExpectedPowerSupplyCircuit})
end
---@param obj TransferConfiguration.ExpectedPowerSupplyCircuit
function TExpectedPowerSupplyCircuit:init_from_obj(obj)
    self.ExpectedPowerSupplyCircuit = obj.ExpectedPowerSupplyCircuit
end

function TExpectedPowerSupplyCircuit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedPowerSupplyCircuit.group)
end

TExpectedPowerSupplyCircuit.from_obj = TExpectedPowerSupplyCircuit_from_obj

TExpectedPowerSupplyCircuit.proto_property = {'ExpectedPowerSupplyCircuit'}

TExpectedPowerSupplyCircuit.default = {''}

TExpectedPowerSupplyCircuit.struct = {{name = 'ExpectedPowerSupplyCircuit', is_array = false, struct = nil}}

function TExpectedPowerSupplyCircuit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedPowerSupplyCircuit', self.ExpectedPowerSupplyCircuit, 'string', true, errs,
        need_convert)

    if self.ExpectedPowerSupplyCircuit ~= nil then
        validate.Enum(prefix .. 'ExpectedPowerSupplyCircuit', self.ExpectedPowerSupplyCircuit, '', {
            'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant', 'ParityCrossRedundant'
        }, errs, need_convert)
    end

    TExpectedPowerSupplyCircuit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedPowerSupplyCircuit.proto_property, errs, need_convert)
    return self
end

function TExpectedPowerSupplyCircuit:unpack(_)
    return self.ExpectedPowerSupplyCircuit
end

TransferConfiguration.ExpectedPowerSupplyCircuit = TExpectedPowerSupplyCircuit

---@class TransferConfiguration.SetExpectedPowerSupplyCircuitRsp
---@field TaskId integer
local TSetExpectedPowerSupplyCircuitRsp = {}
TSetExpectedPowerSupplyCircuitRsp.__index = TSetExpectedPowerSupplyCircuitRsp
TSetExpectedPowerSupplyCircuitRsp.group = {}

local function TSetExpectedPowerSupplyCircuitRsp_from_obj(obj)
    return setmetatable(obj, TSetExpectedPowerSupplyCircuitRsp)
end

function TSetExpectedPowerSupplyCircuitRsp.new(TaskId)
    return TSetExpectedPowerSupplyCircuitRsp_from_obj({TaskId = TaskId})
end
---@param obj TransferConfiguration.SetExpectedPowerSupplyCircuitRsp
function TSetExpectedPowerSupplyCircuitRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TSetExpectedPowerSupplyCircuitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetExpectedPowerSupplyCircuitRsp.group)
end

TSetExpectedPowerSupplyCircuitRsp.from_obj = TSetExpectedPowerSupplyCircuitRsp_from_obj

TSetExpectedPowerSupplyCircuitRsp.proto_property = {'TaskId'}

TSetExpectedPowerSupplyCircuitRsp.default = {0}

TSetExpectedPowerSupplyCircuitRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TSetExpectedPowerSupplyCircuitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TSetExpectedPowerSupplyCircuitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetExpectedPowerSupplyCircuitRsp.proto_property, errs, need_convert)
    return self
end

function TSetExpectedPowerSupplyCircuitRsp:unpack(_)
    return self.TaskId
end

TransferConfiguration.SetExpectedPowerSupplyCircuitRsp = TSetExpectedPowerSupplyCircuitRsp

---@class TransferConfiguration.SetExpectedPowerSupplyCircuitReq
---@field PowerSupplyCircuit string
local TSetExpectedPowerSupplyCircuitReq = {}
TSetExpectedPowerSupplyCircuitReq.__index = TSetExpectedPowerSupplyCircuitReq
TSetExpectedPowerSupplyCircuitReq.group = {}

local function TSetExpectedPowerSupplyCircuitReq_from_obj(obj)
    return setmetatable(obj, TSetExpectedPowerSupplyCircuitReq)
end

function TSetExpectedPowerSupplyCircuitReq.new(PowerSupplyCircuit)
    return TSetExpectedPowerSupplyCircuitReq_from_obj({PowerSupplyCircuit = PowerSupplyCircuit})
end
---@param obj TransferConfiguration.SetExpectedPowerSupplyCircuitReq
function TSetExpectedPowerSupplyCircuitReq:init_from_obj(obj)
    self.PowerSupplyCircuit = obj.PowerSupplyCircuit
end

function TSetExpectedPowerSupplyCircuitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetExpectedPowerSupplyCircuitReq.group)
end

TSetExpectedPowerSupplyCircuitReq.from_obj = TSetExpectedPowerSupplyCircuitReq_from_obj

TSetExpectedPowerSupplyCircuitReq.proto_property = {'PowerSupplyCircuit'}

TSetExpectedPowerSupplyCircuitReq.default = {''}

TSetExpectedPowerSupplyCircuitReq.struct = {{name = 'PowerSupplyCircuit', is_array = false, struct = nil}}

function TSetExpectedPowerSupplyCircuitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, 'string', false, errs, need_convert)

    if self.PowerSupplyCircuit ~= nil then
        validate.Enum(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, '', {
            'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant', 'ParityCrossRedundant'
        }, errs, need_convert)
    end

    TSetExpectedPowerSupplyCircuitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetExpectedPowerSupplyCircuitReq.proto_property, errs, need_convert)
    return self
end

function TSetExpectedPowerSupplyCircuitReq:unpack(_)
    return self.PowerSupplyCircuit
end

TransferConfiguration.SetExpectedPowerSupplyCircuitReq = TSetExpectedPowerSupplyCircuitReq

TransferConfiguration.interface = mdb.register_interface(
    'bmc.kepler.PowerEquipment.PowerDistribution.TransferConfiguration', {
        ExpectedPowerSupplyCircuit = {'s', {'EMIT_CHANGE'}, true, nil},
        CurrentPowerSupplyCircuit = {'s', {'EMIT_CHANGE'}, true, nil},
        RetransferDelaySeconds = {'u', {}, false, nil}
    }, {
        SetExpectedPowerSupplyCircuit = {
            'a{ss}s', 'u', TSetExpectedPowerSupplyCircuitReq, TSetExpectedPowerSupplyCircuitRsp
        }
    }, {})

return TransferConfiguration
