-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local TransferConfig = {}

---@class TransferConfig.UnderVoltageRMSPercent
---@field UnderVoltageRMSPercent integer
local TUnderVoltageRMSPercent = {}
TUnderVoltageRMSPercent.__index = TUnderVoltageRMSPercent
TUnderVoltageRMSPercent.group = {}

local function TUnderVoltageRMSPercent_from_obj(obj)
    return setmetatable(obj, TUnderVoltageRMSPercent)
end

function TUnderVoltageRMSPercent.new(UnderVoltageRMSPercent)
    return TUnderVoltageRMSPercent_from_obj({UnderVoltageRMSPercent = UnderVoltageRMSPercent or 255})
end
---@param obj TransferConfig.UnderVoltageRMSPercent
function TUnderVoltageRMSPercent:init_from_obj(obj)
    self.UnderVoltageRMSPercent = obj.UnderVoltageRMSPercent or 255
end

function TUnderVoltageRMSPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnderVoltageRMSPercent.group)
end

TUnderVoltageRMSPercent.from_obj = TUnderVoltageRMSPercent_from_obj

TUnderVoltageRMSPercent.proto_property = {'UnderVoltageRMSPercent'}

TUnderVoltageRMSPercent.default = {0}

TUnderVoltageRMSPercent.struct = {{name = 'UnderVoltageRMSPercent', is_array = false, struct = nil}}

function TUnderVoltageRMSPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnderVoltageRMSPercent', self.UnderVoltageRMSPercent, 'uint8', false, errs,
        need_convert)

    TUnderVoltageRMSPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnderVoltageRMSPercent.proto_property, errs, need_convert)
    return self
end

function TUnderVoltageRMSPercent:unpack(_)
    return self.UnderVoltageRMSPercent
end

TransferConfig.UnderVoltageRMSPercent = TUnderVoltageRMSPercent

---@class TransferConfig.UnderNominalFrequencyHz
---@field UnderNominalFrequencyHz number
local TUnderNominalFrequencyHz = {}
TUnderNominalFrequencyHz.__index = TUnderNominalFrequencyHz
TUnderNominalFrequencyHz.group = {}

local function TUnderNominalFrequencyHz_from_obj(obj)
    return setmetatable(obj, TUnderNominalFrequencyHz)
end

function TUnderNominalFrequencyHz.new(UnderNominalFrequencyHz)
    return TUnderNominalFrequencyHz_from_obj({UnderNominalFrequencyHz = UnderNominalFrequencyHz})
end
---@param obj TransferConfig.UnderNominalFrequencyHz
function TUnderNominalFrequencyHz:init_from_obj(obj)
    self.UnderNominalFrequencyHz = obj.UnderNominalFrequencyHz
end

function TUnderNominalFrequencyHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnderNominalFrequencyHz.group)
end

TUnderNominalFrequencyHz.from_obj = TUnderNominalFrequencyHz_from_obj

TUnderNominalFrequencyHz.proto_property = {'UnderNominalFrequencyHz'}

TUnderNominalFrequencyHz.default = {0}

TUnderNominalFrequencyHz.struct = {{name = 'UnderNominalFrequencyHz', is_array = false, struct = nil}}

function TUnderNominalFrequencyHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnderNominalFrequencyHz', self.UnderNominalFrequencyHz, 'double', false, errs,
        need_convert)

    TUnderNominalFrequencyHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnderNominalFrequencyHz.proto_property, errs, need_convert)
    return self
end

function TUnderNominalFrequencyHz:unpack(_)
    return self.UnderNominalFrequencyHz
end

TransferConfig.UnderNominalFrequencyHz = TUnderNominalFrequencyHz

---@class TransferConfig.TransferSensitivity
---@field TransferSensitivity string
local TTransferSensitivity = {}
TTransferSensitivity.__index = TTransferSensitivity
TTransferSensitivity.group = {}

local function TTransferSensitivity_from_obj(obj)
    return setmetatable(obj, TTransferSensitivity)
end

function TTransferSensitivity.new(TransferSensitivity)
    return TTransferSensitivity_from_obj({TransferSensitivity = TransferSensitivity})
end
---@param obj TransferConfig.TransferSensitivity
function TTransferSensitivity:init_from_obj(obj)
    self.TransferSensitivity = obj.TransferSensitivity
end

function TTransferSensitivity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransferSensitivity.group)
end

TTransferSensitivity.from_obj = TTransferSensitivity_from_obj

TTransferSensitivity.proto_property = {'TransferSensitivity'}

TTransferSensitivity.default = {''}

TTransferSensitivity.struct = {{name = 'TransferSensitivity', is_array = false, struct = nil}}

function TTransferSensitivity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransferSensitivity', self.TransferSensitivity, 'string', false, errs, need_convert)

    if self.TransferSensitivity ~= nil then
        validate.Enum(prefix .. 'TransferSensitivity', self.TransferSensitivity, '', {'Low', 'Medium', 'High', ''},
            errs, need_convert)
    end

    TTransferSensitivity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransferSensitivity.proto_property, errs, need_convert)
    return self
end

function TTransferSensitivity:unpack(_)
    return self.TransferSensitivity
end

TransferConfig.TransferSensitivity = TTransferSensitivity

---@class TransferConfig.OverVoltageRMSPercent
---@field OverVoltageRMSPercent integer
local TOverVoltageRMSPercent = {}
TOverVoltageRMSPercent.__index = TOverVoltageRMSPercent
TOverVoltageRMSPercent.group = {}

local function TOverVoltageRMSPercent_from_obj(obj)
    return setmetatable(obj, TOverVoltageRMSPercent)
end

function TOverVoltageRMSPercent.new(OverVoltageRMSPercent)
    return TOverVoltageRMSPercent_from_obj({OverVoltageRMSPercent = OverVoltageRMSPercent or 255})
end
---@param obj TransferConfig.OverVoltageRMSPercent
function TOverVoltageRMSPercent:init_from_obj(obj)
    self.OverVoltageRMSPercent = obj.OverVoltageRMSPercent or 255
end

function TOverVoltageRMSPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOverVoltageRMSPercent.group)
end

TOverVoltageRMSPercent.from_obj = TOverVoltageRMSPercent_from_obj

TOverVoltageRMSPercent.proto_property = {'OverVoltageRMSPercent'}

TOverVoltageRMSPercent.default = {0}

TOverVoltageRMSPercent.struct = {{name = 'OverVoltageRMSPercent', is_array = false, struct = nil}}

function TOverVoltageRMSPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OverVoltageRMSPercent', self.OverVoltageRMSPercent, 'uint8', false, errs, need_convert)

    TOverVoltageRMSPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOverVoltageRMSPercent.proto_property, errs, need_convert)
    return self
end

function TOverVoltageRMSPercent:unpack(_)
    return self.OverVoltageRMSPercent
end

TransferConfig.OverVoltageRMSPercent = TOverVoltageRMSPercent

---@class TransferConfig.OverNominalFrequencyHz
---@field OverNominalFrequencyHz number
local TOverNominalFrequencyHz = {}
TOverNominalFrequencyHz.__index = TOverNominalFrequencyHz
TOverNominalFrequencyHz.group = {}

local function TOverNominalFrequencyHz_from_obj(obj)
    return setmetatable(obj, TOverNominalFrequencyHz)
end

function TOverNominalFrequencyHz.new(OverNominalFrequencyHz)
    return TOverNominalFrequencyHz_from_obj({OverNominalFrequencyHz = OverNominalFrequencyHz})
end
---@param obj TransferConfig.OverNominalFrequencyHz
function TOverNominalFrequencyHz:init_from_obj(obj)
    self.OverNominalFrequencyHz = obj.OverNominalFrequencyHz
end

function TOverNominalFrequencyHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOverNominalFrequencyHz.group)
end

TOverNominalFrequencyHz.from_obj = TOverNominalFrequencyHz_from_obj

TOverNominalFrequencyHz.proto_property = {'OverNominalFrequencyHz'}

TOverNominalFrequencyHz.default = {0}

TOverNominalFrequencyHz.struct = {{name = 'OverNominalFrequencyHz', is_array = false, struct = nil}}

function TOverNominalFrequencyHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OverNominalFrequencyHz', self.OverNominalFrequencyHz, 'double', false, errs,
        need_convert)

    TOverNominalFrequencyHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOverNominalFrequencyHz.proto_property, errs, need_convert)
    return self
end

function TOverNominalFrequencyHz:unpack(_)
    return self.OverNominalFrequencyHz
end

TransferConfig.OverNominalFrequencyHz = TOverNominalFrequencyHz

---@class TransferConfig.TransferDelaySeconds
---@field TransferDelaySeconds integer
local TTransferDelaySeconds = {}
TTransferDelaySeconds.__index = TTransferDelaySeconds
TTransferDelaySeconds.group = {}

local function TTransferDelaySeconds_from_obj(obj)
    return setmetatable(obj, TTransferDelaySeconds)
end

function TTransferDelaySeconds.new(TransferDelaySeconds)
    return TTransferDelaySeconds_from_obj({TransferDelaySeconds = TransferDelaySeconds or 4294967295})
end
---@param obj TransferConfig.TransferDelaySeconds
function TTransferDelaySeconds:init_from_obj(obj)
    self.TransferDelaySeconds = obj.TransferDelaySeconds or 4294967295
end

function TTransferDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransferDelaySeconds.group)
end

TTransferDelaySeconds.from_obj = TTransferDelaySeconds_from_obj

TTransferDelaySeconds.proto_property = {'TransferDelaySeconds'}

TTransferDelaySeconds.default = {0}

TTransferDelaySeconds.struct = {{name = 'TransferDelaySeconds', is_array = false, struct = nil}}

function TTransferDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransferDelaySeconds', self.TransferDelaySeconds, 'uint32', false, errs, need_convert)

    TTransferDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransferDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TTransferDelaySeconds:unpack(_)
    return self.TransferDelaySeconds
end

TransferConfig.TransferDelaySeconds = TTransferDelaySeconds

---@class TransferConfig.TransferInhibit
---@field TransferInhibit boolean
local TTransferInhibit = {}
TTransferInhibit.__index = TTransferInhibit
TTransferInhibit.group = {}

local function TTransferInhibit_from_obj(obj)
    return setmetatable(obj, TTransferInhibit)
end

function TTransferInhibit.new(TransferInhibit)
    return TTransferInhibit_from_obj({TransferInhibit = TransferInhibit})
end
---@param obj TransferConfig.TransferInhibit
function TTransferInhibit:init_from_obj(obj)
    self.TransferInhibit = obj.TransferInhibit
end

function TTransferInhibit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransferInhibit.group)
end

TTransferInhibit.from_obj = TTransferInhibit_from_obj

TTransferInhibit.proto_property = {'TransferInhibit'}

TTransferInhibit.default = {false}

TTransferInhibit.struct = {{name = 'TransferInhibit', is_array = false, struct = nil}}

function TTransferInhibit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransferInhibit', self.TransferInhibit, 'bool', false, errs, need_convert)

    TTransferInhibit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransferInhibit.proto_property, errs, need_convert)
    return self
end

function TTransferInhibit:unpack(_)
    return self.TransferInhibit
end

TransferConfig.TransferInhibit = TTransferInhibit

---@class TransferConfig.RetransferEnabled
---@field RetransferEnabled boolean
local TRetransferEnabled = {}
TRetransferEnabled.__index = TRetransferEnabled
TRetransferEnabled.group = {}

local function TRetransferEnabled_from_obj(obj)
    return setmetatable(obj, TRetransferEnabled)
end

function TRetransferEnabled.new(RetransferEnabled)
    return TRetransferEnabled_from_obj({RetransferEnabled = RetransferEnabled})
end
---@param obj TransferConfig.RetransferEnabled
function TRetransferEnabled:init_from_obj(obj)
    self.RetransferEnabled = obj.RetransferEnabled
end

function TRetransferEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRetransferEnabled.group)
end

TRetransferEnabled.from_obj = TRetransferEnabled_from_obj

TRetransferEnabled.proto_property = {'RetransferEnabled'}

TRetransferEnabled.default = {false}

TRetransferEnabled.struct = {{name = 'RetransferEnabled', is_array = false, struct = nil}}

function TRetransferEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RetransferEnabled', self.RetransferEnabled, 'bool', false, errs, need_convert)

    TRetransferEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRetransferEnabled.proto_property, errs, need_convert)
    return self
end

function TRetransferEnabled:unpack(_)
    return self.RetransferEnabled
end

TransferConfig.RetransferEnabled = TRetransferEnabled

---@class TransferConfig.RetransferDelaySeconds
---@field RetransferDelaySeconds integer
local TRetransferDelaySeconds = {}
TRetransferDelaySeconds.__index = TRetransferDelaySeconds
TRetransferDelaySeconds.group = {}

local function TRetransferDelaySeconds_from_obj(obj)
    return setmetatable(obj, TRetransferDelaySeconds)
end

function TRetransferDelaySeconds.new(RetransferDelaySeconds)
    return TRetransferDelaySeconds_from_obj({RetransferDelaySeconds = RetransferDelaySeconds or 4294967295})
end
---@param obj TransferConfig.RetransferDelaySeconds
function TRetransferDelaySeconds:init_from_obj(obj)
    self.RetransferDelaySeconds = obj.RetransferDelaySeconds or 4294967295
end

function TRetransferDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRetransferDelaySeconds.group)
end

TRetransferDelaySeconds.from_obj = TRetransferDelaySeconds_from_obj

TRetransferDelaySeconds.proto_property = {'RetransferDelaySeconds'}

TRetransferDelaySeconds.default = {0}

TRetransferDelaySeconds.struct = {{name = 'RetransferDelaySeconds', is_array = false, struct = nil}}

function TRetransferDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RetransferDelaySeconds', self.RetransferDelaySeconds, 'uint32', false, errs,
        need_convert)

    TRetransferDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRetransferDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TRetransferDelaySeconds:unpack(_)
    return self.RetransferDelaySeconds
end

TransferConfig.RetransferDelaySeconds = TRetransferDelaySeconds

---@class TransferConfig.PreferredMainsId
---@field PreferredMainsId string
local TPreferredMainsId = {}
TPreferredMainsId.__index = TPreferredMainsId
TPreferredMainsId.group = {}

local function TPreferredMainsId_from_obj(obj)
    return setmetatable(obj, TPreferredMainsId)
end

function TPreferredMainsId.new(PreferredMainsId)
    return TPreferredMainsId_from_obj({PreferredMainsId = PreferredMainsId})
end
---@param obj TransferConfig.PreferredMainsId
function TPreferredMainsId:init_from_obj(obj)
    self.PreferredMainsId = obj.PreferredMainsId
end

function TPreferredMainsId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreferredMainsId.group)
end

TPreferredMainsId.from_obj = TPreferredMainsId_from_obj

TPreferredMainsId.proto_property = {'PreferredMainsId'}

TPreferredMainsId.default = {''}

TPreferredMainsId.struct = {{name = 'PreferredMainsId', is_array = false, struct = nil}}

function TPreferredMainsId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreferredMainsId', self.PreferredMainsId, 'string', false, errs, need_convert)

    TPreferredMainsId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreferredMainsId.proto_property, errs, need_convert)
    return self
end

function TPreferredMainsId:unpack(_)
    return self.PreferredMainsId
end

TransferConfig.PreferredMainsId = TPreferredMainsId

---@class TransferConfig.ClosedTransitionTimeoutSeconds
---@field ClosedTransitionTimeoutSeconds integer
local TClosedTransitionTimeoutSeconds = {}
TClosedTransitionTimeoutSeconds.__index = TClosedTransitionTimeoutSeconds
TClosedTransitionTimeoutSeconds.group = {}

local function TClosedTransitionTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TClosedTransitionTimeoutSeconds)
end

function TClosedTransitionTimeoutSeconds.new(ClosedTransitionTimeoutSeconds)
    return TClosedTransitionTimeoutSeconds_from_obj({
        ClosedTransitionTimeoutSeconds = ClosedTransitionTimeoutSeconds or 4294967295
    })
end
---@param obj TransferConfig.ClosedTransitionTimeoutSeconds
function TClosedTransitionTimeoutSeconds:init_from_obj(obj)
    self.ClosedTransitionTimeoutSeconds = obj.ClosedTransitionTimeoutSeconds or 4294967295
end

function TClosedTransitionTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClosedTransitionTimeoutSeconds.group)
end

TClosedTransitionTimeoutSeconds.from_obj = TClosedTransitionTimeoutSeconds_from_obj

TClosedTransitionTimeoutSeconds.proto_property = {'ClosedTransitionTimeoutSeconds'}

TClosedTransitionTimeoutSeconds.default = {0}

TClosedTransitionTimeoutSeconds.struct = {{name = 'ClosedTransitionTimeoutSeconds', is_array = false, struct = nil}}

function TClosedTransitionTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ClosedTransitionTimeoutSeconds', self.ClosedTransitionTimeoutSeconds, 'uint32', false,
        errs, need_convert)

    TClosedTransitionTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClosedTransitionTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TClosedTransitionTimeoutSeconds:unpack(_)
    return self.ClosedTransitionTimeoutSeconds
end

TransferConfig.ClosedTransitionTimeoutSeconds = TClosedTransitionTimeoutSeconds

---@class TransferConfig.ClosedTransitionAllowed
---@field ClosedTransitionAllowed boolean
local TClosedTransitionAllowed = {}
TClosedTransitionAllowed.__index = TClosedTransitionAllowed
TClosedTransitionAllowed.group = {}

local function TClosedTransitionAllowed_from_obj(obj)
    return setmetatable(obj, TClosedTransitionAllowed)
end

function TClosedTransitionAllowed.new(ClosedTransitionAllowed)
    return TClosedTransitionAllowed_from_obj({ClosedTransitionAllowed = ClosedTransitionAllowed})
end
---@param obj TransferConfig.ClosedTransitionAllowed
function TClosedTransitionAllowed:init_from_obj(obj)
    self.ClosedTransitionAllowed = obj.ClosedTransitionAllowed
end

function TClosedTransitionAllowed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClosedTransitionAllowed.group)
end

TClosedTransitionAllowed.from_obj = TClosedTransitionAllowed_from_obj

TClosedTransitionAllowed.proto_property = {'ClosedTransitionAllowed'}

TClosedTransitionAllowed.default = {false}

TClosedTransitionAllowed.struct = {{name = 'ClosedTransitionAllowed', is_array = false, struct = nil}}

function TClosedTransitionAllowed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ClosedTransitionAllowed', self.ClosedTransitionAllowed, 'bool', false, errs,
        need_convert)

    TClosedTransitionAllowed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClosedTransitionAllowed.proto_property, errs, need_convert)
    return self
end

function TClosedTransitionAllowed:unpack(_)
    return self.ClosedTransitionAllowed
end

TransferConfig.ClosedTransitionAllowed = TClosedTransitionAllowed

---@class TransferConfig.AutoTransferEnabled
---@field AutoTransferEnabled boolean
local TAutoTransferEnabled = {}
TAutoTransferEnabled.__index = TAutoTransferEnabled
TAutoTransferEnabled.group = {}

local function TAutoTransferEnabled_from_obj(obj)
    return setmetatable(obj, TAutoTransferEnabled)
end

function TAutoTransferEnabled.new(AutoTransferEnabled)
    return TAutoTransferEnabled_from_obj({AutoTransferEnabled = AutoTransferEnabled})
end
---@param obj TransferConfig.AutoTransferEnabled
function TAutoTransferEnabled:init_from_obj(obj)
    self.AutoTransferEnabled = obj.AutoTransferEnabled
end

function TAutoTransferEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoTransferEnabled.group)
end

TAutoTransferEnabled.from_obj = TAutoTransferEnabled_from_obj

TAutoTransferEnabled.proto_property = {'AutoTransferEnabled'}

TAutoTransferEnabled.default = {false}

TAutoTransferEnabled.struct = {{name = 'AutoTransferEnabled', is_array = false, struct = nil}}

function TAutoTransferEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoTransferEnabled', self.AutoTransferEnabled, 'bool', false, errs, need_convert)

    TAutoTransferEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoTransferEnabled.proto_property, errs, need_convert)
    return self
end

function TAutoTransferEnabled:unpack(_)
    return self.AutoTransferEnabled
end

TransferConfig.AutoTransferEnabled = TAutoTransferEnabled

---@class TransferConfig.ActiveMainsId
---@field ActiveMainsId string
local TActiveMainsId = {}
TActiveMainsId.__index = TActiveMainsId
TActiveMainsId.group = {}

local function TActiveMainsId_from_obj(obj)
    return setmetatable(obj, TActiveMainsId)
end

function TActiveMainsId.new(ActiveMainsId)
    return TActiveMainsId_from_obj({ActiveMainsId = ActiveMainsId})
end
---@param obj TransferConfig.ActiveMainsId
function TActiveMainsId:init_from_obj(obj)
    self.ActiveMainsId = obj.ActiveMainsId
end

function TActiveMainsId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveMainsId.group)
end

TActiveMainsId.from_obj = TActiveMainsId_from_obj

TActiveMainsId.proto_property = {'ActiveMainsId'}

TActiveMainsId.default = {''}

TActiveMainsId.struct = {{name = 'ActiveMainsId', is_array = false, struct = nil}}

function TActiveMainsId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveMainsId', self.ActiveMainsId, 'string', false, errs, need_convert)

    TActiveMainsId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveMainsId.proto_property, errs, need_convert)
    return self
end

function TActiveMainsId:unpack(_)
    return self.ActiveMainsId
end

TransferConfig.ActiveMainsId = TActiveMainsId

---@class TransferConfig.TransferControlRsp
local TTransferControlRsp = {}
TTransferControlRsp.__index = TTransferControlRsp
TTransferControlRsp.group = {}

local function TTransferControlRsp_from_obj(obj)
    return setmetatable(obj, TTransferControlRsp)
end

function TTransferControlRsp.new()
    return TTransferControlRsp_from_obj({})
end
---@param obj TransferConfig.TransferControlRsp
function TTransferControlRsp:init_from_obj(obj)

end

function TTransferControlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransferControlRsp.group)
end

TTransferControlRsp.from_obj = TTransferControlRsp_from_obj

TTransferControlRsp.proto_property = {}

TTransferControlRsp.default = {}

TTransferControlRsp.struct = {}

function TTransferControlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TTransferControlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransferControlRsp.proto_property, errs, need_convert)
    return self
end

function TTransferControlRsp:unpack(_)
end

TransferConfig.TransferControlRsp = TTransferControlRsp

---@class TransferConfig.TransferControlReq
local TTransferControlReq = {}
TTransferControlReq.__index = TTransferControlReq
TTransferControlReq.group = {}

local function TTransferControlReq_from_obj(obj)
    return setmetatable(obj, TTransferControlReq)
end

function TTransferControlReq.new()
    return TTransferControlReq_from_obj({})
end
---@param obj TransferConfig.TransferControlReq
function TTransferControlReq:init_from_obj(obj)

end

function TTransferControlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransferControlReq.group)
end

TTransferControlReq.from_obj = TTransferControlReq_from_obj

TTransferControlReq.proto_property = {}

TTransferControlReq.default = {}

TTransferControlReq.struct = {}

function TTransferControlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TTransferControlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransferControlReq.proto_property, errs, need_convert)
    return self
end

function TTransferControlReq:unpack(_)
end

TransferConfig.TransferControlReq = TTransferControlReq

TransferConfig.interface = mdb.register_interface('bmc.kepler.PowerEquipment.PowerDistribution.TransferConfig', {
    ActiveMainsId = {'s', {}, false, nil},
    AutoTransferEnabled = {'b', {}, false, nil},
    ClosedTransitionAllowed = {'b', {}, false, nil},
    ClosedTransitionTimeoutSeconds = {'u', {}, false, 4294967295},
    PreferredMainsId = {'s', {}, false, nil},
    RetransferDelaySeconds = {'u', {}, false, 4294967295},
    RetransferEnabled = {'b', {}, false, nil},
    TransferInhibit = {'b', {}, false, nil},
    TransferDelaySeconds = {'u', {}, false, 4294967295},
    OverNominalFrequencyHz = {'d', {}, false, nil},
    OverVoltageRMSPercent = {'y', {}, false, 255},
    TransferSensitivity = {'s', {}, false, nil},
    UnderNominalFrequencyHz = {'d', {}, false, nil},
    UnderVoltageRMSPercent = {'y', {}, false, 255}
}, {TransferControl = {'a{ss}', '', TTransferControlReq, TTransferControlRsp}}, {})

return TransferConfig
