-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Status = {}

---@class Status.OtherStatus
---@field OtherStatus integer
local TOtherStatus = {}
TOtherStatus.__index = TOtherStatus
TOtherStatus.group = {}

local function TOtherStatus_from_obj(obj)
    return setmetatable(obj, TOtherStatus)
end

function TOtherStatus.new(OtherStatus)
    return TOtherStatus_from_obj({OtherStatus = OtherStatus})
end
---@param obj Status.OtherStatus
function TOtherStatus:init_from_obj(obj)
    self.OtherStatus = obj.OtherStatus
end

function TOtherStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOtherStatus.group)
end

TOtherStatus.from_obj = TOtherStatus_from_obj

TOtherStatus.proto_property = {'OtherStatus'}

TOtherStatus.default = {0}

TOtherStatus.struct = {{name = 'OtherStatus', is_array = false, struct = nil}}

function TOtherStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OtherStatus', self.OtherStatus, 'uint8', true, errs, need_convert)

    TOtherStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOtherStatus.proto_property, errs, need_convert)
    return self
end

function TOtherStatus:unpack(_)
    return self.OtherStatus
end

Status.OtherStatus = TOtherStatus

---@class Status.CMLStatus
---@field CMLStatus integer
local TCMLStatus = {}
TCMLStatus.__index = TCMLStatus
TCMLStatus.group = {}

local function TCMLStatus_from_obj(obj)
    return setmetatable(obj, TCMLStatus)
end

function TCMLStatus.new(CMLStatus)
    return TCMLStatus_from_obj({CMLStatus = CMLStatus})
end
---@param obj Status.CMLStatus
function TCMLStatus:init_from_obj(obj)
    self.CMLStatus = obj.CMLStatus
end

function TCMLStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCMLStatus.group)
end

TCMLStatus.from_obj = TCMLStatus_from_obj

TCMLStatus.proto_property = {'CMLStatus'}

TCMLStatus.default = {0}

TCMLStatus.struct = {{name = 'CMLStatus', is_array = false, struct = nil}}

function TCMLStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CMLStatus', self.CMLStatus, 'uint8', true, errs, need_convert)

    TCMLStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCMLStatus.proto_property, errs, need_convert)
    return self
end

function TCMLStatus:unpack(_)
    return self.CMLStatus
end

Status.CMLStatus = TCMLStatus

---@class Status.MfrSpecificStatus
---@field MfrSpecificStatus integer
local TMfrSpecificStatus = {}
TMfrSpecificStatus.__index = TMfrSpecificStatus
TMfrSpecificStatus.group = {}

local function TMfrSpecificStatus_from_obj(obj)
    return setmetatable(obj, TMfrSpecificStatus)
end

function TMfrSpecificStatus.new(MfrSpecificStatus)
    return TMfrSpecificStatus_from_obj({MfrSpecificStatus = MfrSpecificStatus or 255})
end
---@param obj Status.MfrSpecificStatus
function TMfrSpecificStatus:init_from_obj(obj)
    self.MfrSpecificStatus = obj.MfrSpecificStatus or 255
end

function TMfrSpecificStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMfrSpecificStatus.group)
end

TMfrSpecificStatus.from_obj = TMfrSpecificStatus_from_obj

TMfrSpecificStatus.proto_property = {'MfrSpecificStatus'}

TMfrSpecificStatus.default = {0}

TMfrSpecificStatus.struct = {{name = 'MfrSpecificStatus', is_array = false, struct = nil}}

function TMfrSpecificStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MfrSpecificStatus', self.MfrSpecificStatus, 'uint8', true, errs, need_convert)

    TMfrSpecificStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMfrSpecificStatus.proto_property, errs, need_convert)
    return self
end

function TMfrSpecificStatus:unpack(_)
    return self.MfrSpecificStatus
end

Status.MfrSpecificStatus = TMfrSpecificStatus

---@class Status.NormalAndRedundancySupported
---@field NormalAndRedundancySupported boolean
local TNormalAndRedundancySupported = {}
TNormalAndRedundancySupported.__index = TNormalAndRedundancySupported
TNormalAndRedundancySupported.group = {}

local function TNormalAndRedundancySupported_from_obj(obj)
    return setmetatable(obj, TNormalAndRedundancySupported)
end

function TNormalAndRedundancySupported.new(NormalAndRedundancySupported)
    return TNormalAndRedundancySupported_from_obj({NormalAndRedundancySupported = NormalAndRedundancySupported})
end
---@param obj Status.NormalAndRedundancySupported
function TNormalAndRedundancySupported:init_from_obj(obj)
    self.NormalAndRedundancySupported = obj.NormalAndRedundancySupported
end

function TNormalAndRedundancySupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNormalAndRedundancySupported.group)
end

TNormalAndRedundancySupported.from_obj = TNormalAndRedundancySupported_from_obj

TNormalAndRedundancySupported.proto_property = {'NormalAndRedundancySupported'}

TNormalAndRedundancySupported.default = {false}

TNormalAndRedundancySupported.struct = {{name = 'NormalAndRedundancySupported', is_array = false, struct = nil}}

function TNormalAndRedundancySupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NormalAndRedundancySupported', self.NormalAndRedundancySupported, 'bool', true, errs,
        need_convert)

    TNormalAndRedundancySupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNormalAndRedundancySupported.proto_property, errs, need_convert)
    return self
end

function TNormalAndRedundancySupported:unpack(_)
    return self.NormalAndRedundancySupported
end

Status.NormalAndRedundancySupported = TNormalAndRedundancySupported

---@class Status.IsUpgrading
---@field IsUpgrading boolean
local TIsUpgrading = {}
TIsUpgrading.__index = TIsUpgrading
TIsUpgrading.group = {}

local function TIsUpgrading_from_obj(obj)
    return setmetatable(obj, TIsUpgrading)
end

function TIsUpgrading.new(IsUpgrading)
    return TIsUpgrading_from_obj({IsUpgrading = IsUpgrading})
end
---@param obj Status.IsUpgrading
function TIsUpgrading:init_from_obj(obj)
    self.IsUpgrading = obj.IsUpgrading
end

function TIsUpgrading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsUpgrading.group)
end

TIsUpgrading.from_obj = TIsUpgrading_from_obj

TIsUpgrading.proto_property = {'IsUpgrading'}

TIsUpgrading.default = {false}

TIsUpgrading.struct = {{name = 'IsUpgrading', is_array = false, struct = nil}}

function TIsUpgrading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsUpgrading', self.IsUpgrading, 'bool', true, errs, need_convert)

    TIsUpgrading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsUpgrading.proto_property, errs, need_convert)
    return self
end

function TIsUpgrading:unpack(_)
    return self.IsUpgrading
end

Status.IsUpgrading = TIsUpgrading

---@class Status.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health or 255})
end
---@param obj Status.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health or 255
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Status.Health = THealth

---@class Status.BackupCircuitVINStatus
---@field BackupCircuitVINStatus integer
local TBackupCircuitVINStatus = {}
TBackupCircuitVINStatus.__index = TBackupCircuitVINStatus
TBackupCircuitVINStatus.group = {}

local function TBackupCircuitVINStatus_from_obj(obj)
    return setmetatable(obj, TBackupCircuitVINStatus)
end

function TBackupCircuitVINStatus.new(BackupCircuitVINStatus)
    return TBackupCircuitVINStatus_from_obj({BackupCircuitVINStatus = BackupCircuitVINStatus or 255})
end
---@param obj Status.BackupCircuitVINStatus
function TBackupCircuitVINStatus:init_from_obj(obj)
    self.BackupCircuitVINStatus = obj.BackupCircuitVINStatus or 255
end

function TBackupCircuitVINStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupCircuitVINStatus.group)
end

TBackupCircuitVINStatus.from_obj = TBackupCircuitVINStatus_from_obj

TBackupCircuitVINStatus.proto_property = {'BackupCircuitVINStatus'}

TBackupCircuitVINStatus.default = {0}

TBackupCircuitVINStatus.struct = {{name = 'BackupCircuitVINStatus', is_array = false, struct = nil}}

function TBackupCircuitVINStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupCircuitVINStatus', self.BackupCircuitVINStatus, 'uint8', true, errs, need_convert)

    TBackupCircuitVINStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupCircuitVINStatus.proto_property, errs, need_convert)
    return self
end

function TBackupCircuitVINStatus:unpack(_)
    return self.BackupCircuitVINStatus
end

Status.BackupCircuitVINStatus = TBackupCircuitVINStatus

---@class Status.MainCircuitVINStatus
---@field MainCircuitVINStatus integer
local TMainCircuitVINStatus = {}
TMainCircuitVINStatus.__index = TMainCircuitVINStatus
TMainCircuitVINStatus.group = {}

local function TMainCircuitVINStatus_from_obj(obj)
    return setmetatable(obj, TMainCircuitVINStatus)
end

function TMainCircuitVINStatus.new(MainCircuitVINStatus)
    return TMainCircuitVINStatus_from_obj({MainCircuitVINStatus = MainCircuitVINStatus or 255})
end
---@param obj Status.MainCircuitVINStatus
function TMainCircuitVINStatus:init_from_obj(obj)
    self.MainCircuitVINStatus = obj.MainCircuitVINStatus or 255
end

function TMainCircuitVINStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMainCircuitVINStatus.group)
end

TMainCircuitVINStatus.from_obj = TMainCircuitVINStatus_from_obj

TMainCircuitVINStatus.proto_property = {'MainCircuitVINStatus'}

TMainCircuitVINStatus.default = {0}

TMainCircuitVINStatus.struct = {{name = 'MainCircuitVINStatus', is_array = false, struct = nil}}

function TMainCircuitVINStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MainCircuitVINStatus', self.MainCircuitVINStatus, 'uint8', true, errs, need_convert)

    TMainCircuitVINStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMainCircuitVINStatus.proto_property, errs, need_convert)
    return self
end

function TMainCircuitVINStatus:unpack(_)
    return self.MainCircuitVINStatus
end

Status.MainCircuitVINStatus = TMainCircuitVINStatus

---@class Status.TPSUStatusLow
---@field TPSUStatusLow integer
local TTPSUStatusLow = {}
TTPSUStatusLow.__index = TTPSUStatusLow
TTPSUStatusLow.group = {}

local function TTPSUStatusLow_from_obj(obj)
    return setmetatable(obj, TTPSUStatusLow)
end

function TTPSUStatusLow.new(TPSUStatusLow)
    return TTPSUStatusLow_from_obj({TPSUStatusLow = TPSUStatusLow})
end
---@param obj Status.TPSUStatusLow
function TTPSUStatusLow:init_from_obj(obj)
    self.TPSUStatusLow = obj.TPSUStatusLow
end

function TTPSUStatusLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTPSUStatusLow.group)
end

TTPSUStatusLow.from_obj = TTPSUStatusLow_from_obj

TTPSUStatusLow.proto_property = {'TPSUStatusLow'}

TTPSUStatusLow.default = {0}

TTPSUStatusLow.struct = {{name = 'TPSUStatusLow', is_array = false, struct = nil}}

function TTPSUStatusLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TPSUStatusLow', self.TPSUStatusLow, 'uint32', true, errs, need_convert)

    TTPSUStatusLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTPSUStatusLow.proto_property, errs, need_convert)
    return self
end

function TTPSUStatusLow:unpack(_)
    return self.TPSUStatusLow
end

Status.TPSUStatusLow = TTPSUStatusLow

---@class Status.TPSUStatusHigh
---@field TPSUStatusHigh integer
local TTPSUStatusHigh = {}
TTPSUStatusHigh.__index = TTPSUStatusHigh
TTPSUStatusHigh.group = {}

local function TTPSUStatusHigh_from_obj(obj)
    return setmetatable(obj, TTPSUStatusHigh)
end

function TTPSUStatusHigh.new(TPSUStatusHigh)
    return TTPSUStatusHigh_from_obj({TPSUStatusHigh = TPSUStatusHigh})
end
---@param obj Status.TPSUStatusHigh
function TTPSUStatusHigh:init_from_obj(obj)
    self.TPSUStatusHigh = obj.TPSUStatusHigh
end

function TTPSUStatusHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTPSUStatusHigh.group)
end

TTPSUStatusHigh.from_obj = TTPSUStatusHigh_from_obj

TTPSUStatusHigh.proto_property = {'TPSUStatusHigh'}

TTPSUStatusHigh.default = {0}

TTPSUStatusHigh.struct = {{name = 'TPSUStatusHigh', is_array = false, struct = nil}}

function TTPSUStatusHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TPSUStatusHigh', self.TPSUStatusHigh, 'uint32', true, errs, need_convert)

    TTPSUStatusHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTPSUStatusHigh.proto_property, errs, need_convert)
    return self
end

function TTPSUStatusHigh:unpack(_)
    return self.TPSUStatusHigh
end

Status.TPSUStatusHigh = TTPSUStatusHigh

---@class Status.EquipmentMode
---@field EquipmentMode integer
local TEquipmentMode = {}
TEquipmentMode.__index = TEquipmentMode
TEquipmentMode.group = {}

local function TEquipmentMode_from_obj(obj)
    return setmetatable(obj, TEquipmentMode)
end

function TEquipmentMode.new(EquipmentMode)
    return TEquipmentMode_from_obj({EquipmentMode = EquipmentMode or 255})
end
---@param obj Status.EquipmentMode
function TEquipmentMode:init_from_obj(obj)
    self.EquipmentMode = obj.EquipmentMode or 255
end

function TEquipmentMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEquipmentMode.group)
end

TEquipmentMode.from_obj = TEquipmentMode_from_obj

TEquipmentMode.proto_property = {'EquipmentMode'}

TEquipmentMode.default = {0}

TEquipmentMode.struct = {{name = 'EquipmentMode', is_array = false, struct = nil}}

function TEquipmentMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EquipmentMode', self.EquipmentMode, 'uint8', true, errs, need_convert)

    TEquipmentMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEquipmentMode.proto_property, errs, need_convert)
    return self
end

function TEquipmentMode:unpack(_)
    return self.EquipmentMode
end

Status.EquipmentMode = TEquipmentMode

---@class Status.ScanStatus
---@field ScanStatus integer
local TScanStatus = {}
TScanStatus.__index = TScanStatus
TScanStatus.group = {}

local function TScanStatus_from_obj(obj)
    return setmetatable(obj, TScanStatus)
end

function TScanStatus.new(ScanStatus)
    return TScanStatus_from_obj({ScanStatus = ScanStatus})
end
---@param obj Status.ScanStatus
function TScanStatus:init_from_obj(obj)
    self.ScanStatus = obj.ScanStatus
end

function TScanStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TScanStatus.group)
end

TScanStatus.from_obj = TScanStatus_from_obj

TScanStatus.proto_property = {'ScanStatus'}

TScanStatus.default = {0}

TScanStatus.struct = {{name = 'ScanStatus', is_array = false, struct = nil}}

function TScanStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ScanStatus', self.ScanStatus, 'uint8', true, errs, need_convert)

    TScanStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TScanStatus.proto_property, errs, need_convert)
    return self
end

function TScanStatus:unpack(_)
    return self.ScanStatus
end

Status.ScanStatus = TScanStatus

---@class Status.DualInputVoltageStatus
---@field DualInputVoltageStatus integer
local TDualInputVoltageStatus = {}
TDualInputVoltageStatus.__index = TDualInputVoltageStatus
TDualInputVoltageStatus.group = {}

local function TDualInputVoltageStatus_from_obj(obj)
    return setmetatable(obj, TDualInputVoltageStatus)
end

function TDualInputVoltageStatus.new(DualInputVoltageStatus)
    return TDualInputVoltageStatus_from_obj({DualInputVoltageStatus = DualInputVoltageStatus})
end
---@param obj Status.DualInputVoltageStatus
function TDualInputVoltageStatus:init_from_obj(obj)
    self.DualInputVoltageStatus = obj.DualInputVoltageStatus
end

function TDualInputVoltageStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDualInputVoltageStatus.group)
end

TDualInputVoltageStatus.from_obj = TDualInputVoltageStatus_from_obj

TDualInputVoltageStatus.proto_property = {'DualInputVoltageStatus'}

TDualInputVoltageStatus.default = {0}

TDualInputVoltageStatus.struct = {{name = 'DualInputVoltageStatus', is_array = false, struct = nil}}

function TDualInputVoltageStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DualInputVoltageStatus', self.DualInputVoltageStatus, 'uint16', true, errs,
        need_convert)

    TDualInputVoltageStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDualInputVoltageStatus.proto_property, errs, need_convert)
    return self
end

function TDualInputVoltageStatus:unpack(_)
    return self.DualInputVoltageStatus
end

Status.DualInputVoltageStatus = TDualInputVoltageStatus

---@class Status.InputVoltageStatus
---@field InputVoltageStatus integer
local TInputVoltageStatus = {}
TInputVoltageStatus.__index = TInputVoltageStatus
TInputVoltageStatus.group = {}

local function TInputVoltageStatus_from_obj(obj)
    return setmetatable(obj, TInputVoltageStatus)
end

function TInputVoltageStatus.new(InputVoltageStatus)
    return TInputVoltageStatus_from_obj({InputVoltageStatus = InputVoltageStatus})
end
---@param obj Status.InputVoltageStatus
function TInputVoltageStatus:init_from_obj(obj)
    self.InputVoltageStatus = obj.InputVoltageStatus
end

function TInputVoltageStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltageStatus.group)
end

TInputVoltageStatus.from_obj = TInputVoltageStatus_from_obj

TInputVoltageStatus.proto_property = {'InputVoltageStatus'}

TInputVoltageStatus.default = {0}

TInputVoltageStatus.struct = {{name = 'InputVoltageStatus', is_array = false, struct = nil}}

function TInputVoltageStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltageStatus', self.InputVoltageStatus, 'uint8', true, errs, need_convert)

    if self.InputVoltageStatus ~= nil then
        validate.Enum(prefix .. 'InputVoltageStatus', self.InputVoltageStatus, '', {0, 1, 2, 3}, errs, need_convert)
    end

    TInputVoltageStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltageStatus.proto_property, errs, need_convert)
    return self
end

function TInputVoltageStatus:unpack(_)
    return self.InputVoltageStatus
end

Status.InputVoltageStatus = TInputVoltageStatus

---@class Status.DeepSleepEnabled
---@field DeepSleepEnabled integer
local TDeepSleepEnabled = {}
TDeepSleepEnabled.__index = TDeepSleepEnabled
TDeepSleepEnabled.group = {}

local function TDeepSleepEnabled_from_obj(obj)
    return setmetatable(obj, TDeepSleepEnabled)
end

function TDeepSleepEnabled.new(DeepSleepEnabled)
    return TDeepSleepEnabled_from_obj({DeepSleepEnabled = DeepSleepEnabled})
end
---@param obj Status.DeepSleepEnabled
function TDeepSleepEnabled:init_from_obj(obj)
    self.DeepSleepEnabled = obj.DeepSleepEnabled
end

function TDeepSleepEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeepSleepEnabled.group)
end

TDeepSleepEnabled.from_obj = TDeepSleepEnabled_from_obj

TDeepSleepEnabled.proto_property = {'DeepSleepEnabled'}

TDeepSleepEnabled.default = {0}

TDeepSleepEnabled.struct = {{name = 'DeepSleepEnabled', is_array = false, struct = nil}}

function TDeepSleepEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeepSleepEnabled', self.DeepSleepEnabled, 'uint8', true, errs, need_convert)

    TDeepSleepEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeepSleepEnabled.proto_property, errs, need_convert)
    return self
end

function TDeepSleepEnabled:unpack(_)
    return self.DeepSleepEnabled
end

Status.DeepSleepEnabled = TDeepSleepEnabled

---@class Status.SleepMode
---@field SleepMode string
local TSleepMode = {}
TSleepMode.__index = TSleepMode
TSleepMode.group = {}

local function TSleepMode_from_obj(obj)
    return setmetatable(obj, TSleepMode)
end

function TSleepMode.new(SleepMode)
    return TSleepMode_from_obj({SleepMode = SleepMode})
end
---@param obj Status.SleepMode
function TSleepMode:init_from_obj(obj)
    self.SleepMode = obj.SleepMode
end

function TSleepMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSleepMode.group)
end

TSleepMode.from_obj = TSleepMode_from_obj

TSleepMode.proto_property = {'SleepMode'}

TSleepMode.default = {''}

TSleepMode.struct = {{name = 'SleepMode', is_array = false, struct = nil}}

function TSleepMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SleepMode', self.SleepMode, 'string', true, errs, need_convert)

    TSleepMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSleepMode.proto_property, errs, need_convert)
    return self
end

function TSleepMode:unpack(_)
    return self.SleepMode
end

Status.SleepMode = TSleepMode

---@class Status.OverTemperature
---@field OverTemperature integer
local TOverTemperature = {}
TOverTemperature.__index = TOverTemperature
TOverTemperature.group = {}

local function TOverTemperature_from_obj(obj)
    return setmetatable(obj, TOverTemperature)
end

function TOverTemperature.new(OverTemperature)
    return TOverTemperature_from_obj({OverTemperature = OverTemperature})
end
---@param obj Status.OverTemperature
function TOverTemperature:init_from_obj(obj)
    self.OverTemperature = obj.OverTemperature
end

function TOverTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOverTemperature.group)
end

TOverTemperature.from_obj = TOverTemperature_from_obj

TOverTemperature.proto_property = {'OverTemperature'}

TOverTemperature.default = {0}

TOverTemperature.struct = {{name = 'OverTemperature', is_array = false, struct = nil}}

function TOverTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OverTemperature', self.OverTemperature, 'uint8', true, errs, need_convert)

    TOverTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOverTemperature.proto_property, errs, need_convert)
    return self
end

function TOverTemperature:unpack(_)
    return self.OverTemperature
end

Status.OverTemperature = TOverTemperature

---@class Status.OutputVoltageFault
---@field OutputVoltageFault integer
local TOutputVoltageFault = {}
TOutputVoltageFault.__index = TOutputVoltageFault
TOutputVoltageFault.group = {}

local function TOutputVoltageFault_from_obj(obj)
    return setmetatable(obj, TOutputVoltageFault)
end

function TOutputVoltageFault.new(OutputVoltageFault)
    return TOutputVoltageFault_from_obj({OutputVoltageFault = OutputVoltageFault})
end
---@param obj Status.OutputVoltageFault
function TOutputVoltageFault:init_from_obj(obj)
    self.OutputVoltageFault = obj.OutputVoltageFault
end

function TOutputVoltageFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputVoltageFault.group)
end

TOutputVoltageFault.from_obj = TOutputVoltageFault_from_obj

TOutputVoltageFault.proto_property = {'OutputVoltageFault'}

TOutputVoltageFault.default = {0}

TOutputVoltageFault.struct = {{name = 'OutputVoltageFault', is_array = false, struct = nil}}

function TOutputVoltageFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputVoltageFault', self.OutputVoltageFault, 'uint8', true, errs, need_convert)

    TOutputVoltageFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputVoltageFault.proto_property, errs, need_convert)
    return self
end

function TOutputVoltageFault:unpack(_)
    return self.OutputVoltageFault
end

Status.OutputVoltageFault = TOutputVoltageFault

---@class Status.OutputCurrentFault
---@field OutputCurrentFault integer
local TOutputCurrentFault = {}
TOutputCurrentFault.__index = TOutputCurrentFault
TOutputCurrentFault.group = {}

local function TOutputCurrentFault_from_obj(obj)
    return setmetatable(obj, TOutputCurrentFault)
end

function TOutputCurrentFault.new(OutputCurrentFault)
    return TOutputCurrentFault_from_obj({OutputCurrentFault = OutputCurrentFault})
end
---@param obj Status.OutputCurrentFault
function TOutputCurrentFault:init_from_obj(obj)
    self.OutputCurrentFault = obj.OutputCurrentFault
end

function TOutputCurrentFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputCurrentFault.group)
end

TOutputCurrentFault.from_obj = TOutputCurrentFault_from_obj

TOutputCurrentFault.proto_property = {'OutputCurrentFault'}

TOutputCurrentFault.default = {0}

TOutputCurrentFault.struct = {{name = 'OutputCurrentFault', is_array = false, struct = nil}}

function TOutputCurrentFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputCurrentFault', self.OutputCurrentFault, 'uint8', true, errs, need_convert)

    TOutputCurrentFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputCurrentFault.proto_property, errs, need_convert)
    return self
end

function TOutputCurrentFault:unpack(_)
    return self.OutputCurrentFault
end

Status.OutputCurrentFault = TOutputCurrentFault

---@class Status.LossOfInput
---@field LossOfInput integer
local TLossOfInput = {}
TLossOfInput.__index = TLossOfInput
TLossOfInput.group = {}

local function TLossOfInput_from_obj(obj)
    return setmetatable(obj, TLossOfInput)
end

function TLossOfInput.new(LossOfInput)
    return TLossOfInput_from_obj({LossOfInput = LossOfInput})
end
---@param obj Status.LossOfInput
function TLossOfInput:init_from_obj(obj)
    self.LossOfInput = obj.LossOfInput
end

function TLossOfInput:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLossOfInput.group)
end

TLossOfInput.from_obj = TLossOfInput_from_obj

TLossOfInput.proto_property = {'LossOfInput'}

TLossOfInput.default = {0}

TLossOfInput.struct = {{name = 'LossOfInput', is_array = false, struct = nil}}

function TLossOfInput:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LossOfInput', self.LossOfInput, 'uint8', true, errs, need_convert)

    TLossOfInput:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLossOfInput.proto_property, errs, need_convert)
    return self
end

function TLossOfInput:unpack(_)
    return self.LossOfInput
end

Status.LossOfInput = TLossOfInput

---@class Status.InputVoltageFault
---@field InputVoltageFault integer
local TInputVoltageFault = {}
TInputVoltageFault.__index = TInputVoltageFault
TInputVoltageFault.group = {}

local function TInputVoltageFault_from_obj(obj)
    return setmetatable(obj, TInputVoltageFault)
end

function TInputVoltageFault.new(InputVoltageFault)
    return TInputVoltageFault_from_obj({InputVoltageFault = InputVoltageFault or 32768})
end
---@param obj Status.InputVoltageFault
function TInputVoltageFault:init_from_obj(obj)
    self.InputVoltageFault = obj.InputVoltageFault or 32768
end

function TInputVoltageFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltageFault.group)
end

TInputVoltageFault.from_obj = TInputVoltageFault_from_obj

TInputVoltageFault.proto_property = {'InputVoltageFault'}

TInputVoltageFault.default = {0}

TInputVoltageFault.struct = {{name = 'InputVoltageFault', is_array = false, struct = nil}}

function TInputVoltageFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltageFault', self.InputVoltageFault, 'uint16', true, errs, need_convert)

    TInputVoltageFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltageFault.proto_property, errs, need_convert)
    return self
end

function TInputVoltageFault:unpack(_)
    return self.InputVoltageFault
end

Status.InputVoltageFault = TInputVoltageFault

---@class Status.FanFault
---@field FanFault integer
local TFanFault = {}
TFanFault.__index = TFanFault
TFanFault.group = {}

local function TFanFault_from_obj(obj)
    return setmetatable(obj, TFanFault)
end

function TFanFault.new(FanFault)
    return TFanFault_from_obj({FanFault = FanFault})
end
---@param obj Status.FanFault
function TFanFault:init_from_obj(obj)
    self.FanFault = obj.FanFault
end

function TFanFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanFault.group)
end

TFanFault.from_obj = TFanFault_from_obj

TFanFault.proto_property = {'FanFault'}

TFanFault.default = {0}

TFanFault.struct = {{name = 'FanFault', is_array = false, struct = nil}}

function TFanFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanFault', self.FanFault, 'uint8', true, errs, need_convert)

    TFanFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanFault.proto_property, errs, need_convert)
    return self
end

function TFanFault:unpack(_)
    return self.FanFault
end

Status.FanFault = TFanFault

---@class Status.Fan2Fault
---@field Fan2Fault integer
local TFan2Fault = {}
TFan2Fault.__index = TFan2Fault
TFan2Fault.group = {}

local function TFan2Fault_from_obj(obj)
    return setmetatable(obj, TFan2Fault)
end

function TFan2Fault.new(Fan2Fault)
    return TFan2Fault_from_obj({Fan2Fault = Fan2Fault})
end
---@param obj Status.Fan2Fault
function TFan2Fault:init_from_obj(obj)
    self.Fan2Fault = obj.Fan2Fault
end

function TFan2Fault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFan2Fault.group)
end

TFan2Fault.from_obj = TFan2Fault_from_obj

TFan2Fault.proto_property = {'Fan2Fault'}

TFan2Fault.default = {0}

TFan2Fault.struct = {{name = 'Fan2Fault', is_array = false, struct = nil}}

function TFan2Fault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Fan2Fault', self.Fan2Fault, 'uint8', true, errs, need_convert)

    TFan2Fault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFan2Fault.proto_property, errs, need_convert)
    return self
end

function TFan2Fault:unpack(_)
    return self.Fan2Fault
end

Status.Fan2Fault = TFan2Fault

---@class Status.Fan1Fault
---@field Fan1Fault integer
local TFan1Fault = {}
TFan1Fault.__index = TFan1Fault
TFan1Fault.group = {}

local function TFan1Fault_from_obj(obj)
    return setmetatable(obj, TFan1Fault)
end

function TFan1Fault.new(Fan1Fault)
    return TFan1Fault_from_obj({Fan1Fault = Fan1Fault})
end
---@param obj Status.Fan1Fault
function TFan1Fault:init_from_obj(obj)
    self.Fan1Fault = obj.Fan1Fault
end

function TFan1Fault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFan1Fault.group)
end

TFan1Fault.from_obj = TFan1Fault_from_obj

TFan1Fault.proto_property = {'Fan1Fault'}

TFan1Fault.default = {0}

TFan1Fault.struct = {{name = 'Fan1Fault', is_array = false, struct = nil}}

function TFan1Fault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Fan1Fault', self.Fan1Fault, 'uint8', true, errs, need_convert)

    TFan1Fault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFan1Fault.proto_property, errs, need_convert)
    return self
end

function TFan1Fault:unpack(_)
    return self.Fan1Fault
end

Status.Fan1Fault = TFan1Fault

---@class Status.Failure
---@field Failure integer
local TFailure = {}
TFailure.__index = TFailure
TFailure.group = {}

local function TFailure_from_obj(obj)
    return setmetatable(obj, TFailure)
end

function TFailure.new(Failure)
    return TFailure_from_obj({Failure = Failure})
end
---@param obj Status.Failure
function TFailure:init_from_obj(obj)
    self.Failure = obj.Failure
end

function TFailure:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFailure.group)
end

TFailure.from_obj = TFailure_from_obj

TFailure.proto_property = {'Failure'}

TFailure.default = {0}

TFailure.struct = {{name = 'Failure', is_array = false, struct = nil}}

function TFailure:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Failure', self.Failure, 'uint8', true, errs, need_convert)

    TFailure:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFailure.proto_property, errs, need_convert)
    return self
end

function TFailure:unpack(_)
    return self.Failure
end

Status.Failure = TFailure

---@class Status.CommunicationStatus
---@field CommunicationStatus integer
local TCommunicationStatus = {}
TCommunicationStatus.__index = TCommunicationStatus
TCommunicationStatus.group = {}

local function TCommunicationStatus_from_obj(obj)
    return setmetatable(obj, TCommunicationStatus)
end

function TCommunicationStatus.new(CommunicationStatus)
    return TCommunicationStatus_from_obj({CommunicationStatus = CommunicationStatus})
end
---@param obj Status.CommunicationStatus
function TCommunicationStatus:init_from_obj(obj)
    self.CommunicationStatus = obj.CommunicationStatus
end

function TCommunicationStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCommunicationStatus.group)
end

TCommunicationStatus.from_obj = TCommunicationStatus_from_obj

TCommunicationStatus.proto_property = {'CommunicationStatus'}

TCommunicationStatus.default = {0}

TCommunicationStatus.struct = {{name = 'CommunicationStatus', is_array = false, struct = nil}}

function TCommunicationStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CommunicationStatus', self.CommunicationStatus, 'uint8', true, errs, need_convert)

    TCommunicationStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCommunicationStatus.proto_property, errs, need_convert)
    return self
end

function TCommunicationStatus:unpack(_)
    return self.CommunicationStatus
end

Status.CommunicationStatus = TCommunicationStatus

---@class Status.OutputState
---@field OutputState integer
local TOutputState = {}
TOutputState.__index = TOutputState
TOutputState.group = {}

local function TOutputState_from_obj(obj)
    return setmetatable(obj, TOutputState)
end

function TOutputState.new(OutputState)
    return TOutputState_from_obj({OutputState = OutputState})
end
---@param obj Status.OutputState
function TOutputState:init_from_obj(obj)
    self.OutputState = obj.OutputState
end

function TOutputState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputState.group)
end

TOutputState.from_obj = TOutputState_from_obj

TOutputState.proto_property = {'OutputState'}

TOutputState.default = {0}

TOutputState.struct = {{name = 'OutputState', is_array = false, struct = nil}}

function TOutputState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputState', self.OutputState, 'uint8', true, errs, need_convert)

    TOutputState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputState.proto_property, errs, need_convert)
    return self
end

function TOutputState:unpack(_)
    return self.OutputState
end

Status.OutputState = TOutputState

---@class Status.SetAlarmLatchRsp
local TSetAlarmLatchRsp = {}
TSetAlarmLatchRsp.__index = TSetAlarmLatchRsp
TSetAlarmLatchRsp.group = {}

local function TSetAlarmLatchRsp_from_obj(obj)
    return setmetatable(obj, TSetAlarmLatchRsp)
end

function TSetAlarmLatchRsp.new()
    return TSetAlarmLatchRsp_from_obj({})
end
---@param obj Status.SetAlarmLatchRsp
function TSetAlarmLatchRsp:init_from_obj(obj)

end

function TSetAlarmLatchRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlarmLatchRsp.group)
end

TSetAlarmLatchRsp.from_obj = TSetAlarmLatchRsp_from_obj

TSetAlarmLatchRsp.proto_property = {}

TSetAlarmLatchRsp.default = {}

TSetAlarmLatchRsp.struct = {}

function TSetAlarmLatchRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAlarmLatchRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlarmLatchRsp.proto_property, errs, need_convert)
    return self
end

function TSetAlarmLatchRsp:unpack(_)
end

Status.SetAlarmLatchRsp = TSetAlarmLatchRsp

---@class Status.SetAlarmLatchReq
---@field SwitchStatus integer
local TSetAlarmLatchReq = {}
TSetAlarmLatchReq.__index = TSetAlarmLatchReq
TSetAlarmLatchReq.group = {}

local function TSetAlarmLatchReq_from_obj(obj)
    return setmetatable(obj, TSetAlarmLatchReq)
end

function TSetAlarmLatchReq.new(SwitchStatus)
    return TSetAlarmLatchReq_from_obj({SwitchStatus = SwitchStatus})
end
---@param obj Status.SetAlarmLatchReq
function TSetAlarmLatchReq:init_from_obj(obj)
    self.SwitchStatus = obj.SwitchStatus
end

function TSetAlarmLatchReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlarmLatchReq.group)
end

TSetAlarmLatchReq.from_obj = TSetAlarmLatchReq_from_obj

TSetAlarmLatchReq.proto_property = {'SwitchStatus'}

TSetAlarmLatchReq.default = {0}

TSetAlarmLatchReq.struct = {{name = 'SwitchStatus', is_array = false, struct = nil}}

function TSetAlarmLatchReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SwitchStatus', self.SwitchStatus, 'uint8', false, errs, need_convert)

    if self.SwitchStatus ~= nil then
        validate.Enum(prefix .. 'SwitchStatus', self.SwitchStatus, '', {0, 1}, errs, need_convert)
    end

    TSetAlarmLatchReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlarmLatchReq.proto_property, errs, need_convert)
    return self
end

function TSetAlarmLatchReq:unpack(_)
    return self.SwitchStatus
end

Status.SetAlarmLatchReq = TSetAlarmLatchReq

---@class Status.SetSleepModeRsp
---@field CmdResult integer
local TSetSleepModeRsp = {}
TSetSleepModeRsp.__index = TSetSleepModeRsp
TSetSleepModeRsp.group = {}

local function TSetSleepModeRsp_from_obj(obj)
    return setmetatable(obj, TSetSleepModeRsp)
end

function TSetSleepModeRsp.new(CmdResult)
    return TSetSleepModeRsp_from_obj({CmdResult = CmdResult})
end
---@param obj Status.SetSleepModeRsp
function TSetSleepModeRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetSleepModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSleepModeRsp.group)
end

TSetSleepModeRsp.from_obj = TSetSleepModeRsp_from_obj

TSetSleepModeRsp.proto_property = {'CmdResult'}

TSetSleepModeRsp.default = {0}

TSetSleepModeRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetSleepModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint8', false, errs, need_convert)

    TSetSleepModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSleepModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSleepModeRsp:unpack(_)
    return self.CmdResult
end

Status.SetSleepModeRsp = TSetSleepModeRsp

---@class Status.SetSleepModeReq
---@field SleepMode string
local TSetSleepModeReq = {}
TSetSleepModeReq.__index = TSetSleepModeReq
TSetSleepModeReq.group = {}

local function TSetSleepModeReq_from_obj(obj)
    return setmetatable(obj, TSetSleepModeReq)
end

function TSetSleepModeReq.new(SleepMode)
    return TSetSleepModeReq_from_obj({SleepMode = SleepMode})
end
---@param obj Status.SetSleepModeReq
function TSetSleepModeReq:init_from_obj(obj)
    self.SleepMode = obj.SleepMode
end

function TSetSleepModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSleepModeReq.group)
end

TSetSleepModeReq.from_obj = TSetSleepModeReq_from_obj

TSetSleepModeReq.proto_property = {'SleepMode'}

TSetSleepModeReq.default = {''}

TSetSleepModeReq.struct = {{name = 'SleepMode', is_array = false, struct = nil}}

function TSetSleepModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SleepMode', self.SleepMode, 'string', false, errs, need_convert)

    TSetSleepModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSleepModeReq.proto_property, errs, need_convert)
    return self
end

function TSetSleepModeReq:unpack(_)
    return self.SleepMode
end

Status.SetSleepModeReq = TSetSleepModeReq

Status.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower.Status', {
    OutputState = {'y', nil, true, nil},
    CommunicationStatus = {'y', {'EMIT_CHANGE'}, true, nil},
    Failure = {'y', nil, true, nil},
    Fan1Fault = {'y', nil, true, nil},
    Fan2Fault = {'y', nil, true, nil},
    FanFault = {'y', nil, true, nil},
    InputVoltageFault = {'q', nil, true, 32768},
    LossOfInput = {'y', nil, true, nil},
    OutputCurrentFault = {'y', nil, true, nil},
    OutputVoltageFault = {'y', nil, true, nil},
    OverTemperature = {'y', nil, true, nil},
    SleepMode = {'s', nil, true, nil},
    DeepSleepEnabled = {'y', nil, true, nil},
    InputVoltageStatus = {'y', nil, true, nil},
    DualInputVoltageStatus = {'q', nil, true, nil},
    ScanStatus = {'y', nil, true, nil},
    CMLStatus = {'y', {'EMIT_CHANGE'}, true, nil},
    OtherStatus = {'y', {'EMIT_CHANGE'}, true, nil},
    MfrSpecificStatus = {'y', {'EMIT_CHANGE'}, true, 255},
    Health = {'y', nil, true, 255},
    IsUpgrading = {'b', nil, true, nil},
    NormalAndRedundancySupported = {'b', nil, true, nil},
    EquipmentMode = {'y', {'EMIT_CHANGE'}, true, 255},
    TPSUStatusHigh = {'u', {'EMIT_CHANGE'}, true, nil},
    TPSUStatusLow = {'u', {'EMIT_CHANGE'}, true, nil},
    MainCircuitVINStatus = {'y', {'EMIT_CHANGE'}, true, nil},
    BackupCircuitVINStatus = {'y', {'EMIT_CHANGE'}, true, nil}
}, {
    SetSleepMode = {'a{ss}s', 'y', TSetSleepModeReq, TSetSleepModeRsp},
    SetAlarmLatch = {'a{ss}y', '', TSetAlarmLatchReq, TSetAlarmLatchRsp}
}, {})

return Status
