-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SerialManagement = {}

---@class SerialManagement.SetConnectStatusRsp
local TSetConnectStatusRsp = {}
TSetConnectStatusRsp.__index = TSetConnectStatusRsp
TSetConnectStatusRsp.group = {}

local function TSetConnectStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetConnectStatusRsp)
end

function TSetConnectStatusRsp.new()
    return TSetConnectStatusRsp_from_obj({})
end
---@param obj SerialManagement.SetConnectStatusRsp
function TSetConnectStatusRsp:init_from_obj(obj)

end

function TSetConnectStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConnectStatusRsp.group)
end

TSetConnectStatusRsp.from_obj = TSetConnectStatusRsp_from_obj

TSetConnectStatusRsp.proto_property = {}

TSetConnectStatusRsp.default = {}

TSetConnectStatusRsp.struct = {}

function TSetConnectStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetConnectStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConnectStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetConnectStatusRsp:unpack(_)
end

SerialManagement.SetConnectStatusRsp = TSetConnectStatusRsp

---@class SerialManagement.SetConnectStatusReq
---@field NeedSaved boolean
local TSetConnectStatusReq = {}
TSetConnectStatusReq.__index = TSetConnectStatusReq
TSetConnectStatusReq.group = {}

local function TSetConnectStatusReq_from_obj(obj)
    return setmetatable(obj, TSetConnectStatusReq)
end

function TSetConnectStatusReq.new(NeedSaved)
    return TSetConnectStatusReq_from_obj({NeedSaved = NeedSaved})
end
---@param obj SerialManagement.SetConnectStatusReq
function TSetConnectStatusReq:init_from_obj(obj)
    self.NeedSaved = obj.NeedSaved
end

function TSetConnectStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConnectStatusReq.group)
end

TSetConnectStatusReq.from_obj = TSetConnectStatusReq_from_obj

TSetConnectStatusReq.proto_property = {'NeedSaved'}

TSetConnectStatusReq.default = {false}

TSetConnectStatusReq.struct = {{name = 'NeedSaved', is_array = false, struct = nil}}

function TSetConnectStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NeedSaved', self.NeedSaved, 'bool', false, errs, need_convert)

    TSetConnectStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConnectStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetConnectStatusReq:unpack(_)
    return self.NeedSaved
end

SerialManagement.SetConnectStatusReq = TSetConnectStatusReq

SerialManagement.interface = mdb.register_interface('bmc.kepler.Managers.SerialManagement', {
    Id = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Availability = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    CurrentConnectStatus = {'y', nil, true, nil},
    Source = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Destination = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    SrcSerial = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    DestSerial = {'y', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {SetConnectStatus = {'a{ss}b', '', TSetConnectStatusReq, TSetConnectStatusRsp}}, {})

return SerialManagement
