-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerSupplyMetrics = {}

---@class PowerSupplyMetrics.OutputPowerWattsReactiveVAR
---@field OutputPowerWattsReactiveVAR number
local TOutputPowerWattsReactiveVAR = {}
TOutputPowerWattsReactiveVAR.__index = TOutputPowerWattsReactiveVAR
TOutputPowerWattsReactiveVAR.group = {}

local function TOutputPowerWattsReactiveVAR_from_obj(obj)
    return setmetatable(obj, TOutputPowerWattsReactiveVAR)
end

function TOutputPowerWattsReactiveVAR.new(OutputPowerWattsReactiveVAR)
    return TOutputPowerWattsReactiveVAR_from_obj({OutputPowerWattsReactiveVAR = OutputPowerWattsReactiveVAR})
end
---@param obj PowerSupplyMetrics.OutputPowerWattsReactiveVAR
function TOutputPowerWattsReactiveVAR:init_from_obj(obj)
    self.OutputPowerWattsReactiveVAR = obj.OutputPowerWattsReactiveVAR
end

function TOutputPowerWattsReactiveVAR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerWattsReactiveVAR.group)
end

TOutputPowerWattsReactiveVAR.from_obj = TOutputPowerWattsReactiveVAR_from_obj

TOutputPowerWattsReactiveVAR.proto_property = {'OutputPowerWattsReactiveVAR'}

TOutputPowerWattsReactiveVAR.default = {0}

TOutputPowerWattsReactiveVAR.struct = {{name = 'OutputPowerWattsReactiveVAR', is_array = false, struct = nil}}

function TOutputPowerWattsReactiveVAR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerWattsReactiveVAR', self.OutputPowerWattsReactiveVAR, 'double', true, errs,
        need_convert)

    TOutputPowerWattsReactiveVAR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerWattsReactiveVAR.proto_property, errs, need_convert)
    return self
end

function TOutputPowerWattsReactiveVAR:unpack(_)
    return self.OutputPowerWattsReactiveVAR
end

PowerSupplyMetrics.OutputPowerWattsReactiveVAR = TOutputPowerWattsReactiveVAR

---@class PowerSupplyMetrics.OutputPowerWattsPowerFactor
---@field OutputPowerWattsPowerFactor number
local TOutputPowerWattsPowerFactor = {}
TOutputPowerWattsPowerFactor.__index = TOutputPowerWattsPowerFactor
TOutputPowerWattsPowerFactor.group = {}

local function TOutputPowerWattsPowerFactor_from_obj(obj)
    return setmetatable(obj, TOutputPowerWattsPowerFactor)
end

function TOutputPowerWattsPowerFactor.new(OutputPowerWattsPowerFactor)
    return TOutputPowerWattsPowerFactor_from_obj({OutputPowerWattsPowerFactor = OutputPowerWattsPowerFactor})
end
---@param obj PowerSupplyMetrics.OutputPowerWattsPowerFactor
function TOutputPowerWattsPowerFactor:init_from_obj(obj)
    self.OutputPowerWattsPowerFactor = obj.OutputPowerWattsPowerFactor
end

function TOutputPowerWattsPowerFactor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerWattsPowerFactor.group)
end

TOutputPowerWattsPowerFactor.from_obj = TOutputPowerWattsPowerFactor_from_obj

TOutputPowerWattsPowerFactor.proto_property = {'OutputPowerWattsPowerFactor'}

TOutputPowerWattsPowerFactor.default = {0}

TOutputPowerWattsPowerFactor.struct = {{name = 'OutputPowerWattsPowerFactor', is_array = false, struct = nil}}

function TOutputPowerWattsPowerFactor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerWattsPowerFactor', self.OutputPowerWattsPowerFactor, 'double', true, errs,
        need_convert)

    TOutputPowerWattsPowerFactor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerWattsPowerFactor.proto_property, errs, need_convert)
    return self
end

function TOutputPowerWattsPowerFactor:unpack(_)
    return self.OutputPowerWattsPowerFactor
end

PowerSupplyMetrics.OutputPowerWattsPowerFactor = TOutputPowerWattsPowerFactor

---@class PowerSupplyMetrics.OutputPowerWattsPhaseAngleDegrees
---@field OutputPowerWattsPhaseAngleDegrees number
local TOutputPowerWattsPhaseAngleDegrees = {}
TOutputPowerWattsPhaseAngleDegrees.__index = TOutputPowerWattsPhaseAngleDegrees
TOutputPowerWattsPhaseAngleDegrees.group = {}

local function TOutputPowerWattsPhaseAngleDegrees_from_obj(obj)
    return setmetatable(obj, TOutputPowerWattsPhaseAngleDegrees)
end

function TOutputPowerWattsPhaseAngleDegrees.new(OutputPowerWattsPhaseAngleDegrees)
    return TOutputPowerWattsPhaseAngleDegrees_from_obj({
        OutputPowerWattsPhaseAngleDegrees = OutputPowerWattsPhaseAngleDegrees
    })
end
---@param obj PowerSupplyMetrics.OutputPowerWattsPhaseAngleDegrees
function TOutputPowerWattsPhaseAngleDegrees:init_from_obj(obj)
    self.OutputPowerWattsPhaseAngleDegrees = obj.OutputPowerWattsPhaseAngleDegrees
end

function TOutputPowerWattsPhaseAngleDegrees:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerWattsPhaseAngleDegrees.group)
end

TOutputPowerWattsPhaseAngleDegrees.from_obj = TOutputPowerWattsPhaseAngleDegrees_from_obj

TOutputPowerWattsPhaseAngleDegrees.proto_property = {'OutputPowerWattsPhaseAngleDegrees'}

TOutputPowerWattsPhaseAngleDegrees.default = {0}

TOutputPowerWattsPhaseAngleDegrees.struct = {
    {name = 'OutputPowerWattsPhaseAngleDegrees', is_array = false, struct = nil}
}

function TOutputPowerWattsPhaseAngleDegrees:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerWattsPhaseAngleDegrees', self.OutputPowerWattsPhaseAngleDegrees, 'double',
        true, errs, need_convert)

    TOutputPowerWattsPhaseAngleDegrees:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerWattsPhaseAngleDegrees.proto_property, errs, need_convert)
    return self
end

function TOutputPowerWattsPhaseAngleDegrees:unpack(_)
    return self.OutputPowerWattsPhaseAngleDegrees
end

PowerSupplyMetrics.OutputPowerWattsPhaseAngleDegrees = TOutputPowerWattsPhaseAngleDegrees

---@class PowerSupplyMetrics.OutputPowerWattsApparentVA
---@field OutputPowerWattsApparentVA number
local TOutputPowerWattsApparentVA = {}
TOutputPowerWattsApparentVA.__index = TOutputPowerWattsApparentVA
TOutputPowerWattsApparentVA.group = {}

local function TOutputPowerWattsApparentVA_from_obj(obj)
    return setmetatable(obj, TOutputPowerWattsApparentVA)
end

function TOutputPowerWattsApparentVA.new(OutputPowerWattsApparentVA)
    return TOutputPowerWattsApparentVA_from_obj({OutputPowerWattsApparentVA = OutputPowerWattsApparentVA})
end
---@param obj PowerSupplyMetrics.OutputPowerWattsApparentVA
function TOutputPowerWattsApparentVA:init_from_obj(obj)
    self.OutputPowerWattsApparentVA = obj.OutputPowerWattsApparentVA
end

function TOutputPowerWattsApparentVA:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerWattsApparentVA.group)
end

TOutputPowerWattsApparentVA.from_obj = TOutputPowerWattsApparentVA_from_obj

TOutputPowerWattsApparentVA.proto_property = {'OutputPowerWattsApparentVA'}

TOutputPowerWattsApparentVA.default = {0}

TOutputPowerWattsApparentVA.struct = {{name = 'OutputPowerWattsApparentVA', is_array = false, struct = nil}}

function TOutputPowerWattsApparentVA:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerWattsApparentVA', self.OutputPowerWattsApparentVA, 'double', true, errs,
        need_convert)

    TOutputPowerWattsApparentVA:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerWattsApparentVA.proto_property, errs, need_convert)
    return self
end

function TOutputPowerWattsApparentVA:unpack(_)
    return self.OutputPowerWattsApparentVA
end

PowerSupplyMetrics.OutputPowerWattsApparentVA = TOutputPowerWattsApparentVA

---@class PowerSupplyMetrics.InputVoltageCrestFactor
---@field InputVoltageCrestFactor number
local TInputVoltageCrestFactor = {}
TInputVoltageCrestFactor.__index = TInputVoltageCrestFactor
TInputVoltageCrestFactor.group = {}

local function TInputVoltageCrestFactor_from_obj(obj)
    return setmetatable(obj, TInputVoltageCrestFactor)
end

function TInputVoltageCrestFactor.new(InputVoltageCrestFactor)
    return TInputVoltageCrestFactor_from_obj({InputVoltageCrestFactor = InputVoltageCrestFactor})
end
---@param obj PowerSupplyMetrics.InputVoltageCrestFactor
function TInputVoltageCrestFactor:init_from_obj(obj)
    self.InputVoltageCrestFactor = obj.InputVoltageCrestFactor
end

function TInputVoltageCrestFactor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltageCrestFactor.group)
end

TInputVoltageCrestFactor.from_obj = TInputVoltageCrestFactor_from_obj

TInputVoltageCrestFactor.proto_property = {'InputVoltageCrestFactor'}

TInputVoltageCrestFactor.default = {0}

TInputVoltageCrestFactor.struct = {{name = 'InputVoltageCrestFactor', is_array = false, struct = nil}}

function TInputVoltageCrestFactor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltageCrestFactor', self.InputVoltageCrestFactor, 'double', true, errs,
        need_convert)

    TInputVoltageCrestFactor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltageCrestFactor.proto_property, errs, need_convert)
    return self
end

function TInputVoltageCrestFactor:unpack(_)
    return self.InputVoltageCrestFactor
end

PowerSupplyMetrics.InputVoltageCrestFactor = TInputVoltageCrestFactor

---@class PowerSupplyMetrics.InputPowerWattsReactiveVAR
---@field InputPowerWattsReactiveVAR number
local TInputPowerWattsReactiveVAR = {}
TInputPowerWattsReactiveVAR.__index = TInputPowerWattsReactiveVAR
TInputPowerWattsReactiveVAR.group = {}

local function TInputPowerWattsReactiveVAR_from_obj(obj)
    return setmetatable(obj, TInputPowerWattsReactiveVAR)
end

function TInputPowerWattsReactiveVAR.new(InputPowerWattsReactiveVAR)
    return TInputPowerWattsReactiveVAR_from_obj({InputPowerWattsReactiveVAR = InputPowerWattsReactiveVAR})
end
---@param obj PowerSupplyMetrics.InputPowerWattsReactiveVAR
function TInputPowerWattsReactiveVAR:init_from_obj(obj)
    self.InputPowerWattsReactiveVAR = obj.InputPowerWattsReactiveVAR
end

function TInputPowerWattsReactiveVAR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputPowerWattsReactiveVAR.group)
end

TInputPowerWattsReactiveVAR.from_obj = TInputPowerWattsReactiveVAR_from_obj

TInputPowerWattsReactiveVAR.proto_property = {'InputPowerWattsReactiveVAR'}

TInputPowerWattsReactiveVAR.default = {0}

TInputPowerWattsReactiveVAR.struct = {{name = 'InputPowerWattsReactiveVAR', is_array = false, struct = nil}}

function TInputPowerWattsReactiveVAR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputPowerWattsReactiveVAR', self.InputPowerWattsReactiveVAR, 'double', true, errs,
        need_convert)

    TInputPowerWattsReactiveVAR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputPowerWattsReactiveVAR.proto_property, errs, need_convert)
    return self
end

function TInputPowerWattsReactiveVAR:unpack(_)
    return self.InputPowerWattsReactiveVAR
end

PowerSupplyMetrics.InputPowerWattsReactiveVAR = TInputPowerWattsReactiveVAR

---@class PowerSupplyMetrics.InputPowerWattsPowerFactor
---@field InputPowerWattsPowerFactor number
local TInputPowerWattsPowerFactor = {}
TInputPowerWattsPowerFactor.__index = TInputPowerWattsPowerFactor
TInputPowerWattsPowerFactor.group = {}

local function TInputPowerWattsPowerFactor_from_obj(obj)
    return setmetatable(obj, TInputPowerWattsPowerFactor)
end

function TInputPowerWattsPowerFactor.new(InputPowerWattsPowerFactor)
    return TInputPowerWattsPowerFactor_from_obj({InputPowerWattsPowerFactor = InputPowerWattsPowerFactor})
end
---@param obj PowerSupplyMetrics.InputPowerWattsPowerFactor
function TInputPowerWattsPowerFactor:init_from_obj(obj)
    self.InputPowerWattsPowerFactor = obj.InputPowerWattsPowerFactor
end

function TInputPowerWattsPowerFactor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputPowerWattsPowerFactor.group)
end

TInputPowerWattsPowerFactor.from_obj = TInputPowerWattsPowerFactor_from_obj

TInputPowerWattsPowerFactor.proto_property = {'InputPowerWattsPowerFactor'}

TInputPowerWattsPowerFactor.default = {0}

TInputPowerWattsPowerFactor.struct = {{name = 'InputPowerWattsPowerFactor', is_array = false, struct = nil}}

function TInputPowerWattsPowerFactor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputPowerWattsPowerFactor', self.InputPowerWattsPowerFactor, 'double', true, errs,
        need_convert)

    TInputPowerWattsPowerFactor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputPowerWattsPowerFactor.proto_property, errs, need_convert)
    return self
end

function TInputPowerWattsPowerFactor:unpack(_)
    return self.InputPowerWattsPowerFactor
end

PowerSupplyMetrics.InputPowerWattsPowerFactor = TInputPowerWattsPowerFactor

---@class PowerSupplyMetrics.InputPowerWattsPhaseAngleDegrees
---@field InputPowerWattsPhaseAngleDegrees number
local TInputPowerWattsPhaseAngleDegrees = {}
TInputPowerWattsPhaseAngleDegrees.__index = TInputPowerWattsPhaseAngleDegrees
TInputPowerWattsPhaseAngleDegrees.group = {}

local function TInputPowerWattsPhaseAngleDegrees_from_obj(obj)
    return setmetatable(obj, TInputPowerWattsPhaseAngleDegrees)
end

function TInputPowerWattsPhaseAngleDegrees.new(InputPowerWattsPhaseAngleDegrees)
    return TInputPowerWattsPhaseAngleDegrees_from_obj({
        InputPowerWattsPhaseAngleDegrees = InputPowerWattsPhaseAngleDegrees
    })
end
---@param obj PowerSupplyMetrics.InputPowerWattsPhaseAngleDegrees
function TInputPowerWattsPhaseAngleDegrees:init_from_obj(obj)
    self.InputPowerWattsPhaseAngleDegrees = obj.InputPowerWattsPhaseAngleDegrees
end

function TInputPowerWattsPhaseAngleDegrees:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputPowerWattsPhaseAngleDegrees.group)
end

TInputPowerWattsPhaseAngleDegrees.from_obj = TInputPowerWattsPhaseAngleDegrees_from_obj

TInputPowerWattsPhaseAngleDegrees.proto_property = {'InputPowerWattsPhaseAngleDegrees'}

TInputPowerWattsPhaseAngleDegrees.default = {0}

TInputPowerWattsPhaseAngleDegrees.struct = {{name = 'InputPowerWattsPhaseAngleDegrees', is_array = false, struct = nil}}

function TInputPowerWattsPhaseAngleDegrees:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputPowerWattsPhaseAngleDegrees', self.InputPowerWattsPhaseAngleDegrees, 'double',
        true, errs, need_convert)

    TInputPowerWattsPhaseAngleDegrees:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputPowerWattsPhaseAngleDegrees.proto_property, errs, need_convert)
    return self
end

function TInputPowerWattsPhaseAngleDegrees:unpack(_)
    return self.InputPowerWattsPhaseAngleDegrees
end

PowerSupplyMetrics.InputPowerWattsPhaseAngleDegrees = TInputPowerWattsPhaseAngleDegrees

---@class PowerSupplyMetrics.InputPowerWattsApparentVA
---@field InputPowerWattsApparentVA number
local TInputPowerWattsApparentVA = {}
TInputPowerWattsApparentVA.__index = TInputPowerWattsApparentVA
TInputPowerWattsApparentVA.group = {}

local function TInputPowerWattsApparentVA_from_obj(obj)
    return setmetatable(obj, TInputPowerWattsApparentVA)
end

function TInputPowerWattsApparentVA.new(InputPowerWattsApparentVA)
    return TInputPowerWattsApparentVA_from_obj({InputPowerWattsApparentVA = InputPowerWattsApparentVA})
end
---@param obj PowerSupplyMetrics.InputPowerWattsApparentVA
function TInputPowerWattsApparentVA:init_from_obj(obj)
    self.InputPowerWattsApparentVA = obj.InputPowerWattsApparentVA
end

function TInputPowerWattsApparentVA:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputPowerWattsApparentVA.group)
end

TInputPowerWattsApparentVA.from_obj = TInputPowerWattsApparentVA_from_obj

TInputPowerWattsApparentVA.proto_property = {'InputPowerWattsApparentVA'}

TInputPowerWattsApparentVA.default = {0}

TInputPowerWattsApparentVA.struct = {{name = 'InputPowerWattsApparentVA', is_array = false, struct = nil}}

function TInputPowerWattsApparentVA:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputPowerWattsApparentVA', self.InputPowerWattsApparentVA, 'double', true, errs,
        need_convert)

    TInputPowerWattsApparentVA:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputPowerWattsApparentVA.proto_property, errs, need_convert)
    return self
end

function TInputPowerWattsApparentVA:unpack(_)
    return self.InputPowerWattsApparentVA
end

PowerSupplyMetrics.InputPowerWattsApparentVA = TInputPowerWattsApparentVA

---@class PowerSupplyMetrics.InputCurrentAmpsTHDPercent
---@field InputCurrentAmpsTHDPercent number
local TInputCurrentAmpsTHDPercent = {}
TInputCurrentAmpsTHDPercent.__index = TInputCurrentAmpsTHDPercent
TInputCurrentAmpsTHDPercent.group = {}

local function TInputCurrentAmpsTHDPercent_from_obj(obj)
    return setmetatable(obj, TInputCurrentAmpsTHDPercent)
end

function TInputCurrentAmpsTHDPercent.new(InputCurrentAmpsTHDPercent)
    return TInputCurrentAmpsTHDPercent_from_obj({InputCurrentAmpsTHDPercent = InputCurrentAmpsTHDPercent})
end
---@param obj PowerSupplyMetrics.InputCurrentAmpsTHDPercent
function TInputCurrentAmpsTHDPercent:init_from_obj(obj)
    self.InputCurrentAmpsTHDPercent = obj.InputCurrentAmpsTHDPercent
end

function TInputCurrentAmpsTHDPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputCurrentAmpsTHDPercent.group)
end

TInputCurrentAmpsTHDPercent.from_obj = TInputCurrentAmpsTHDPercent_from_obj

TInputCurrentAmpsTHDPercent.proto_property = {'InputCurrentAmpsTHDPercent'}

TInputCurrentAmpsTHDPercent.default = {0}

TInputCurrentAmpsTHDPercent.struct = {{name = 'InputCurrentAmpsTHDPercent', is_array = false, struct = nil}}

function TInputCurrentAmpsTHDPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputCurrentAmpsTHDPercent', self.InputCurrentAmpsTHDPercent, 'double', true, errs,
        need_convert)

    TInputCurrentAmpsTHDPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputCurrentAmpsTHDPercent.proto_property, errs, need_convert)
    return self
end

function TInputCurrentAmpsTHDPercent:unpack(_)
    return self.InputCurrentAmpsTHDPercent
end

PowerSupplyMetrics.InputCurrentAmpsTHDPercent = TInputCurrentAmpsTHDPercent

---@class PowerSupplyMetrics.InputCurrentAmpsCrestFactor
---@field InputCurrentAmpsCrestFactor number
local TInputCurrentAmpsCrestFactor = {}
TInputCurrentAmpsCrestFactor.__index = TInputCurrentAmpsCrestFactor
TInputCurrentAmpsCrestFactor.group = {}

local function TInputCurrentAmpsCrestFactor_from_obj(obj)
    return setmetatable(obj, TInputCurrentAmpsCrestFactor)
end

function TInputCurrentAmpsCrestFactor.new(InputCurrentAmpsCrestFactor)
    return TInputCurrentAmpsCrestFactor_from_obj({InputCurrentAmpsCrestFactor = InputCurrentAmpsCrestFactor})
end
---@param obj PowerSupplyMetrics.InputCurrentAmpsCrestFactor
function TInputCurrentAmpsCrestFactor:init_from_obj(obj)
    self.InputCurrentAmpsCrestFactor = obj.InputCurrentAmpsCrestFactor
end

function TInputCurrentAmpsCrestFactor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputCurrentAmpsCrestFactor.group)
end

TInputCurrentAmpsCrestFactor.from_obj = TInputCurrentAmpsCrestFactor_from_obj

TInputCurrentAmpsCrestFactor.proto_property = {'InputCurrentAmpsCrestFactor'}

TInputCurrentAmpsCrestFactor.default = {0}

TInputCurrentAmpsCrestFactor.struct = {{name = 'InputCurrentAmpsCrestFactor', is_array = false, struct = nil}}

function TInputCurrentAmpsCrestFactor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputCurrentAmpsCrestFactor', self.InputCurrentAmpsCrestFactor, 'double', true, errs,
        need_convert)

    TInputCurrentAmpsCrestFactor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputCurrentAmpsCrestFactor.proto_property, errs, need_convert)
    return self
end

function TInputCurrentAmpsCrestFactor:unpack(_)
    return self.InputCurrentAmpsCrestFactor
end

PowerSupplyMetrics.InputCurrentAmpsCrestFactor = TInputCurrentAmpsCrestFactor

---@class PowerSupplyMetrics.EnergyReactivekVARh
---@field EnergyReactivekVARh number
local TEnergyReactivekVARh = {}
TEnergyReactivekVARh.__index = TEnergyReactivekVARh
TEnergyReactivekVARh.group = {}

local function TEnergyReactivekVARh_from_obj(obj)
    return setmetatable(obj, TEnergyReactivekVARh)
end

function TEnergyReactivekVARh.new(EnergyReactivekVARh)
    return TEnergyReactivekVARh_from_obj({EnergyReactivekVARh = EnergyReactivekVARh})
end
---@param obj PowerSupplyMetrics.EnergyReactivekVARh
function TEnergyReactivekVARh:init_from_obj(obj)
    self.EnergyReactivekVARh = obj.EnergyReactivekVARh
end

function TEnergyReactivekVARh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyReactivekVARh.group)
end

TEnergyReactivekVARh.from_obj = TEnergyReactivekVARh_from_obj

TEnergyReactivekVARh.proto_property = {'EnergyReactivekVARh'}

TEnergyReactivekVARh.default = {0}

TEnergyReactivekVARh.struct = {{name = 'EnergyReactivekVARh', is_array = false, struct = nil}}

function TEnergyReactivekVARh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyReactivekVARh', self.EnergyReactivekVARh, 'double', true, errs, need_convert)

    TEnergyReactivekVARh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyReactivekVARh.proto_property, errs, need_convert)
    return self
end

function TEnergyReactivekVARh:unpack(_)
    return self.EnergyReactivekVARh
end

PowerSupplyMetrics.EnergyReactivekVARh = TEnergyReactivekVARh

---@class PowerSupplyMetrics.EnergyLifetimekWh
---@field EnergyLifetimekWh number
local TEnergyLifetimekWh = {}
TEnergyLifetimekWh.__index = TEnergyLifetimekWh
TEnergyLifetimekWh.group = {}

local function TEnergyLifetimekWh_from_obj(obj)
    return setmetatable(obj, TEnergyLifetimekWh)
end

function TEnergyLifetimekWh.new(EnergyLifetimekWh)
    return TEnergyLifetimekWh_from_obj({EnergyLifetimekWh = EnergyLifetimekWh})
end
---@param obj PowerSupplyMetrics.EnergyLifetimekWh
function TEnergyLifetimekWh:init_from_obj(obj)
    self.EnergyLifetimekWh = obj.EnergyLifetimekWh
end

function TEnergyLifetimekWh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyLifetimekWh.group)
end

TEnergyLifetimekWh.from_obj = TEnergyLifetimekWh_from_obj

TEnergyLifetimekWh.proto_property = {'EnergyLifetimekWh'}

TEnergyLifetimekWh.default = {0}

TEnergyLifetimekWh.struct = {{name = 'EnergyLifetimekWh', is_array = false, struct = nil}}

function TEnergyLifetimekWh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyLifetimekWh', self.EnergyLifetimekWh, 'double', true, errs, need_convert)

    TEnergyLifetimekWh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyLifetimekWh.proto_property, errs, need_convert)
    return self
end

function TEnergyLifetimekWh:unpack(_)
    return self.EnergyLifetimekWh
end

PowerSupplyMetrics.EnergyLifetimekWh = TEnergyLifetimekWh

---@class PowerSupplyMetrics.EnergyApparentkVAh
---@field EnergyApparentkVAh number
local TEnergyApparentkVAh = {}
TEnergyApparentkVAh.__index = TEnergyApparentkVAh
TEnergyApparentkVAh.group = {}

local function TEnergyApparentkVAh_from_obj(obj)
    return setmetatable(obj, TEnergyApparentkVAh)
end

function TEnergyApparentkVAh.new(EnergyApparentkVAh)
    return TEnergyApparentkVAh_from_obj({EnergyApparentkVAh = EnergyApparentkVAh})
end
---@param obj PowerSupplyMetrics.EnergyApparentkVAh
function TEnergyApparentkVAh:init_from_obj(obj)
    self.EnergyApparentkVAh = obj.EnergyApparentkVAh
end

function TEnergyApparentkVAh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyApparentkVAh.group)
end

TEnergyApparentkVAh.from_obj = TEnergyApparentkVAh_from_obj

TEnergyApparentkVAh.proto_property = {'EnergyApparentkVAh'}

TEnergyApparentkVAh.default = {0}

TEnergyApparentkVAh.struct = {{name = 'EnergyApparentkVAh', is_array = false, struct = nil}}

function TEnergyApparentkVAh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyApparentkVAh', self.EnergyApparentkVAh, 'double', true, errs, need_convert)

    TEnergyApparentkVAh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyApparentkVAh.proto_property, errs, need_convert)
    return self
end

function TEnergyApparentkVAh:unpack(_)
    return self.EnergyApparentkVAh
end

PowerSupplyMetrics.EnergyApparentkVAh = TEnergyApparentkVAh

---@class PowerSupplyMetrics.EnergySensorResetTime
---@field EnergySensorResetTime string
local TEnergySensorResetTime = {}
TEnergySensorResetTime.__index = TEnergySensorResetTime
TEnergySensorResetTime.group = {}

local function TEnergySensorResetTime_from_obj(obj)
    return setmetatable(obj, TEnergySensorResetTime)
end

function TEnergySensorResetTime.new(EnergySensorResetTime)
    return TEnergySensorResetTime_from_obj({EnergySensorResetTime = EnergySensorResetTime})
end
---@param obj PowerSupplyMetrics.EnergySensorResetTime
function TEnergySensorResetTime:init_from_obj(obj)
    self.EnergySensorResetTime = obj.EnergySensorResetTime
end

function TEnergySensorResetTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergySensorResetTime.group)
end

TEnergySensorResetTime.from_obj = TEnergySensorResetTime_from_obj

TEnergySensorResetTime.proto_property = {'EnergySensorResetTime'}

TEnergySensorResetTime.default = {''}

TEnergySensorResetTime.struct = {{name = 'EnergySensorResetTime', is_array = false, struct = nil}}

function TEnergySensorResetTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergySensorResetTime', self.EnergySensorResetTime, 'string', true, errs, need_convert)

    TEnergySensorResetTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergySensorResetTime.proto_property, errs, need_convert)
    return self
end

function TEnergySensorResetTime:unpack(_)
    return self.EnergySensorResetTime
end

PowerSupplyMetrics.EnergySensorResetTime = TEnergySensorResetTime

---@class PowerSupplyMetrics.EnergykWh
---@field EnergykWh number
local TEnergykWh = {}
TEnergykWh.__index = TEnergykWh
TEnergykWh.group = {}

local function TEnergykWh_from_obj(obj)
    return setmetatable(obj, TEnergykWh)
end

function TEnergykWh.new(EnergykWh)
    return TEnergykWh_from_obj({EnergykWh = EnergykWh})
end
---@param obj PowerSupplyMetrics.EnergykWh
function TEnergykWh:init_from_obj(obj)
    self.EnergykWh = obj.EnergykWh
end

function TEnergykWh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergykWh.group)
end

TEnergykWh.from_obj = TEnergykWh_from_obj

TEnergykWh.proto_property = {'EnergykWh'}

TEnergykWh.default = {0}

TEnergykWh.struct = {{name = 'EnergykWh', is_array = false, struct = nil}}

function TEnergykWh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergykWh', self.EnergykWh, 'double', true, errs, need_convert)

    TEnergykWh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergykWh.proto_property, errs, need_convert)
    return self
end

function TEnergykWh:unpack(_)
    return self.EnergykWh
end

PowerSupplyMetrics.EnergykWh = TEnergykWh

---@class PowerSupplyMetrics.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj PowerSupplyMetrics.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

PowerSupplyMetrics.ResetRsp = TResetRsp

---@class PowerSupplyMetrics.ResetReq
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new()
    return TResetReq_from_obj({})
end
---@param obj PowerSupplyMetrics.ResetReq
function TResetReq:init_from_obj(obj)

end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {}

TResetReq.default = {}

TResetReq.struct = {}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
end

PowerSupplyMetrics.ResetReq = TResetReq

PowerSupplyMetrics.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.PowerSupply.Metrics', {
    EnergykWh = {'d', {'VOLATILE'}, true, nil},
    EnergySensorResetTime = {'s', {}, true, nil},
    EnergyApparentkVAh = {'d', {}, true, nil},
    EnergyLifetimekWh = {'d', {}, true, nil},
    EnergyReactivekVARh = {'d', {}, true, nil},
    InputCurrentAmpsCrestFactor = {'d', {}, true, nil},
    InputCurrentAmpsTHDPercent = {'d', {}, true, nil},
    InputPowerWattsApparentVA = {'d', {}, true, nil},
    InputPowerWattsPhaseAngleDegrees = {'d', {}, true, nil},
    InputPowerWattsPowerFactor = {'d', {}, true, nil},
    InputPowerWattsReactiveVAR = {'d', {}, true, nil},
    InputVoltageCrestFactor = {'d', {}, true, nil},
    OutputPowerWattsApparentVA = {'d', {}, true, nil},
    OutputPowerWattsPhaseAngleDegrees = {'d', {}, true, nil},
    OutputPowerWattsPowerFactor = {'d', {}, true, nil},
    OutputPowerWattsReactiveVAR = {'d', {}, true, nil}
}, {Reset = {'a{ss}', '', TResetReq, TResetRsp}}, {})

return PowerSupplyMetrics
