-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerSuppliesMetrics = {}

---@class PowerSuppliesMetrics.RequestedWatts
---@field RequestedWatts integer
local TRequestedWatts = {}
TRequestedWatts.__index = TRequestedWatts
TRequestedWatts.group = {}

local function TRequestedWatts_from_obj(obj)
    return setmetatable(obj, TRequestedWatts)
end

function TRequestedWatts.new(RequestedWatts)
    return TRequestedWatts_from_obj({RequestedWatts = RequestedWatts or 4294967295})
end
---@param obj PowerSuppliesMetrics.RequestedWatts
function TRequestedWatts:init_from_obj(obj)
    self.RequestedWatts = obj.RequestedWatts or 4294967295
end

function TRequestedWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRequestedWatts.group)
end

TRequestedWatts.from_obj = TRequestedWatts_from_obj

TRequestedWatts.proto_property = {'RequestedWatts'}

TRequestedWatts.default = {0}

TRequestedWatts.struct = {{name = 'RequestedWatts', is_array = false, struct = nil}}

function TRequestedWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RequestedWatts', self.RequestedWatts, 'uint32', true, errs, need_convert)

    TRequestedWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRequestedWatts.proto_property, errs, need_convert)
    return self
end

function TRequestedWatts:unpack(_)
    return self.RequestedWatts
end

PowerSuppliesMetrics.RequestedWatts = TRequestedWatts

---@class PowerSuppliesMetrics.AllocatedWatts
---@field AllocatedWatts integer
local TAllocatedWatts = {}
TAllocatedWatts.__index = TAllocatedWatts
TAllocatedWatts.group = {}

local function TAllocatedWatts_from_obj(obj)
    return setmetatable(obj, TAllocatedWatts)
end

function TAllocatedWatts.new(AllocatedWatts)
    return TAllocatedWatts_from_obj({AllocatedWatts = AllocatedWatts or 4294967295})
end
---@param obj PowerSuppliesMetrics.AllocatedWatts
function TAllocatedWatts:init_from_obj(obj)
    self.AllocatedWatts = obj.AllocatedWatts or 4294967295
end

function TAllocatedWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAllocatedWatts.group)
end

TAllocatedWatts.from_obj = TAllocatedWatts_from_obj

TAllocatedWatts.proto_property = {'AllocatedWatts'}

TAllocatedWatts.default = {0}

TAllocatedWatts.struct = {{name = 'AllocatedWatts', is_array = false, struct = nil}}

function TAllocatedWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AllocatedWatts', self.AllocatedWatts, 'uint32', true, errs, need_convert)

    TAllocatedWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAllocatedWatts.proto_property, errs, need_convert)
    return self
end

function TAllocatedWatts:unpack(_)
    return self.AllocatedWatts
end

PowerSuppliesMetrics.AllocatedWatts = TAllocatedWatts

PowerSuppliesMetrics.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.PowerSupplies.Metrics', {
    AllocatedWatts = {'u', {}, true, 4294967295},
    RequestedWatts = {'u', {}, true, 4294967295}
}, {}, {})

return PowerSuppliesMetrics
