-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerDistributionMetrics = {}

---@class PowerDistributionMetrics.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius or 255})
end
---@param obj PowerDistributionMetrics.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius or 255
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'uint8', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

PowerDistributionMetrics.TemperatureCelsius = TTemperatureCelsius

---@class PowerDistributionMetrics.PowerWatts
---@field PowerWatts integer
local TPowerWatts = {}
TPowerWatts.__index = TPowerWatts
TPowerWatts.group = {}

local function TPowerWatts_from_obj(obj)
    return setmetatable(obj, TPowerWatts)
end

function TPowerWatts.new(PowerWatts)
    return TPowerWatts_from_obj({PowerWatts = PowerWatts or 4294967295})
end
---@param obj PowerDistributionMetrics.PowerWatts
function TPowerWatts:init_from_obj(obj)
    self.PowerWatts = obj.PowerWatts or 4294967295
end

function TPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatts.group)
end

TPowerWatts.from_obj = TPowerWatts_from_obj

TPowerWatts.proto_property = {'PowerWatts'}

TPowerWatts.default = {0}

TPowerWatts.struct = {{name = 'PowerWatts', is_array = false, struct = nil}}

function TPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatts', self.PowerWatts, 'uint32', true, errs, need_convert)

    TPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatts.proto_property, errs, need_convert)
    return self
end

function TPowerWatts:unpack(_)
    return self.PowerWatts
end

PowerDistributionMetrics.PowerWatts = TPowerWatts

---@class PowerDistributionMetrics.PowerReactiveVAR
---@field PowerReactiveVAR number
local TPowerReactiveVAR = {}
TPowerReactiveVAR.__index = TPowerReactiveVAR
TPowerReactiveVAR.group = {}

local function TPowerReactiveVAR_from_obj(obj)
    return setmetatable(obj, TPowerReactiveVAR)
end

function TPowerReactiveVAR.new(PowerReactiveVAR)
    return TPowerReactiveVAR_from_obj({PowerReactiveVAR = PowerReactiveVAR or -1})
end
---@param obj PowerDistributionMetrics.PowerReactiveVAR
function TPowerReactiveVAR:init_from_obj(obj)
    self.PowerReactiveVAR = obj.PowerReactiveVAR or -1
end

function TPowerReactiveVAR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerReactiveVAR.group)
end

TPowerReactiveVAR.from_obj = TPowerReactiveVAR_from_obj

TPowerReactiveVAR.proto_property = {'PowerReactiveVAR'}

TPowerReactiveVAR.default = {0}

TPowerReactiveVAR.struct = {{name = 'PowerReactiveVAR', is_array = false, struct = nil}}

function TPowerReactiveVAR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerReactiveVAR', self.PowerReactiveVAR, 'double', true, errs, need_convert)

    TPowerReactiveVAR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerReactiveVAR.proto_property, errs, need_convert)
    return self
end

function TPowerReactiveVAR:unpack(_)
    return self.PowerReactiveVAR
end

PowerDistributionMetrics.PowerReactiveVAR = TPowerReactiveVAR

---@class PowerDistributionMetrics.PowerFactor
---@field PowerFactor number
local TPowerFactor = {}
TPowerFactor.__index = TPowerFactor
TPowerFactor.group = {}

local function TPowerFactor_from_obj(obj)
    return setmetatable(obj, TPowerFactor)
end

function TPowerFactor.new(PowerFactor)
    return TPowerFactor_from_obj({PowerFactor = PowerFactor or -1})
end
---@param obj PowerDistributionMetrics.PowerFactor
function TPowerFactor:init_from_obj(obj)
    self.PowerFactor = obj.PowerFactor or -1
end

function TPowerFactor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerFactor.group)
end

TPowerFactor.from_obj = TPowerFactor_from_obj

TPowerFactor.proto_property = {'PowerFactor'}

TPowerFactor.default = {0}

TPowerFactor.struct = {{name = 'PowerFactor', is_array = false, struct = nil}}

function TPowerFactor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerFactor', self.PowerFactor, 'double', true, errs, need_convert)

    TPowerFactor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerFactor.proto_property, errs, need_convert)
    return self
end

function TPowerFactor:unpack(_)
    return self.PowerFactor
end

PowerDistributionMetrics.PowerFactor = TPowerFactor

---@class PowerDistributionMetrics.PowerPhaseAngleDegrees
---@field PowerPhaseAngleDegrees number
local TPowerPhaseAngleDegrees = {}
TPowerPhaseAngleDegrees.__index = TPowerPhaseAngleDegrees
TPowerPhaseAngleDegrees.group = {}

local function TPowerPhaseAngleDegrees_from_obj(obj)
    return setmetatable(obj, TPowerPhaseAngleDegrees)
end

function TPowerPhaseAngleDegrees.new(PowerPhaseAngleDegrees)
    return TPowerPhaseAngleDegrees_from_obj({PowerPhaseAngleDegrees = PowerPhaseAngleDegrees or 1000})
end
---@param obj PowerDistributionMetrics.PowerPhaseAngleDegrees
function TPowerPhaseAngleDegrees:init_from_obj(obj)
    self.PowerPhaseAngleDegrees = obj.PowerPhaseAngleDegrees or 1000
end

function TPowerPhaseAngleDegrees:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerPhaseAngleDegrees.group)
end

TPowerPhaseAngleDegrees.from_obj = TPowerPhaseAngleDegrees_from_obj

TPowerPhaseAngleDegrees.proto_property = {'PowerPhaseAngleDegrees'}

TPowerPhaseAngleDegrees.default = {0}

TPowerPhaseAngleDegrees.struct = {{name = 'PowerPhaseAngleDegrees', is_array = false, struct = nil}}

function TPowerPhaseAngleDegrees:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerPhaseAngleDegrees', self.PowerPhaseAngleDegrees, 'double', true, errs,
        need_convert)

    TPowerPhaseAngleDegrees:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerPhaseAngleDegrees.proto_property, errs, need_convert)
    return self
end

function TPowerPhaseAngleDegrees:unpack(_)
    return self.PowerPhaseAngleDegrees
end

PowerDistributionMetrics.PowerPhaseAngleDegrees = TPowerPhaseAngleDegrees

---@class PowerDistributionMetrics.PowerApparentVA
---@field PowerApparentVA number
local TPowerApparentVA = {}
TPowerApparentVA.__index = TPowerApparentVA
TPowerApparentVA.group = {}

local function TPowerApparentVA_from_obj(obj)
    return setmetatable(obj, TPowerApparentVA)
end

function TPowerApparentVA.new(PowerApparentVA)
    return TPowerApparentVA_from_obj({PowerApparentVA = PowerApparentVA or -1})
end
---@param obj PowerDistributionMetrics.PowerApparentVA
function TPowerApparentVA:init_from_obj(obj)
    self.PowerApparentVA = obj.PowerApparentVA or -1
end

function TPowerApparentVA:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerApparentVA.group)
end

TPowerApparentVA.from_obj = TPowerApparentVA_from_obj

TPowerApparentVA.proto_property = {'PowerApparentVA'}

TPowerApparentVA.default = {0}

TPowerApparentVA.struct = {{name = 'PowerApparentVA', is_array = false, struct = nil}}

function TPowerApparentVA:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerApparentVA', self.PowerApparentVA, 'double', true, errs, need_convert)

    TPowerApparentVA:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerApparentVA.proto_property, errs, need_convert)
    return self
end

function TPowerApparentVA:unpack(_)
    return self.PowerApparentVA
end

PowerDistributionMetrics.PowerApparentVA = TPowerApparentVA

---@class PowerDistributionMetrics.PowerLoadPercent
---@field PowerLoadPercent integer
local TPowerLoadPercent = {}
TPowerLoadPercent.__index = TPowerLoadPercent
TPowerLoadPercent.group = {}

local function TPowerLoadPercent_from_obj(obj)
    return setmetatable(obj, TPowerLoadPercent)
end

function TPowerLoadPercent.new(PowerLoadPercent)
    return TPowerLoadPercent_from_obj({PowerLoadPercent = PowerLoadPercent or 255})
end
---@param obj PowerDistributionMetrics.PowerLoadPercent
function TPowerLoadPercent:init_from_obj(obj)
    self.PowerLoadPercent = obj.PowerLoadPercent or 255
end

function TPowerLoadPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerLoadPercent.group)
end

TPowerLoadPercent.from_obj = TPowerLoadPercent_from_obj

TPowerLoadPercent.proto_property = {'PowerLoadPercent'}

TPowerLoadPercent.default = {0}

TPowerLoadPercent.struct = {{name = 'PowerLoadPercent', is_array = false, struct = nil}}

function TPowerLoadPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerLoadPercent', self.PowerLoadPercent, 'uint8', true, errs, need_convert)

    TPowerLoadPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerLoadPercent.proto_property, errs, need_convert)
    return self
end

function TPowerLoadPercent:unpack(_)
    return self.PowerLoadPercent
end

PowerDistributionMetrics.PowerLoadPercent = TPowerLoadPercent

---@class PowerDistributionMetrics.HumidityPercent
---@field HumidityPercent integer
local THumidityPercent = {}
THumidityPercent.__index = THumidityPercent
THumidityPercent.group = {}

local function THumidityPercent_from_obj(obj)
    return setmetatable(obj, THumidityPercent)
end

function THumidityPercent.new(HumidityPercent)
    return THumidityPercent_from_obj({HumidityPercent = HumidityPercent or 255})
end
---@param obj PowerDistributionMetrics.HumidityPercent
function THumidityPercent:init_from_obj(obj)
    self.HumidityPercent = obj.HumidityPercent or 255
end

function THumidityPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THumidityPercent.group)
end

THumidityPercent.from_obj = THumidityPercent_from_obj

THumidityPercent.proto_property = {'HumidityPercent'}

THumidityPercent.default = {0}

THumidityPercent.struct = {{name = 'HumidityPercent', is_array = false, struct = nil}}

function THumidityPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HumidityPercent', self.HumidityPercent, 'uint8', true, errs, need_convert)

    THumidityPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THumidityPercent.proto_property, errs, need_convert)
    return self
end

function THumidityPercent:unpack(_)
    return self.HumidityPercent
end

PowerDistributionMetrics.HumidityPercent = THumidityPercent

---@class PowerDistributionMetrics.EnergySensorResetTime
---@field EnergySensorResetTime string
local TEnergySensorResetTime = {}
TEnergySensorResetTime.__index = TEnergySensorResetTime
TEnergySensorResetTime.group = {}

local function TEnergySensorResetTime_from_obj(obj)
    return setmetatable(obj, TEnergySensorResetTime)
end

function TEnergySensorResetTime.new(EnergySensorResetTime)
    return TEnergySensorResetTime_from_obj({EnergySensorResetTime = EnergySensorResetTime})
end
---@param obj PowerDistributionMetrics.EnergySensorResetTime
function TEnergySensorResetTime:init_from_obj(obj)
    self.EnergySensorResetTime = obj.EnergySensorResetTime
end

function TEnergySensorResetTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergySensorResetTime.group)
end

TEnergySensorResetTime.from_obj = TEnergySensorResetTime_from_obj

TEnergySensorResetTime.proto_property = {'EnergySensorResetTime'}

TEnergySensorResetTime.default = {''}

TEnergySensorResetTime.struct = {{name = 'EnergySensorResetTime', is_array = false, struct = nil}}

function TEnergySensorResetTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergySensorResetTime', self.EnergySensorResetTime, 'string', true, errs, need_convert)

    TEnergySensorResetTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergySensorResetTime.proto_property, errs, need_convert)
    return self
end

function TEnergySensorResetTime:unpack(_)
    return self.EnergySensorResetTime
end

PowerDistributionMetrics.EnergySensorResetTime = TEnergySensorResetTime

---@class PowerDistributionMetrics.EnergykWh
---@field EnergykWh number
local TEnergykWh = {}
TEnergykWh.__index = TEnergykWh
TEnergykWh.group = {}

local function TEnergykWh_from_obj(obj)
    return setmetatable(obj, TEnergykWh)
end

function TEnergykWh.new(EnergykWh)
    return TEnergykWh_from_obj({EnergykWh = EnergykWh or -1})
end
---@param obj PowerDistributionMetrics.EnergykWh
function TEnergykWh:init_from_obj(obj)
    self.EnergykWh = obj.EnergykWh or -1
end

function TEnergykWh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergykWh.group)
end

TEnergykWh.from_obj = TEnergykWh_from_obj

TEnergykWh.proto_property = {'EnergykWh'}

TEnergykWh.default = {0}

TEnergykWh.struct = {{name = 'EnergykWh', is_array = false, struct = nil}}

function TEnergykWh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergykWh', self.EnergykWh, 'double', true, errs, need_convert)

    TEnergykWh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergykWh.proto_property, errs, need_convert)
    return self
end

function TEnergykWh:unpack(_)
    return self.EnergykWh
end

PowerDistributionMetrics.EnergykWh = TEnergykWh

---@class PowerDistributionMetrics.EnergyReactivekVARh
---@field EnergyReactivekVARh number
local TEnergyReactivekVARh = {}
TEnergyReactivekVARh.__index = TEnergyReactivekVARh
TEnergyReactivekVARh.group = {}

local function TEnergyReactivekVARh_from_obj(obj)
    return setmetatable(obj, TEnergyReactivekVARh)
end

function TEnergyReactivekVARh.new(EnergyReactivekVARh)
    return TEnergyReactivekVARh_from_obj({EnergyReactivekVARh = EnergyReactivekVARh or -1})
end
---@param obj PowerDistributionMetrics.EnergyReactivekVARh
function TEnergyReactivekVARh:init_from_obj(obj)
    self.EnergyReactivekVARh = obj.EnergyReactivekVARh or -1
end

function TEnergyReactivekVARh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyReactivekVARh.group)
end

TEnergyReactivekVARh.from_obj = TEnergyReactivekVARh_from_obj

TEnergyReactivekVARh.proto_property = {'EnergyReactivekVARh'}

TEnergyReactivekVARh.default = {0}

TEnergyReactivekVARh.struct = {{name = 'EnergyReactivekVARh', is_array = false, struct = nil}}

function TEnergyReactivekVARh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyReactivekVARh', self.EnergyReactivekVARh, 'double', true, errs, need_convert)

    TEnergyReactivekVARh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyReactivekVARh.proto_property, errs, need_convert)
    return self
end

function TEnergyReactivekVARh:unpack(_)
    return self.EnergyReactivekVARh
end

PowerDistributionMetrics.EnergyReactivekVARh = TEnergyReactivekVARh

---@class PowerDistributionMetrics.EnergyLifetimekWh
---@field EnergyLifetimekWh number
local TEnergyLifetimekWh = {}
TEnergyLifetimekWh.__index = TEnergyLifetimekWh
TEnergyLifetimekWh.group = {}

local function TEnergyLifetimekWh_from_obj(obj)
    return setmetatable(obj, TEnergyLifetimekWh)
end

function TEnergyLifetimekWh.new(EnergyLifetimekWh)
    return TEnergyLifetimekWh_from_obj({EnergyLifetimekWh = EnergyLifetimekWh or -1})
end
---@param obj PowerDistributionMetrics.EnergyLifetimekWh
function TEnergyLifetimekWh:init_from_obj(obj)
    self.EnergyLifetimekWh = obj.EnergyLifetimekWh or -1
end

function TEnergyLifetimekWh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyLifetimekWh.group)
end

TEnergyLifetimekWh.from_obj = TEnergyLifetimekWh_from_obj

TEnergyLifetimekWh.proto_property = {'EnergyLifetimekWh'}

TEnergyLifetimekWh.default = {0}

TEnergyLifetimekWh.struct = {{name = 'EnergyLifetimekWh', is_array = false, struct = nil}}

function TEnergyLifetimekWh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyLifetimekWh', self.EnergyLifetimekWh, 'double', true, errs, need_convert)

    TEnergyLifetimekWh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyLifetimekWh.proto_property, errs, need_convert)
    return self
end

function TEnergyLifetimekWh:unpack(_)
    return self.EnergyLifetimekWh
end

PowerDistributionMetrics.EnergyLifetimekWh = TEnergyLifetimekWh

---@class PowerDistributionMetrics.EnergyApparentkVAh
---@field EnergyApparentkVAh number
local TEnergyApparentkVAh = {}
TEnergyApparentkVAh.__index = TEnergyApparentkVAh
TEnergyApparentkVAh.group = {}

local function TEnergyApparentkVAh_from_obj(obj)
    return setmetatable(obj, TEnergyApparentkVAh)
end

function TEnergyApparentkVAh.new(EnergyApparentkVAh)
    return TEnergyApparentkVAh_from_obj({EnergyApparentkVAh = EnergyApparentkVAh or -1})
end
---@param obj PowerDistributionMetrics.EnergyApparentkVAh
function TEnergyApparentkVAh:init_from_obj(obj)
    self.EnergyApparentkVAh = obj.EnergyApparentkVAh or -1
end

function TEnergyApparentkVAh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyApparentkVAh.group)
end

TEnergyApparentkVAh.from_obj = TEnergyApparentkVAh_from_obj

TEnergyApparentkVAh.proto_property = {'EnergyApparentkVAh'}

TEnergyApparentkVAh.default = {0}

TEnergyApparentkVAh.struct = {{name = 'EnergyApparentkVAh', is_array = false, struct = nil}}

function TEnergyApparentkVAh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyApparentkVAh', self.EnergyApparentkVAh, 'double', true, errs, need_convert)

    TEnergyApparentkVAh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyApparentkVAh.proto_property, errs, need_convert)
    return self
end

function TEnergyApparentkVAh:unpack(_)
    return self.EnergyApparentkVAh
end

PowerDistributionMetrics.EnergyApparentkVAh = TEnergyApparentkVAh

---@class PowerDistributionMetrics.AbsoluteHumidity
---@field AbsoluteHumidity number
local TAbsoluteHumidity = {}
TAbsoluteHumidity.__index = TAbsoluteHumidity
TAbsoluteHumidity.group = {}

local function TAbsoluteHumidity_from_obj(obj)
    return setmetatable(obj, TAbsoluteHumidity)
end

function TAbsoluteHumidity.new(AbsoluteHumidity)
    return TAbsoluteHumidity_from_obj({AbsoluteHumidity = AbsoluteHumidity or -1})
end
---@param obj PowerDistributionMetrics.AbsoluteHumidity
function TAbsoluteHumidity:init_from_obj(obj)
    self.AbsoluteHumidity = obj.AbsoluteHumidity or -1
end

function TAbsoluteHumidity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAbsoluteHumidity.group)
end

TAbsoluteHumidity.from_obj = TAbsoluteHumidity_from_obj

TAbsoluteHumidity.proto_property = {'AbsoluteHumidity'}

TAbsoluteHumidity.default = {0}

TAbsoluteHumidity.struct = {{name = 'AbsoluteHumidity', is_array = false, struct = nil}}

function TAbsoluteHumidity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AbsoluteHumidity', self.AbsoluteHumidity, 'double', true, errs, need_convert)

    TAbsoluteHumidity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAbsoluteHumidity.proto_property, errs, need_convert)
    return self
end

function TAbsoluteHumidity:unpack(_)
    return self.AbsoluteHumidity
end

PowerDistributionMetrics.AbsoluteHumidity = TAbsoluteHumidity

---@class PowerDistributionMetrics.ResetMetricsRsp
local TResetMetricsRsp = {}
TResetMetricsRsp.__index = TResetMetricsRsp
TResetMetricsRsp.group = {}

local function TResetMetricsRsp_from_obj(obj)
    return setmetatable(obj, TResetMetricsRsp)
end

function TResetMetricsRsp.new()
    return TResetMetricsRsp_from_obj({})
end
---@param obj PowerDistributionMetrics.ResetMetricsRsp
function TResetMetricsRsp:init_from_obj(obj)

end

function TResetMetricsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetMetricsRsp.group)
end

TResetMetricsRsp.from_obj = TResetMetricsRsp_from_obj

TResetMetricsRsp.proto_property = {}

TResetMetricsRsp.default = {}

TResetMetricsRsp.struct = {}

function TResetMetricsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetMetricsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetMetricsRsp.proto_property, errs, need_convert)
    return self
end

function TResetMetricsRsp:unpack(_)
end

PowerDistributionMetrics.ResetMetricsRsp = TResetMetricsRsp

---@class PowerDistributionMetrics.ResetMetricsReq
local TResetMetricsReq = {}
TResetMetricsReq.__index = TResetMetricsReq
TResetMetricsReq.group = {}

local function TResetMetricsReq_from_obj(obj)
    return setmetatable(obj, TResetMetricsReq)
end

function TResetMetricsReq.new()
    return TResetMetricsReq_from_obj({})
end
---@param obj PowerDistributionMetrics.ResetMetricsReq
function TResetMetricsReq:init_from_obj(obj)

end

function TResetMetricsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetMetricsReq.group)
end

TResetMetricsReq.from_obj = TResetMetricsReq_from_obj

TResetMetricsReq.proto_property = {}

TResetMetricsReq.default = {}

TResetMetricsReq.struct = {}

function TResetMetricsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetMetricsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetMetricsReq.proto_property, errs, need_convert)
    return self
end

function TResetMetricsReq:unpack(_)
end

PowerDistributionMetrics.ResetMetricsReq = TResetMetricsReq

PowerDistributionMetrics.interface = mdb.register_interface('bmc.kepler.PowerEquipment.PowerDistribution.Metrics', {
    AbsoluteHumidity = {'d', {}, true, -1},
    EnergyApparentkVAh = {'d', {}, true, -1},
    EnergyLifetimekWh = {'d', {}, true, -1},
    EnergyReactivekVARh = {'d', {}, true, -1},
    EnergykWh = {'d', {}, true, -1},
    EnergySensorResetTime = {'s', {}, true, nil},
    HumidityPercent = {'y', {}, true, 255},
    PowerLoadPercent = {'y', {}, true, 255},
    PowerApparentVA = {'d', {}, true, -1},
    PowerPhaseAngleDegrees = {'d', {}, true, 1000},
    PowerFactor = {'d', {}, true, -1},
    PowerReactiveVAR = {'d', {}, true, -1},
    PowerWatts = {'u', {}, true, 4294967295},
    TemperatureCelsius = {'y', {}, true, 255}
}, {ResetMetrics = {'a{ss}', '', TResetMetricsReq, TResetMetricsRsp}}, {})

return PowerDistributionMetrics
