-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerDistribution = {}

---@class PowerDistribution.LocationOrdinalValue
---@field LocationOrdinalValue integer
local TLocationOrdinalValue = {}
TLocationOrdinalValue.__index = TLocationOrdinalValue
TLocationOrdinalValue.group = {}

local function TLocationOrdinalValue_from_obj(obj)
    return setmetatable(obj, TLocationOrdinalValue)
end

function TLocationOrdinalValue.new(LocationOrdinalValue)
    return TLocationOrdinalValue_from_obj({LocationOrdinalValue = LocationOrdinalValue or 255})
end
---@param obj PowerDistribution.LocationOrdinalValue
function TLocationOrdinalValue:init_from_obj(obj)
    self.LocationOrdinalValue = obj.LocationOrdinalValue or 255
end

function TLocationOrdinalValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationOrdinalValue.group)
end

TLocationOrdinalValue.from_obj = TLocationOrdinalValue_from_obj

TLocationOrdinalValue.proto_property = {'LocationOrdinalValue'}

TLocationOrdinalValue.default = {0}

TLocationOrdinalValue.struct = {{name = 'LocationOrdinalValue', is_array = false, struct = nil}}

function TLocationOrdinalValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationOrdinalValue', self.LocationOrdinalValue, 'uint8', true, errs, need_convert)

    TLocationOrdinalValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationOrdinalValue.proto_property, errs, need_convert)
    return self
end

function TLocationOrdinalValue:unpack(_)
    return self.LocationOrdinalValue
end

PowerDistribution.LocationOrdinalValue = TLocationOrdinalValue

---@class PowerDistribution.LocationType
---@field LocationType string
local TLocationType = {}
TLocationType.__index = TLocationType
TLocationType.group = {}

local function TLocationType_from_obj(obj)
    return setmetatable(obj, TLocationType)
end

function TLocationType.new(LocationType)
    return TLocationType_from_obj({LocationType = LocationType})
end
---@param obj PowerDistribution.LocationType
function TLocationType:init_from_obj(obj)
    self.LocationType = obj.LocationType
end

function TLocationType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationType.group)
end

TLocationType.from_obj = TLocationType_from_obj

TLocationType.proto_property = {'LocationType'}

TLocationType.default = {''}

TLocationType.struct = {{name = 'LocationType', is_array = false, struct = nil}}

function TLocationType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationType', self.LocationType, 'string', true, errs, need_convert)

    if self.LocationType ~= nil then
        validate.Enum(prefix .. 'LocationType', self.LocationType, '',
            {'Backplane', 'Bay', 'Connector', 'Embedded', 'Slot', 'Socket', ''}, errs, need_convert)
    end

    TLocationType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationType.proto_property, errs, need_convert)
    return self
end

function TLocationType:unpack(_)
    return self.LocationType
end

PowerDistribution.LocationType = TLocationType

---@class PowerDistribution.LocationOrientation
---@field LocationOrientation string
local TLocationOrientation = {}
TLocationOrientation.__index = TLocationOrientation
TLocationOrientation.group = {}

local function TLocationOrientation_from_obj(obj)
    return setmetatable(obj, TLocationOrientation)
end

function TLocationOrientation.new(LocationOrientation)
    return TLocationOrientation_from_obj({LocationOrientation = LocationOrientation})
end
---@param obj PowerDistribution.LocationOrientation
function TLocationOrientation:init_from_obj(obj)
    self.LocationOrientation = obj.LocationOrientation
end

function TLocationOrientation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationOrientation.group)
end

TLocationOrientation.from_obj = TLocationOrientation_from_obj

TLocationOrientation.proto_property = {'LocationOrientation'}

TLocationOrientation.default = {''}

TLocationOrientation.struct = {{name = 'LocationOrientation', is_array = false, struct = nil}}

function TLocationOrientation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationOrientation', self.LocationOrientation, 'string', true, errs, need_convert)

    if self.LocationOrientation ~= nil then
        validate.Enum(prefix .. 'LocationOrientation', self.LocationOrientation, '',
            {'BackToFront', 'BottomToTop', 'FrontToBack', 'LeftToRight', 'RightToLeft', 'TopToBottom', ''}, errs,
            need_convert)
    end

    TLocationOrientation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationOrientation.proto_property, errs, need_convert)
    return self
end

function TLocationOrientation:unpack(_)
    return self.LocationOrientation
end

PowerDistribution.LocationOrientation = TLocationOrientation

---@class PowerDistribution.LocationReference
---@field LocationReference string
local TLocationReference = {}
TLocationReference.__index = TLocationReference
TLocationReference.group = {}

local function TLocationReference_from_obj(obj)
    return setmetatable(obj, TLocationReference)
end

function TLocationReference.new(LocationReference)
    return TLocationReference_from_obj({LocationReference = LocationReference})
end
---@param obj PowerDistribution.LocationReference
function TLocationReference:init_from_obj(obj)
    self.LocationReference = obj.LocationReference
end

function TLocationReference:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationReference.group)
end

TLocationReference.from_obj = TLocationReference_from_obj

TLocationReference.proto_property = {'LocationReference'}

TLocationReference.default = {''}

TLocationReference.struct = {{name = 'LocationReference', is_array = false, struct = nil}}

function TLocationReference:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationReference', self.LocationReference, 'string', true, errs, need_convert)

    if self.LocationReference ~= nil then
        validate.Enum(prefix .. 'LocationReference', self.LocationReference, '',
            {'Top', 'Bottom', 'Front', 'Rear', 'Left', 'Right', 'Middle', ''}, errs, need_convert)
    end

    TLocationReference:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationReference.proto_property, errs, need_convert)
    return self
end

function TLocationReference:unpack(_)
    return self.LocationReference
end

PowerDistribution.LocationReference = TLocationReference

---@class PowerDistribution.LocationServiceLabel
---@field LocationServiceLabel string
local TLocationServiceLabel = {}
TLocationServiceLabel.__index = TLocationServiceLabel
TLocationServiceLabel.group = {}

local function TLocationServiceLabel_from_obj(obj)
    return setmetatable(obj, TLocationServiceLabel)
end

function TLocationServiceLabel.new(LocationServiceLabel)
    return TLocationServiceLabel_from_obj({LocationServiceLabel = LocationServiceLabel})
end
---@param obj PowerDistribution.LocationServiceLabel
function TLocationServiceLabel:init_from_obj(obj)
    self.LocationServiceLabel = obj.LocationServiceLabel
end

function TLocationServiceLabel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationServiceLabel.group)
end

TLocationServiceLabel.from_obj = TLocationServiceLabel_from_obj

TLocationServiceLabel.proto_property = {'LocationServiceLabel'}

TLocationServiceLabel.default = {''}

TLocationServiceLabel.struct = {{name = 'LocationServiceLabel', is_array = false, struct = nil}}

function TLocationServiceLabel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationServiceLabel', self.LocationServiceLabel, 'string', true, errs, need_convert)

    TLocationServiceLabel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationServiceLabel.proto_property, errs, need_convert)
    return self
end

function TLocationServiceLabel:unpack(_)
    return self.LocationServiceLabel
end

PowerDistribution.LocationServiceLabel = TLocationServiceLabel

---@class PowerDistribution.PowerCapacityVA
---@field PowerCapacityVA integer
local TPowerCapacityVA = {}
TPowerCapacityVA.__index = TPowerCapacityVA
TPowerCapacityVA.group = {}

local function TPowerCapacityVA_from_obj(obj)
    return setmetatable(obj, TPowerCapacityVA)
end

function TPowerCapacityVA.new(PowerCapacityVA)
    return TPowerCapacityVA_from_obj({PowerCapacityVA = PowerCapacityVA or 4294967295})
end
---@param obj PowerDistribution.PowerCapacityVA
function TPowerCapacityVA:init_from_obj(obj)
    self.PowerCapacityVA = obj.PowerCapacityVA or 4294967295
end

function TPowerCapacityVA:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCapacityVA.group)
end

TPowerCapacityVA.from_obj = TPowerCapacityVA_from_obj

TPowerCapacityVA.proto_property = {'PowerCapacityVA'}

TPowerCapacityVA.default = {0}

TPowerCapacityVA.struct = {{name = 'PowerCapacityVA', is_array = false, struct = nil}}

function TPowerCapacityVA:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCapacityVA', self.PowerCapacityVA, 'uint32', true, errs, need_convert)

    TPowerCapacityVA:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCapacityVA.proto_property, errs, need_convert)
    return self
end

function TPowerCapacityVA:unpack(_)
    return self.PowerCapacityVA
end

PowerDistribution.PowerCapacityVA = TPowerCapacityVA

---@class PowerDistribution.ProductionDate
---@field ProductionDate string
local TProductionDate = {}
TProductionDate.__index = TProductionDate
TProductionDate.group = {}

local function TProductionDate_from_obj(obj)
    return setmetatable(obj, TProductionDate)
end

function TProductionDate.new(ProductionDate)
    return TProductionDate_from_obj({ProductionDate = ProductionDate})
end
---@param obj PowerDistribution.ProductionDate
function TProductionDate:init_from_obj(obj)
    self.ProductionDate = obj.ProductionDate
end

function TProductionDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductionDate.group)
end

TProductionDate.from_obj = TProductionDate_from_obj

TProductionDate.proto_property = {'ProductionDate'}

TProductionDate.default = {''}

TProductionDate.struct = {{name = 'ProductionDate', is_array = false, struct = nil}}

function TProductionDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductionDate', self.ProductionDate, 'string', true, errs, need_convert)

    if self.ProductionDate ~= nil then
        validate.lens(prefix .. 'ProductionDate', self.ProductionDate, 1, 20, errs, need_convert)
    end

    TProductionDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductionDate.proto_property, errs, need_convert)
    return self
end

function TProductionDate:unpack(_)
    return self.ProductionDate
end

PowerDistribution.ProductionDate = TProductionDate

---@class PowerDistribution.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj PowerDistribution.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

PowerDistribution.SerialNumber = TSerialNumber

---@class PowerDistribution.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj PowerDistribution.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

PowerDistribution.PartNumber = TPartNumber

---@class PowerDistribution.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj PowerDistribution.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

PowerDistribution.Model = TModel

---@class PowerDistribution.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj PowerDistribution.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

PowerDistribution.Manufacturer = TManufacturer

---@class PowerDistribution.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj PowerDistribution.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

PowerDistribution.FirmwareVersion = TFirmwareVersion

---@class PowerDistribution.AssetTag
---@field AssetTag string
local TAssetTag = {}
TAssetTag.__index = TAssetTag
TAssetTag.group = {}

local function TAssetTag_from_obj(obj)
    return setmetatable(obj, TAssetTag)
end

function TAssetTag.new(AssetTag)
    return TAssetTag_from_obj({AssetTag = AssetTag})
end
---@param obj PowerDistribution.AssetTag
function TAssetTag:init_from_obj(obj)
    self.AssetTag = obj.AssetTag
end

function TAssetTag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssetTag.group)
end

TAssetTag.from_obj = TAssetTag_from_obj

TAssetTag.proto_property = {'AssetTag'}

TAssetTag.default = {''}

TAssetTag.struct = {{name = 'AssetTag', is_array = false, struct = nil}}

function TAssetTag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssetTag', self.AssetTag, 'string', false, errs, need_convert)

    if self.AssetTag ~= nil then
        validate.lens(prefix .. 'AssetTag', self.AssetTag, 1, 20, errs, need_convert)
    end

    TAssetTag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssetTag.proto_property, errs, need_convert)
    return self
end

function TAssetTag:unpack(_)
    return self.AssetTag
end

PowerDistribution.AssetTag = TAssetTag

---@class PowerDistribution.EquipmentType
---@field EquipmentType string
local TEquipmentType = {}
TEquipmentType.__index = TEquipmentType
TEquipmentType.group = {}

local function TEquipmentType_from_obj(obj)
    return setmetatable(obj, TEquipmentType)
end

function TEquipmentType.new(EquipmentType)
    return TEquipmentType_from_obj({EquipmentType = EquipmentType})
end
---@param obj PowerDistribution.EquipmentType
function TEquipmentType:init_from_obj(obj)
    self.EquipmentType = obj.EquipmentType
end

function TEquipmentType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEquipmentType.group)
end

TEquipmentType.from_obj = TEquipmentType_from_obj

TEquipmentType.proto_property = {'EquipmentType'}

TEquipmentType.default = {''}

TEquipmentType.struct = {{name = 'EquipmentType', is_array = false, struct = nil}}

function TEquipmentType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EquipmentType', self.EquipmentType, 'string', true, errs, need_convert)

    if self.EquipmentType ~= nil then
        validate.Enum(prefix .. 'EquipmentType', self.EquipmentType, '', {
            'RackPDU', 'FloorPDU', 'Switchgear', 'PowerShelf', 'AutomaticTransferSwitch', 'ManualTransferSwitch', ''
        }, errs, need_convert)
    end

    TEquipmentType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEquipmentType.proto_property, errs, need_convert)
    return self
end

function TEquipmentType:unpack(_)
    return self.EquipmentType
end

PowerDistribution.EquipmentType = TEquipmentType

---@class PowerDistribution.UserLabel
---@field UserLabel string
local TUserLabel = {}
TUserLabel.__index = TUserLabel
TUserLabel.group = {}

local function TUserLabel_from_obj(obj)
    return setmetatable(obj, TUserLabel)
end

function TUserLabel.new(UserLabel)
    return TUserLabel_from_obj({UserLabel = UserLabel})
end
---@param obj PowerDistribution.UserLabel
function TUserLabel:init_from_obj(obj)
    self.UserLabel = obj.UserLabel
end

function TUserLabel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUserLabel.group)
end

TUserLabel.from_obj = TUserLabel_from_obj

TUserLabel.proto_property = {'UserLabel'}

TUserLabel.default = {''}

TUserLabel.struct = {{name = 'UserLabel', is_array = false, struct = nil}}

function TUserLabel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UserLabel', self.UserLabel, 'string', false, errs, need_convert)

    if self.UserLabel ~= nil then
        validate.lens(prefix .. 'UserLabel', self.UserLabel, 1, 20, errs, need_convert)
    end

    TUserLabel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUserLabel.proto_property, errs, need_convert)
    return self
end

function TUserLabel:unpack(_)
    return self.UserLabel
end

PowerDistribution.UserLabel = TUserLabel

---@class PowerDistribution.UUID
---@field UUID string
local TUUID = {}
TUUID.__index = TUUID
TUUID.group = {}

local function TUUID_from_obj(obj)
    return setmetatable(obj, TUUID)
end

function TUUID.new(UUID)
    return TUUID_from_obj({UUID = UUID})
end
---@param obj PowerDistribution.UUID
function TUUID:init_from_obj(obj)
    self.UUID = obj.UUID
end

function TUUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUUID.group)
end

TUUID.from_obj = TUUID_from_obj

TUUID.proto_property = {'UUID'}

TUUID.default = {''}

TUUID.struct = {{name = 'UUID', is_array = false, struct = nil}}

function TUUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UUID', self.UUID, 'string', true, errs, need_convert)

    if self.UUID ~= nil then
        validate.regex(prefix .. 'UUID', self.UUID,
            [=[^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$]=], errs, need_convert)
    end

    TUUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUUID.proto_property, errs, need_convert)
    return self
end

function TUUID:unpack(_)
    return self.UUID
end

PowerDistribution.UUID = TUUID

---@class PowerDistribution.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj PowerDistribution.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

PowerDistribution.Version = TVersion

---@class PowerDistribution.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health or 0})
end
---@param obj PowerDistribution.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health or 0
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

PowerDistribution.Health = THealth

PowerDistribution.interface = mdb.register_interface('bmc.kepler.PowerEquipment.PowerDistribution', {
    Health = {'y', {'EMIT_CHANGE'}, true, 0},
    Version = {'s', {}, true, nil},
    UUID = {'s', {}, true, nil},
    UserLabel = {'s', {}, false, nil},
    EquipmentType = {'s', {}, true, nil},
    AssetTag = {'s', {}, false, nil},
    FirmwareVersion = {'s', {}, true, nil},
    Manufacturer = {'s', {}, true, nil},
    Model = {'s', {}, true, nil},
    PartNumber = {'s', {}, true, nil},
    SerialNumber = {'s', {}, true, nil},
    ProductionDate = {'s', {}, true, nil},
    PowerCapacityVA = {'u', {}, true, 4294967295},
    LocationServiceLabel = {'s', {}, true, nil},
    LocationReference = {'s', {}, true, nil},
    LocationOrientation = {'s', {}, true, nil},
    LocationType = {'s', {}, true, nil},
    LocationOrdinalValue = {'y', {}, true, 255}
}, {}, {})

return PowerDistribution
