-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OnePower = {}

---@class OnePower.InputVoltageType
---@field InputVoltageType integer
local TInputVoltageType = {}
TInputVoltageType.__index = TInputVoltageType
TInputVoltageType.group = {}

local function TInputVoltageType_from_obj(obj)
    return setmetatable(obj, TInputVoltageType)
end

function TInputVoltageType.new(InputVoltageType)
    return TInputVoltageType_from_obj({InputVoltageType = InputVoltageType})
end
---@param obj OnePower.InputVoltageType
function TInputVoltageType:init_from_obj(obj)
    self.InputVoltageType = obj.InputVoltageType
end

function TInputVoltageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltageType.group)
end

TInputVoltageType.from_obj = TInputVoltageType_from_obj

TInputVoltageType.proto_property = {'InputVoltageType'}

TInputVoltageType.default = {0}

TInputVoltageType.struct = {{name = 'InputVoltageType', is_array = false, struct = nil}}

function TInputVoltageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltageType', self.InputVoltageType, 'uint8', true, errs, need_convert)

    TInputVoltageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltageType.proto_property, errs, need_convert)
    return self
end

function TInputVoltageType:unpack(_)
    return self.InputVoltageType
end

OnePower.InputVoltageType = TInputVoltageType

---@class OnePower.RedundancyGroupId
---@field RedundancyGroupId integer
local TRedundancyGroupId = {}
TRedundancyGroupId.__index = TRedundancyGroupId
TRedundancyGroupId.group = {}

local function TRedundancyGroupId_from_obj(obj)
    return setmetatable(obj, TRedundancyGroupId)
end

function TRedundancyGroupId.new(RedundancyGroupId)
    return TRedundancyGroupId_from_obj({RedundancyGroupId = RedundancyGroupId})
end
---@param obj OnePower.RedundancyGroupId
function TRedundancyGroupId:init_from_obj(obj)
    self.RedundancyGroupId = obj.RedundancyGroupId
end

function TRedundancyGroupId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRedundancyGroupId.group)
end

TRedundancyGroupId.from_obj = TRedundancyGroupId_from_obj

TRedundancyGroupId.proto_property = {'RedundancyGroupId'}

TRedundancyGroupId.default = {0}

TRedundancyGroupId.struct = {{name = 'RedundancyGroupId', is_array = false, struct = nil}}

function TRedundancyGroupId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RedundancyGroupId', self.RedundancyGroupId, 'uint8', true, errs, need_convert)

    TRedundancyGroupId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRedundancyGroupId.proto_property, errs, need_convert)
    return self
end

function TRedundancyGroupId:unpack(_)
    return self.RedundancyGroupId
end

OnePower.RedundancyGroupId = TRedundancyGroupId

---@class OnePower.DeepSleepStandbyPowerWatts
---@field DeepSleepStandbyPowerWatts integer
local TDeepSleepStandbyPowerWatts = {}
TDeepSleepStandbyPowerWatts.__index = TDeepSleepStandbyPowerWatts
TDeepSleepStandbyPowerWatts.group = {}

local function TDeepSleepStandbyPowerWatts_from_obj(obj)
    return setmetatable(obj, TDeepSleepStandbyPowerWatts)
end

function TDeepSleepStandbyPowerWatts.new(DeepSleepStandbyPowerWatts)
    return TDeepSleepStandbyPowerWatts_from_obj({DeepSleepStandbyPowerWatts = DeepSleepStandbyPowerWatts or 65535})
end
---@param obj OnePower.DeepSleepStandbyPowerWatts
function TDeepSleepStandbyPowerWatts:init_from_obj(obj)
    self.DeepSleepStandbyPowerWatts = obj.DeepSleepStandbyPowerWatts or 65535
end

function TDeepSleepStandbyPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeepSleepStandbyPowerWatts.group)
end

TDeepSleepStandbyPowerWatts.from_obj = TDeepSleepStandbyPowerWatts_from_obj

TDeepSleepStandbyPowerWatts.proto_property = {'DeepSleepStandbyPowerWatts'}

TDeepSleepStandbyPowerWatts.default = {0}

TDeepSleepStandbyPowerWatts.struct = {{name = 'DeepSleepStandbyPowerWatts', is_array = false, struct = nil}}

function TDeepSleepStandbyPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeepSleepStandbyPowerWatts', self.DeepSleepStandbyPowerWatts, 'uint16', true, errs,
        need_convert)

    TDeepSleepStandbyPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeepSleepStandbyPowerWatts.proto_property, errs, need_convert)
    return self
end

function TDeepSleepStandbyPowerWatts:unpack(_)
    return self.DeepSleepStandbyPowerWatts
end

OnePower.DeepSleepStandbyPowerWatts = TDeepSleepStandbyPowerWatts

---@class OnePower.WorkMode
---@field WorkMode string
local TWorkMode = {}
TWorkMode.__index = TWorkMode
TWorkMode.group = {}

local function TWorkMode_from_obj(obj)
    return setmetatable(obj, TWorkMode)
end

function TWorkMode.new(WorkMode)
    return TWorkMode_from_obj({WorkMode = WorkMode})
end
---@param obj OnePower.WorkMode
function TWorkMode:init_from_obj(obj)
    self.WorkMode = obj.WorkMode
end

function TWorkMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkMode.group)
end

TWorkMode.from_obj = TWorkMode_from_obj

TWorkMode.proto_property = {'WorkMode'}

TWorkMode.default = {''}

TWorkMode.struct = {{name = 'WorkMode', is_array = false, struct = nil}}

function TWorkMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkMode', self.WorkMode, 'string', true, errs, need_convert)

    TWorkMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkMode.proto_property, errs, need_convert)
    return self
end

function TWorkMode:unpack(_)
    return self.WorkMode
end

OnePower.WorkMode = TWorkMode

---@class OnePower.RelaySwitchedCount
---@field RelaySwitchedCount integer
local TRelaySwitchedCount = {}
TRelaySwitchedCount.__index = TRelaySwitchedCount
TRelaySwitchedCount.group = {}

local function TRelaySwitchedCount_from_obj(obj)
    return setmetatable(obj, TRelaySwitchedCount)
end

function TRelaySwitchedCount.new(RelaySwitchedCount)
    return TRelaySwitchedCount_from_obj({RelaySwitchedCount = RelaySwitchedCount})
end
---@param obj OnePower.RelaySwitchedCount
function TRelaySwitchedCount:init_from_obj(obj)
    self.RelaySwitchedCount = obj.RelaySwitchedCount
end

function TRelaySwitchedCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelaySwitchedCount.group)
end

TRelaySwitchedCount.from_obj = TRelaySwitchedCount_from_obj

TRelaySwitchedCount.proto_property = {'RelaySwitchedCount'}

TRelaySwitchedCount.default = {0}

TRelaySwitchedCount.struct = {{name = 'RelaySwitchedCount', is_array = false, struct = nil}}

function TRelaySwitchedCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RelaySwitchedCount', self.RelaySwitchedCount, 'uint16', true, errs, need_convert)

    TRelaySwitchedCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelaySwitchedCount.proto_property, errs, need_convert)
    return self
end

function TRelaySwitchedCount:unpack(_)
    return self.RelaySwitchedCount
end

OnePower.RelaySwitchedCount = TRelaySwitchedCount

---@class OnePower.LineInputVoltageType
---@field LineInputVoltageType string
local TLineInputVoltageType = {}
TLineInputVoltageType.__index = TLineInputVoltageType
TLineInputVoltageType.group = {}

local function TLineInputVoltageType_from_obj(obj)
    return setmetatable(obj, TLineInputVoltageType)
end

function TLineInputVoltageType.new(LineInputVoltageType)
    return TLineInputVoltageType_from_obj({LineInputVoltageType = LineInputVoltageType or [=[Unknown]=]})
end
---@param obj OnePower.LineInputVoltageType
function TLineInputVoltageType:init_from_obj(obj)
    self.LineInputVoltageType = obj.LineInputVoltageType or [=[Unknown]=]
end

function TLineInputVoltageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLineInputVoltageType.group)
end

TLineInputVoltageType.from_obj = TLineInputVoltageType_from_obj

TLineInputVoltageType.proto_property = {'LineInputVoltageType'}

TLineInputVoltageType.default = {''}

TLineInputVoltageType.struct = {{name = 'LineInputVoltageType', is_array = false, struct = nil}}

function TLineInputVoltageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LineInputVoltageType', self.LineInputVoltageType, 'string', true, errs, need_convert)

    if self.LineInputVoltageType ~= nil then
        validate.Enum(prefix .. 'LineInputVoltageType', self.LineInputVoltageType, '', {
            'AC120V', 'AC240V', 'AC1277V', 'ACandDCWideRange', 'ACWideRange', 'DC240V', 'DC380V', 'DCNeg48V', 'HVDC',
            'Unknown'
        }, errs, need_convert)
    end

    TLineInputVoltageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLineInputVoltageType.proto_property, errs, need_convert)
    return self
end

function TLineInputVoltageType:unpack(_)
    return self.LineInputVoltageType
end

OnePower.LineInputVoltageType = TLineInputVoltageType

---@class OnePower.TotalRunningHours
---@field TotalRunningHours integer
local TTotalRunningHours = {}
TTotalRunningHours.__index = TTotalRunningHours
TTotalRunningHours.group = {}

local function TTotalRunningHours_from_obj(obj)
    return setmetatable(obj, TTotalRunningHours)
end

function TTotalRunningHours.new(TotalRunningHours)
    return TTotalRunningHours_from_obj({TotalRunningHours = TotalRunningHours})
end
---@param obj OnePower.TotalRunningHours
function TTotalRunningHours:init_from_obj(obj)
    self.TotalRunningHours = obj.TotalRunningHours
end

function TTotalRunningHours:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalRunningHours.group)
end

TTotalRunningHours.from_obj = TTotalRunningHours_from_obj

TTotalRunningHours.proto_property = {'TotalRunningHours'}

TTotalRunningHours.default = {0}

TTotalRunningHours.struct = {{name = 'TotalRunningHours', is_array = false, struct = nil}}

function TTotalRunningHours:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalRunningHours', self.TotalRunningHours, 'uint32', true, errs, need_convert)

    TTotalRunningHours:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalRunningHours.proto_property, errs, need_convert)
    return self
end

function TTotalRunningHours:unpack(_)
    return self.TotalRunningHours
end

OnePower.TotalRunningHours = TTotalRunningHours

---@class OnePower.IsPartOfSysPower
---@field IsPartOfSysPower boolean
local TIsPartOfSysPower = {}
TIsPartOfSysPower.__index = TIsPartOfSysPower
TIsPartOfSysPower.group = {}

local function TIsPartOfSysPower_from_obj(obj)
    return setmetatable(obj, TIsPartOfSysPower)
end

function TIsPartOfSysPower.new(IsPartOfSysPower)
    return TIsPartOfSysPower_from_obj({IsPartOfSysPower = IsPartOfSysPower == nil and true or IsPartOfSysPower})
end
---@param obj OnePower.IsPartOfSysPower
function TIsPartOfSysPower:init_from_obj(obj)
    self.IsPartOfSysPower = obj.IsPartOfSysPower == nil and true or obj.IsPartOfSysPower
end

function TIsPartOfSysPower:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsPartOfSysPower.group)
end

TIsPartOfSysPower.from_obj = TIsPartOfSysPower_from_obj

TIsPartOfSysPower.proto_property = {'IsPartOfSysPower'}

TIsPartOfSysPower.default = {false}

TIsPartOfSysPower.struct = {{name = 'IsPartOfSysPower', is_array = false, struct = nil}}

function TIsPartOfSysPower:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsPartOfSysPower', self.IsPartOfSysPower, 'bool', true, errs, need_convert)

    TIsPartOfSysPower:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsPartOfSysPower.proto_property, errs, need_convert)
    return self
end

function TIsPartOfSysPower:unpack(_)
    return self.IsPartOfSysPower
end

OnePower.IsPartOfSysPower = TIsPartOfSysPower

---@class OnePower.SourceType
---@field SourceType integer
local TSourceType = {}
TSourceType.__index = TSourceType
TSourceType.group = {}

local function TSourceType_from_obj(obj)
    return setmetatable(obj, TSourceType)
end

function TSourceType.new(SourceType)
    return TSourceType_from_obj({SourceType = SourceType or 1})
end
---@param obj OnePower.SourceType
function TSourceType:init_from_obj(obj)
    self.SourceType = obj.SourceType or 1
end

function TSourceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSourceType.group)
end

TSourceType.from_obj = TSourceType_from_obj

TSourceType.proto_property = {'SourceType'}

TSourceType.default = {0}

TSourceType.struct = {{name = 'SourceType', is_array = false, struct = nil}}

function TSourceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SourceType', self.SourceType, 'uint8', true, errs, need_convert)

    TSourceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSourceType.proto_property, errs, need_convert)
    return self
end

function TSourceType:unpack(_)
    return self.SourceType
end

OnePower.SourceType = TSourceType

---@class OnePower.DMTFPowerSupplyType
---@field DMTFPowerSupplyType integer
local TDMTFPowerSupplyType = {}
TDMTFPowerSupplyType.__index = TDMTFPowerSupplyType
TDMTFPowerSupplyType.group = {}

local function TDMTFPowerSupplyType_from_obj(obj)
    return setmetatable(obj, TDMTFPowerSupplyType)
end

function TDMTFPowerSupplyType.new(DMTFPowerSupplyType)
    return TDMTFPowerSupplyType_from_obj({DMTFPowerSupplyType = DMTFPowerSupplyType or 4})
end
---@param obj OnePower.DMTFPowerSupplyType
function TDMTFPowerSupplyType:init_from_obj(obj)
    self.DMTFPowerSupplyType = obj.DMTFPowerSupplyType or 4
end

function TDMTFPowerSupplyType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDMTFPowerSupplyType.group)
end

TDMTFPowerSupplyType.from_obj = TDMTFPowerSupplyType_from_obj

TDMTFPowerSupplyType.proto_property = {'DMTFPowerSupplyType'}

TDMTFPowerSupplyType.default = {0}

TDMTFPowerSupplyType.struct = {{name = 'DMTFPowerSupplyType', is_array = false, struct = nil}}

function TDMTFPowerSupplyType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DMTFPowerSupplyType', self.DMTFPowerSupplyType, 'uint8', true, errs, need_convert)

    if self.DMTFPowerSupplyType ~= nil then
        validate.Enum(prefix .. 'DMTFPowerSupplyType', self.DMTFPowerSupplyType, '', {1, 2, 3, 4, 5, 6, 7, 8}, errs,
            need_convert)
    end

    TDMTFPowerSupplyType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDMTFPowerSupplyType.proto_property, errs, need_convert)
    return self
end

function TDMTFPowerSupplyType:unpack(_)
    return self.DMTFPowerSupplyType
end

OnePower.DMTFPowerSupplyType = TDMTFPowerSupplyType

---@class OnePower.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj OnePower.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

OnePower.Position = TPosition

---@class OnePower.ProductionDate
---@field ProductionDate string
local TProductionDate = {}
TProductionDate.__index = TProductionDate
TProductionDate.group = {}

local function TProductionDate_from_obj(obj)
    return setmetatable(obj, TProductionDate)
end

function TProductionDate.new(ProductionDate)
    return TProductionDate_from_obj({ProductionDate = ProductionDate})
end
---@param obj OnePower.ProductionDate
function TProductionDate:init_from_obj(obj)
    self.ProductionDate = obj.ProductionDate
end

function TProductionDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductionDate.group)
end

TProductionDate.from_obj = TProductionDate_from_obj

TProductionDate.proto_property = {'ProductionDate'}

TProductionDate.default = {''}

TProductionDate.struct = {{name = 'ProductionDate', is_array = false, struct = nil}}

function TProductionDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductionDate', self.ProductionDate, 'string', true, errs, need_convert)

    TProductionDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductionDate.proto_property, errs, need_convert)
    return self
end

function TProductionDate:unpack(_)
    return self.ProductionDate
end

OnePower.ProductionDate = TProductionDate

---@class OnePower.DeviceLocator
---@field DeviceLocator string
local TDeviceLocator = {}
TDeviceLocator.__index = TDeviceLocator
TDeviceLocator.group = {}

local function TDeviceLocator_from_obj(obj)
    return setmetatable(obj, TDeviceLocator)
end

function TDeviceLocator.new(DeviceLocator)
    return TDeviceLocator_from_obj({DeviceLocator = DeviceLocator})
end
---@param obj OnePower.DeviceLocator
function TDeviceLocator:init_from_obj(obj)
    self.DeviceLocator = obj.DeviceLocator
end

function TDeviceLocator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceLocator.group)
end

TDeviceLocator.from_obj = TDeviceLocator_from_obj

TDeviceLocator.proto_property = {'DeviceLocator'}

TDeviceLocator.default = {''}

TDeviceLocator.struct = {{name = 'DeviceLocator', is_array = false, struct = nil}}

function TDeviceLocator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceLocator', self.DeviceLocator, 'string', true, errs, need_convert)

    TDeviceLocator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceLocator.proto_property, errs, need_convert)
    return self
end

function TDeviceLocator:unpack(_)
    return self.DeviceLocator
end

OnePower.DeviceLocator = TDeviceLocator

---@class OnePower.Protocol
---@field Protocol string
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol})
end
---@param obj OnePower.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {''}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'string', true, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

OnePower.Protocol = TProtocol

---@class OnePower.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj OnePower.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

OnePower.FirmwareVersion = TFirmwareVersion

---@class OnePower.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj OnePower.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

OnePower.PartNumber = TPartNumber

---@class OnePower.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj OnePower.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

OnePower.SerialNumber = TSerialNumber

---@class OnePower.PowerSupplyChannel
---@field PowerSupplyChannel integer
local TPowerSupplyChannel = {}
TPowerSupplyChannel.__index = TPowerSupplyChannel
TPowerSupplyChannel.group = {}

local function TPowerSupplyChannel_from_obj(obj)
    return setmetatable(obj, TPowerSupplyChannel)
end

function TPowerSupplyChannel.new(PowerSupplyChannel)
    return TPowerSupplyChannel_from_obj({PowerSupplyChannel = PowerSupplyChannel or 0})
end
---@param obj OnePower.PowerSupplyChannel
function TPowerSupplyChannel:init_from_obj(obj)
    self.PowerSupplyChannel = obj.PowerSupplyChannel or 0
end

function TPowerSupplyChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerSupplyChannel.group)
end

TPowerSupplyChannel.from_obj = TPowerSupplyChannel_from_obj

TPowerSupplyChannel.proto_property = {'PowerSupplyChannel'}

TPowerSupplyChannel.default = {0}

TPowerSupplyChannel.struct = {{name = 'PowerSupplyChannel', is_array = false, struct = nil}}

function TPowerSupplyChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerSupplyChannel', self.PowerSupplyChannel, 'uint8', true, errs, need_convert)

    TPowerSupplyChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerSupplyChannel.proto_property, errs, need_convert)
    return self
end

function TPowerSupplyChannel:unpack(_)
    return self.PowerSupplyChannel
end

OnePower.PowerSupplyChannel = TPowerSupplyChannel

---@class OnePower.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence or 0})
end
---@param obj OnePower.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence or 0
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

OnePower.Presence = TPresence

---@class OnePower.PowerSupplyType
---@field PowerSupplyType integer
local TPowerSupplyType = {}
TPowerSupplyType.__index = TPowerSupplyType
TPowerSupplyType.group = {}

local function TPowerSupplyType_from_obj(obj)
    return setmetatable(obj, TPowerSupplyType)
end

function TPowerSupplyType.new(PowerSupplyType)
    return TPowerSupplyType_from_obj({PowerSupplyType = PowerSupplyType or 0})
end
---@param obj OnePower.PowerSupplyType
function TPowerSupplyType:init_from_obj(obj)
    self.PowerSupplyType = obj.PowerSupplyType or 0
end

function TPowerSupplyType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerSupplyType.group)
end

TPowerSupplyType.from_obj = TPowerSupplyType_from_obj

TPowerSupplyType.proto_property = {'PowerSupplyType'}

TPowerSupplyType.default = {0}

TPowerSupplyType.struct = {{name = 'PowerSupplyType', is_array = false, struct = nil}}

function TPowerSupplyType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerSupplyType', self.PowerSupplyType, 'uint32', true, errs, need_convert)

    TPowerSupplyType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerSupplyType.proto_property, errs, need_convert)
    return self
end

function TPowerSupplyType:unpack(_)
    return self.PowerSupplyType
end

OnePower.PowerSupplyType = TPowerSupplyType

---@class OnePower.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj OnePower.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

OnePower.Model = TModel

---@class OnePower.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj OnePower.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

OnePower.Manufacturer = TManufacturer

---@class OnePower.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber or 0})
end
---@param obj OnePower.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber or 0
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SlotNumber', self.SlotNumber, 'uint32', true, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

OnePower.SlotNumber = TSlotNumber

---@class OnePower.SetPowerSupplyCircuitRsp
local TSetPowerSupplyCircuitRsp = {}
TSetPowerSupplyCircuitRsp.__index = TSetPowerSupplyCircuitRsp
TSetPowerSupplyCircuitRsp.group = {}

local function TSetPowerSupplyCircuitRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerSupplyCircuitRsp)
end

function TSetPowerSupplyCircuitRsp.new()
    return TSetPowerSupplyCircuitRsp_from_obj({})
end
---@param obj OnePower.SetPowerSupplyCircuitRsp
function TSetPowerSupplyCircuitRsp:init_from_obj(obj)

end

function TSetPowerSupplyCircuitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerSupplyCircuitRsp.group)
end

TSetPowerSupplyCircuitRsp.from_obj = TSetPowerSupplyCircuitRsp_from_obj

TSetPowerSupplyCircuitRsp.proto_property = {}

TSetPowerSupplyCircuitRsp.default = {}

TSetPowerSupplyCircuitRsp.struct = {}

function TSetPowerSupplyCircuitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPowerSupplyCircuitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerSupplyCircuitRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerSupplyCircuitRsp:unpack(_)
end

OnePower.SetPowerSupplyCircuitRsp = TSetPowerSupplyCircuitRsp

---@class OnePower.SetPowerSupplyCircuitReq
---@field PowerSupplyCircuit integer
local TSetPowerSupplyCircuitReq = {}
TSetPowerSupplyCircuitReq.__index = TSetPowerSupplyCircuitReq
TSetPowerSupplyCircuitReq.group = {}

local function TSetPowerSupplyCircuitReq_from_obj(obj)
    return setmetatable(obj, TSetPowerSupplyCircuitReq)
end

function TSetPowerSupplyCircuitReq.new(PowerSupplyCircuit)
    return TSetPowerSupplyCircuitReq_from_obj({PowerSupplyCircuit = PowerSupplyCircuit})
end
---@param obj OnePower.SetPowerSupplyCircuitReq
function TSetPowerSupplyCircuitReq:init_from_obj(obj)
    self.PowerSupplyCircuit = obj.PowerSupplyCircuit
end

function TSetPowerSupplyCircuitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerSupplyCircuitReq.group)
end

TSetPowerSupplyCircuitReq.from_obj = TSetPowerSupplyCircuitReq_from_obj

TSetPowerSupplyCircuitReq.proto_property = {'PowerSupplyCircuit'}

TSetPowerSupplyCircuitReq.default = {0}

TSetPowerSupplyCircuitReq.struct = {{name = 'PowerSupplyCircuit', is_array = false, struct = nil}}

function TSetPowerSupplyCircuitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, 'uint8', false, errs, need_convert)

    if self.PowerSupplyCircuit ~= nil then
        validate.Enum(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, '', {0, 1}, errs, need_convert)
    end

    TSetPowerSupplyCircuitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerSupplyCircuitReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerSupplyCircuitReq:unpack(_)
    return self.PowerSupplyCircuit
end

OnePower.SetPowerSupplyCircuitReq = TSetPowerSupplyCircuitReq

---@class OnePower.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj OnePower.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

OnePower.ResetRsp = TResetRsp

---@class OnePower.ResetReq
---@field ResetType string
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new(ResetType)
    return TResetReq_from_obj({ResetType = ResetType})
end
---@param obj OnePower.ResetReq
function TResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {'ResetType'}

TResetReq.default = {''}

TResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    if self.ResetType ~= nil then
        validate.Enum(prefix .. 'ResetType', self.ResetType, '',
            {'ForceRestart', 'ForceOff', 'ForceOn', 'On', 'PowerCycle'}, errs, need_convert)
    end

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
    return self.ResetType
end

OnePower.ResetReq = TResetReq

---@class OnePower.SetPowerWorkModeRsp
---@field CmdResult integer
local TSetPowerWorkModeRsp = {}
TSetPowerWorkModeRsp.__index = TSetPowerWorkModeRsp
TSetPowerWorkModeRsp.group = {}

local function TSetPowerWorkModeRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeRsp)
end

function TSetPowerWorkModeRsp.new(CmdResult)
    return TSetPowerWorkModeRsp_from_obj({CmdResult = CmdResult})
end
---@param obj OnePower.SetPowerWorkModeRsp
function TSetPowerWorkModeRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerWorkModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeRsp.group)
end

TSetPowerWorkModeRsp.from_obj = TSetPowerWorkModeRsp_from_obj

TSetPowerWorkModeRsp.proto_property = {'CmdResult'}

TSetPowerWorkModeRsp.default = {0}

TSetPowerWorkModeRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerWorkModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint8', false, errs, need_convert)

    TSetPowerWorkModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerWorkModeRsp:unpack(_)
    return self.CmdResult
end

OnePower.SetPowerWorkModeRsp = TSetPowerWorkModeRsp

---@class OnePower.SetPowerWorkModeReq
---@field PowerWorkMode integer
local TSetPowerWorkModeReq = {}
TSetPowerWorkModeReq.__index = TSetPowerWorkModeReq
TSetPowerWorkModeReq.group = {}

local function TSetPowerWorkModeReq_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeReq)
end

function TSetPowerWorkModeReq.new(PowerWorkMode)
    return TSetPowerWorkModeReq_from_obj({PowerWorkMode = PowerWorkMode})
end
---@param obj OnePower.SetPowerWorkModeReq
function TSetPowerWorkModeReq:init_from_obj(obj)
    self.PowerWorkMode = obj.PowerWorkMode
end

function TSetPowerWorkModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeReq.group)
end

TSetPowerWorkModeReq.from_obj = TSetPowerWorkModeReq_from_obj

TSetPowerWorkModeReq.proto_property = {'PowerWorkMode'}

TSetPowerWorkModeReq.default = {0}

TSetPowerWorkModeReq.struct = {{name = 'PowerWorkMode', is_array = false, struct = nil}}

function TSetPowerWorkModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWorkMode', self.PowerWorkMode, 'uint8', false, errs, need_convert)

    TSetPowerWorkModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerWorkModeReq:unpack(_)
    return self.PowerWorkMode
end

OnePower.SetPowerWorkModeReq = TSetPowerWorkModeReq

OnePower.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower', {
    SlotNumber = {'u', nil, true, 0},
    Manufacturer = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    PowerSupplyType = {'u', nil, true, 0},
    Presence = {'y', nil, true, 0},
    PowerSupplyChannel = {'y', nil, true, 0},
    SerialNumber = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    Protocol = {'s', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    ProductionDate = {'s', nil, true, nil},
    Position = {'s', nil, true, nil},
    TotalRunningHours = {'u', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    LineInputVoltageType = {'s', {}, true, 'Unknown'},
    WorkMode = {'s', nil, true, nil},
    RedundancyGroupId = {'y', nil, true, nil},
    InputVoltageType = {'y', nil, true, nil},
    DMTFPowerSupplyType = {'y', nil, true, nil},
    SourceType = {'y', nil, true, nil},
    IsPartOfSysPower = {'b', {}, true, true},
    RelaySwitchedCount = {'q', {}, true, nil},
    DeepSleepStandbyPowerWatts = {'q', {}, true, 65535}
}, {
    SetPowerWorkMode = {'a{ss}y', 'y', TSetPowerWorkModeReq, TSetPowerWorkModeRsp},
    Reset = {'a{ss}s', '', TResetReq, TResetRsp},
    SetPowerSupplyCircuit = {'a{ss}y', '', TSetPowerSupplyCircuitReq, TSetPowerSupplyCircuitRsp}
}, {})

return OnePower
