-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareInfo = {}

FirmwareInfo.interface = mdb.register_interface('bmc.kepler.UpdateService.FirmwareInfo', {
    Id = {'s', {['emitsChangedSignal'] = 'const'}, true, nil},
    Name = {'s', {['emitsChangedSignal'] = 'const'}, true, nil},
    Version = {'s', nil, false, nil},
    BuildNum = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ReleaseDate = {'s', nil, false, nil},
    LowestSupportedVersion = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    SoftwareId = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Updateable = {'b', nil, true, nil},
    Location = {'s', nil, true, nil},
    RollbackStatus = {'s', {['emitsChangedSignal'] = 'false'}, false, nil},
    ActiveMode = {'s', nil, false, nil},
    Parameters = {'a{ss}', nil, false, nil},
    State = {'s', nil, false, nil},
    Severity = {'s', nil, false, nil},
    MaxPackageSizeMiB = {'i', nil, true, nil},
    EstimatedDuration = {'u', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return FirmwareInfo
