-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Circuit = {}

---@class Circuit.InputVoltageStatus
---@field InputVoltageStatus integer
local TInputVoltageStatus = {}
TInputVoltageStatus.__index = TInputVoltageStatus
TInputVoltageStatus.group = {}

local function TInputVoltageStatus_from_obj(obj)
    return setmetatable(obj, TInputVoltageStatus)
end

function TInputVoltageStatus.new(InputVoltageStatus)
    return TInputVoltageStatus_from_obj({InputVoltageStatus = InputVoltageStatus})
end
---@param obj Circuit.InputVoltageStatus
function TInputVoltageStatus:init_from_obj(obj)
    self.InputVoltageStatus = obj.InputVoltageStatus
end

function TInputVoltageStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltageStatus.group)
end

TInputVoltageStatus.from_obj = TInputVoltageStatus_from_obj

TInputVoltageStatus.proto_property = {'InputVoltageStatus'}

TInputVoltageStatus.default = {0}

TInputVoltageStatus.struct = {{name = 'InputVoltageStatus', is_array = false, struct = nil}}

function TInputVoltageStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltageStatus', self.InputVoltageStatus, 'uint8', true, errs, need_convert)

    TInputVoltageStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltageStatus.proto_property, errs, need_convert)
    return self
end

function TInputVoltageStatus:unpack(_)
    return self.InputVoltageStatus
end

Circuit.InputVoltageStatus = TInputVoltageStatus

---@class Circuit.NominalVoltage
---@field NominalVoltage string
local TNominalVoltage = {}
TNominalVoltage.__index = TNominalVoltage
TNominalVoltage.group = {}

local function TNominalVoltage_from_obj(obj)
    return setmetatable(obj, TNominalVoltage)
end

function TNominalVoltage.new(NominalVoltage)
    return TNominalVoltage_from_obj({NominalVoltage = NominalVoltage})
end
---@param obj Circuit.NominalVoltage
function TNominalVoltage:init_from_obj(obj)
    self.NominalVoltage = obj.NominalVoltage
end

function TNominalVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNominalVoltage.group)
end

TNominalVoltage.from_obj = TNominalVoltage_from_obj

TNominalVoltage.proto_property = {'NominalVoltage'}

TNominalVoltage.default = {''}

TNominalVoltage.struct = {{name = 'NominalVoltage', is_array = false, struct = nil}}

function TNominalVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NominalVoltage', self.NominalVoltage, 'string', true, errs, need_convert)

    if self.NominalVoltage ~= nil then
        validate.Enum(prefix .. 'NominalVoltage', self.NominalVoltage, '', {
            'AC100To127V', 'AC100To240V', 'AC100To277V', 'AC120V', 'AC200To240V', 'AC200To277V', 'AC208V', 'AC230V',
            'AC240AndDC380V', 'AC240V', 'AC277AndDC380V', 'AC277V', 'AC400V', 'AC480V', 'DC12V', 'DC16V', 'DC1_8V',
            'DC240V', 'DC380V', 'DC3_3V', 'DC48V', 'DC5V', 'DC9V', 'DCNeg48V', ''
        }, errs, need_convert)
    end

    TNominalVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNominalVoltage.proto_property, errs, need_convert)
    return self
end

function TNominalVoltage:unpack(_)
    return self.NominalVoltage
end

Circuit.NominalVoltage = TNominalVoltage

---@class Circuit.PhaseWiringType
---@field PhaseWiringType string
local TPhaseWiringType = {}
TPhaseWiringType.__index = TPhaseWiringType
TPhaseWiringType.group = {}

local function TPhaseWiringType_from_obj(obj)
    return setmetatable(obj, TPhaseWiringType)
end

function TPhaseWiringType.new(PhaseWiringType)
    return TPhaseWiringType_from_obj({PhaseWiringType = PhaseWiringType})
end
---@param obj Circuit.PhaseWiringType
function TPhaseWiringType:init_from_obj(obj)
    self.PhaseWiringType = obj.PhaseWiringType
end

function TPhaseWiringType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhaseWiringType.group)
end

TPhaseWiringType.from_obj = TPhaseWiringType_from_obj

TPhaseWiringType.proto_property = {'PhaseWiringType'}

TPhaseWiringType.default = {''}

TPhaseWiringType.struct = {{name = 'PhaseWiringType', is_array = false, struct = nil}}

function TPhaseWiringType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhaseWiringType', self.PhaseWiringType, 'string', true, errs, need_convert)

    if self.PhaseWiringType ~= nil then
        validate.Enum(prefix .. 'PhaseWiringType', self.PhaseWiringType, '', {
            'OneOrTwoPhase3Wire', 'OnePhase3Wire', 'ThreePhase4Wire', 'ThreePhase5Wire', 'TwoPhase3Wire',
            'TwoPhase4Wire', ''
        }, errs, need_convert)
    end

    TPhaseWiringType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhaseWiringType.proto_property, errs, need_convert)
    return self
end

function TPhaseWiringType:unpack(_)
    return self.PhaseWiringType
end

Circuit.PhaseWiringType = TPhaseWiringType

---@class Circuit.CircuitType
---@field CircuitType string
local TCircuitType = {}
TCircuitType.__index = TCircuitType
TCircuitType.group = {}

local function TCircuitType_from_obj(obj)
    return setmetatable(obj, TCircuitType)
end

function TCircuitType.new(CircuitType)
    return TCircuitType_from_obj({CircuitType = CircuitType})
end
---@param obj Circuit.CircuitType
function TCircuitType:init_from_obj(obj)
    self.CircuitType = obj.CircuitType
end

function TCircuitType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCircuitType.group)
end

TCircuitType.from_obj = TCircuitType_from_obj

TCircuitType.proto_property = {'CircuitType'}

TCircuitType.default = {''}

TCircuitType.struct = {{name = 'CircuitType', is_array = false, struct = nil}}

function TCircuitType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CircuitType', self.CircuitType, 'string', true, errs, need_convert)

    if self.CircuitType ~= nil then
        validate.Enum(prefix .. 'CircuitType', self.CircuitType, '',
            {'Mains', 'Branch', 'Bus', 'Feeder', 'Subfeed', ''}, errs, need_convert)
    end

    TCircuitType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCircuitType.proto_property, errs, need_convert)
    return self
end

function TCircuitType:unpack(_)
    return self.CircuitType
end

Circuit.CircuitType = TCircuitType

---@class Circuit.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Circuit.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Circuit.Id = TId

Circuit.interface = mdb.register_interface('bmc.kepler.PowerEquipment.Circuit', {
    Id = {'y', {}, true, nil},
    CircuitType = {'s', {}, true, nil},
    PhaseWiringType = {'s', {}, true, nil},
    NominalVoltage = {'s', {'EMIT_CHANGE'}, true, nil},
    InputVoltageStatus = {'y', {'EMIT_CHANGE'}, true, nil}
}, {}, {})

return Circuit
