-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CapacitorMetrics = {}

---@class CapacitorMetrics.CapacityMicrofarads
---@field CapacityMicrofarads integer
local TCapacityMicrofarads = {}
TCapacityMicrofarads.__index = TCapacityMicrofarads
TCapacityMicrofarads.group = {}

local function TCapacityMicrofarads_from_obj(obj)
    return setmetatable(obj, TCapacityMicrofarads)
end

function TCapacityMicrofarads.new(CapacityMicrofarads)
    return TCapacityMicrofarads_from_obj({CapacityMicrofarads = CapacityMicrofarads})
end
---@param obj CapacitorMetrics.CapacityMicrofarads
function TCapacityMicrofarads:init_from_obj(obj)
    self.CapacityMicrofarads = obj.CapacityMicrofarads
end

function TCapacityMicrofarads:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapacityMicrofarads.group)
end

TCapacityMicrofarads.from_obj = TCapacityMicrofarads_from_obj

TCapacityMicrofarads.proto_property = {'CapacityMicrofarads'}

TCapacityMicrofarads.default = {0}

TCapacityMicrofarads.struct = {{name = 'CapacityMicrofarads', is_array = false, struct = nil}}

function TCapacityMicrofarads:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacityMicrofarads', self.CapacityMicrofarads, 'uint32', true, errs, need_convert)

    TCapacityMicrofarads:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapacityMicrofarads.proto_property, errs, need_convert)
    return self
end

function TCapacityMicrofarads:unpack(_)
    return self.CapacityMicrofarads
end

CapacitorMetrics.CapacityMicrofarads = TCapacityMicrofarads

CapacitorMetrics.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.Capacitor.Metrics',
    {CapacityMicrofarads = {'u', {}, true, nil}}, {}, {})

return CapacitorMetrics
