--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPowerSupplyInfo = {}

---@class PowerMgmtIpmiCmds.GetPowerSupplyInfoReq
---@field ManufactureId integer
---@field PsSelector integer
---@field PsParameter integer
---@field ReadOffset integer
---@field Length integer
local TGetPowerSupplyInfoReq = {}
TGetPowerSupplyInfoReq.__index = TGetPowerSupplyInfoReq
TGetPowerSupplyInfoReq.group = {}

local function TGetPowerSupplyInfoReq_from_obj(obj)
    return setmetatable(obj, TGetPowerSupplyInfoReq)
end

function TGetPowerSupplyInfoReq.new(ManufactureId, PsSelector, PsParameter, ReadOffset, Length)
    return TGetPowerSupplyInfoReq_from_obj({
        ManufactureId = ManufactureId,
        PsSelector = PsSelector,
        PsParameter = PsParameter,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj PowerMgmtIpmiCmds.GetPowerSupplyInfoReq
function TGetPowerSupplyInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.PsSelector = obj.PsSelector
    self.PsParameter = obj.PsParameter
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetPowerSupplyInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerSupplyInfoReq.group)
end

TGetPowerSupplyInfoReq.from_obj = TGetPowerSupplyInfoReq_from_obj

TGetPowerSupplyInfoReq.proto_property = {'ManufactureId', 'PsSelector', 'PsParameter', 'ReadOffset', 'Length'}

TGetPowerSupplyInfoReq.default = {0, 0, 0, 0, 0}

TGetPowerSupplyInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'PsSelector', is_array = false, struct = nil},
    {name = 'PsParameter', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetPowerSupplyInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PsSelector', self.PsSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PsParameter', self.PsParameter, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetPowerSupplyInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerSupplyInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetPowerSupplyInfoReq:unpack(_)
    return self.ManufactureId, self.PsSelector, self.PsParameter, self.ReadOffset, self.Length
end

GetPowerSupplyInfo.GetPowerSupplyInfoReq = TGetPowerSupplyInfoReq

---@class PowerMgmtIpmiCmds.GetPowerSupplyInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetPowerSupplyInfoRsp = {}
TGetPowerSupplyInfoRsp.__index = TGetPowerSupplyInfoRsp
TGetPowerSupplyInfoRsp.group = {}

local function TGetPowerSupplyInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetPowerSupplyInfoRsp)
end

function TGetPowerSupplyInfoRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetPowerSupplyInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj PowerMgmtIpmiCmds.GetPowerSupplyInfoRsp
function TGetPowerSupplyInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetPowerSupplyInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerSupplyInfoRsp.group)
end

TGetPowerSupplyInfoRsp.from_obj = TGetPowerSupplyInfoRsp_from_obj

TGetPowerSupplyInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetPowerSupplyInfoRsp.default = {0, 0, 0, ''}

TGetPowerSupplyInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetPowerSupplyInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPowerSupplyInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerSupplyInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetPowerSupplyInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetPowerSupplyInfo.GetPowerSupplyInfoRsp = TGetPowerSupplyInfoRsp

return GetPowerSupplyInfo
