-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local EfficiencyCurve = require 'power_mgmt.json_types.EfficiencyCurve'

---@class PowerSuppliesTable: Table
---@field UpgradeStatus FieldBase
---@field AllocatedWatts FieldBase
---@field RequestedWatts FieldBase
---@field Id FieldBase
---@field RetransferDelaySeconds FieldBase

---@class CircuitTable: Table
---@field Id FieldBase
---@field CircuitType FieldBase
---@field PhaseWiringType FieldBase
---@field NominalVoltage FieldBase
---@field InputVoltageStatus FieldBase

---@class OnePowerTable: Table
---@field SlotNumber FieldBase
---@field Manufacturer FieldBase
---@field Model FieldBase
---@field PowerSupplyType FieldBase
---@field Presence FieldBase
---@field PowerSupplyChannel FieldBase
---@field SerialNumber FieldBase
---@field PartNumber FieldBase
---@field FirmwareVersion FieldBase
---@field Protocol FieldBase
---@field DeviceLocator FieldBase
---@field ProductionDate FieldBase
---@field Position FieldBase
---@field DMTFPowerSupplyType FieldBase
---@field SourceType FieldBase
---@field IsPartOfSysPower FieldBase
---@field TotalRunningHours FieldBase
---@field LineInputVoltageType FieldBase
---@field RelaySwitchedCount FieldBase
---@field WorkMode FieldBase
---@field DeepSleepStandbyPowerWatts FieldBase
---@field RedundancyGroupId FieldBase
---@field InputVoltageType FieldBase
---@field OutputPowerWatts FieldBase
---@field InputPowerWatts FieldBase
---@field InputVoltage FieldBase
---@field OutputVoltage FieldBase
---@field InputCurrentAmps FieldBase
---@field OutputCurrentAmps FieldBase
---@field Rate FieldBase
---@field RatedCurrentAmps FieldBase
---@field InputFrequencyHz FieldBase
---@field OutputPowerLimitWatts FieldBase
---@field EnergykWh FieldBase
---@field EnergySensorResetTime FieldBase
---@field EnergyApparentkVAh FieldBase
---@field EnergyLifetimekWh FieldBase
---@field EnergyReactivekVARh FieldBase
---@field InputCurrentAmpsCrestFactor FieldBase
---@field InputCurrentAmpsTHDPercent FieldBase
---@field InputPowerWattsApparentVA FieldBase
---@field InputPowerWattsPhaseAngleDegrees FieldBase
---@field InputPowerWattsPowerFactor FieldBase
---@field InputPowerWattsReactiveVAR FieldBase
---@field InputVoltageCrestFactor FieldBase
---@field OutputPowerWattsApparentVA FieldBase
---@field OutputPowerWattsPhaseAngleDegrees FieldBase
---@field OutputPowerWattsPowerFactor FieldBase
---@field OutputPowerWattsReactiveVAR FieldBase
---@field EnvTemperatureCelsius FieldBase
---@field PrimaryChipTemperatureCelsius FieldBase
---@field SecondaryChipTemperatureCelsius FieldBase
---@field InletTemperatureCelsius FieldBase
---@field InnerTemperatureCelsius FieldBase
---@field OutputState FieldBase
---@field CommunicationStatus FieldBase
---@field Failure FieldBase
---@field Fan1Fault FieldBase
---@field Fan2Fault FieldBase
---@field FanFault FieldBase
---@field InputVoltageFault FieldBase
---@field LossOfInput FieldBase
---@field OutputCurrentFault FieldBase
---@field OutputVoltageFault FieldBase
---@field OverTemperature FieldBase
---@field SleepMode FieldBase
---@field DeepSleepEnabled FieldBase
---@field InputVoltageStatus FieldBase
---@field DualInputVoltageStatus FieldBase
---@field ScanStatus FieldBase
---@field EquipmentMode FieldBase
---@field TPSUStatusHigh FieldBase
---@field TPSUStatusLow FieldBase
---@field MainCircuitVINStatus FieldBase
---@field BackupCircuitVINStatus FieldBase
---@field Health FieldBase
---@field IsUpgrading FieldBase
---@field NormalAndRedundancySupported FieldBase
---@field MfrSpecificStatus FieldBase
---@field CMLStatus FieldBase
---@field OtherStatus FieldBase
---@field EfficiencyCurve FieldBase
---@field PowerLevel FieldBase
---@field HardwareVersion FieldBase
---@field PowerState FieldBase
---@field VOUTDebounceMilliseconds FieldBase
---@field DepthOfDischargeVolts FieldBase
---@field CapacityMicrofarads FieldBase
---@field PhysicalInterface FieldBase
---@field RefFrudata FieldBase
---@field UnsupportedProperties FieldBase
---@field AlarmStatus FieldBase
---@field PreAlarmStatus FieldBase
---@field RefSMCChip FieldBase
---@field UpgradeSupported FieldBase
---@field InputState FieldBase

---@class PsuSlotTable: Table
---@field SlotNumber FieldBase
---@field SlotI2cAddr FieldBase
---@field FruI2cAddr FieldBase
---@field Presence FieldBase
---@field I2cChip FieldBase
---@field PsuChip FieldBase
---@field PsuBackupChip FieldBase
---@field FruChip FieldBase
---@field OutputState FieldBase
---@field FruSource FieldBase
---@field IsSupportPowerOnUpgrade FieldBase

---@class AclostRecordTableTable: Table
---@field Id FieldBase
---@field CurTime FieldBase
---@field CurTimeSource FieldBase
---@field Flag FieldBase
---@field ResetFlag FieldBase
---@field ShieldAclostEventRecord FieldBase

---@class PowerConfigurationTable: Table
---@field SinglePsuSupport FieldBase
---@field Id FieldBase
---@field MinAvailablePSUCountForUpgrade FieldBase

---@class PowerOutputEfficiencyCurveTable: Table
---@field Position FieldBase
---@field PartNumber FieldBase
---@field InputVoltage FieldBase
---@field LoadPercentRange FieldBase
---@field EfficiencyCurve FieldBase
---@field PowerLevel FieldBase

---@class Power_mgmtDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field PowerSupplies PowerSuppliesTable
---@field Circuit CircuitTable
---@field OnePower OnePowerTable
---@field PsuSlot PsuSlotTable
---@field AclostRecordTable AclostRecordTableTable
---@field PowerConfiguration PowerConfigurationTable
---@field PowerOutputEfficiencyCurve PowerOutputEfficiencyCurveTable
local Power_mgmtDBDatabase = {}
Power_mgmtDBDatabase.__index = Power_mgmtDBDatabase

function Power_mgmtDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.PowerSupplies = db:Table('t_power_supplies', {
        UpgradeStatus = Col.IntegerField():cid(1):null():max_length(8):default(0),
        AllocatedWatts = Col.IntegerField():cid(2):null():max_length(32):default(4294967295),
        RequestedWatts = Col.IntegerField():cid(3):null():max_length(32):default(4294967295),
        Id = Col.IntegerField():cid(4):primary_key():persistence_key('protect_power_off'):max_length(8),
        RetransferDelaySeconds = Col.IntegerField():cid(5):persistence_key('protect_power_off'):null():max_length(32)
            :default(1800)
    }):create_if_not_exist(datas and datas['t_power_supplies'])
    obj.Circuit = db:Table('t_circuit', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        CircuitType = Col.TextField():cid(2):null(),
        PhaseWiringType = Col.TextField():cid(3):null(),
        NominalVoltage = Col.TextField():cid(4):null(),
        InputVoltageStatus = Col.IntegerField():cid(5):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_circuit'])
    obj.OnePower = db:Table('t_onepower', {
        SlotNumber = Col.IntegerField():cid(1):primary_key():max_length(32):default(0),
        Manufacturer = Col.TextField():cid(2):null(),
        Model = Col.TextField():cid(3):null(),
        PowerSupplyType = Col.IntegerField():cid(4):null():max_length(32):default(0),
        Presence = Col.IntegerField():cid(5):null():max_length(8):default(0),
        PowerSupplyChannel = Col.IntegerField():cid(6):null():max_length(8):default(0),
        SerialNumber = Col.TextField():cid(7):null(),
        PartNumber = Col.TextField():cid(8):null(),
        FirmwareVersion = Col.TextField():cid(9):null(),
        Protocol = Col.TextField():cid(10):null(),
        DeviceLocator = Col.TextField():cid(11):null(),
        ProductionDate = Col.TextField():cid(12):null(),
        Position = Col.TextField():cid(13):null(),
        DMTFPowerSupplyType = Col.IntegerField():cid(14):null():max_length(8):default(4),
        SourceType = Col.IntegerField():cid(15):null():max_length(8):default(1),
        IsPartOfSysPower = Col.BooleandField():cid(16):null():default(true),
        TotalRunningHours = Col.IntegerField():cid(17):null():max_length(32),
        LineInputVoltageType = Col.TextField():cid(18):null():default('\'Unknown\''),
        RelaySwitchedCount = Col.IntegerField():cid(19):null():max_length(16),
        WorkMode = Col.TextField():cid(20):null(),
        DeepSleepStandbyPowerWatts = Col.IntegerField():cid(21):null():max_length(16):default(65535),
        RedundancyGroupId = Col.IntegerField():cid(22):null():max_length(8),
        InputVoltageType = Col.IntegerField():cid(23):null():max_length(8),
        OutputPowerWatts = Col.RealField():cid(24):null(),
        InputPowerWatts = Col.RealField():cid(25):null(),
        InputVoltage = Col.RealField():cid(26):null(),
        OutputVoltage = Col.RealField():cid(27):null(),
        InputCurrentAmps = Col.RealField():cid(28):null(),
        OutputCurrentAmps = Col.RealField():cid(29):null(),
        Rate = Col.IntegerField():cid(30):null():max_length(16),
        RatedCurrentAmps = Col.IntegerField():cid(31):null():max_length(16),
        InputFrequencyHz = Col.RealField():cid(32):null(),
        OutputPowerLimitWatts = Col.IntegerField():cid(33):null():max_length(32),
        EnergykWh = Col.RealField():cid(34):null(),
        EnergySensorResetTime = Col.TextField():cid(35):null(),
        EnergyApparentkVAh = Col.RealField():cid(36):null(),
        EnergyLifetimekWh = Col.RealField():cid(37):null(),
        EnergyReactivekVARh = Col.RealField():cid(38):null(),
        InputCurrentAmpsCrestFactor = Col.RealField():cid(39):null(),
        InputCurrentAmpsTHDPercent = Col.RealField():cid(40):null(),
        InputPowerWattsApparentVA = Col.RealField():cid(41):null(),
        InputPowerWattsPhaseAngleDegrees = Col.RealField():cid(42):null(),
        InputPowerWattsPowerFactor = Col.RealField():cid(43):null(),
        InputPowerWattsReactiveVAR = Col.RealField():cid(44):null(),
        InputVoltageCrestFactor = Col.RealField():cid(45):null(),
        OutputPowerWattsApparentVA = Col.RealField():cid(46):null(),
        OutputPowerWattsPhaseAngleDegrees = Col.RealField():cid(47):null(),
        OutputPowerWattsPowerFactor = Col.RealField():cid(48):null(),
        OutputPowerWattsReactiveVAR = Col.RealField():cid(49):null(),
        EnvTemperatureCelsius = Col.RealField():cid(50):null(),
        PrimaryChipTemperatureCelsius = Col.RealField():cid(51):null(),
        SecondaryChipTemperatureCelsius = Col.RealField():cid(52):null(),
        InletTemperatureCelsius = Col.RealField():cid(53):null(),
        InnerTemperatureCelsius = Col.RealField():cid(54):null(),
        OutputState = Col.IntegerField():cid(55):null():max_length(8),
        CommunicationStatus = Col.IntegerField():cid(56):null():max_length(8),
        Failure = Col.IntegerField():cid(57):null():max_length(8),
        Fan1Fault = Col.IntegerField():cid(58):null():max_length(8),
        Fan2Fault = Col.IntegerField():cid(59):null():max_length(8),
        FanFault = Col.IntegerField():cid(60):null():max_length(8),
        InputVoltageFault = Col.IntegerField():cid(61):null():max_length(16):default(32768),
        LossOfInput = Col.IntegerField():cid(62):null():max_length(8),
        OutputCurrentFault = Col.IntegerField():cid(63):null():max_length(8),
        OutputVoltageFault = Col.IntegerField():cid(64):null():max_length(8),
        OverTemperature = Col.IntegerField():cid(65):null():max_length(8),
        SleepMode = Col.TextField():cid(66):null(),
        DeepSleepEnabled = Col.IntegerField():cid(67):null():max_length(8),
        InputVoltageStatus = Col.IntegerField():cid(68):null():max_length(8),
        DualInputVoltageStatus = Col.IntegerField():cid(69):null():max_length(16),
        ScanStatus = Col.IntegerField():cid(70):null():max_length(8),
        EquipmentMode = Col.IntegerField():cid(71):null():max_length(8):default(255),
        TPSUStatusHigh = Col.IntegerField():cid(72):null():max_length(32),
        TPSUStatusLow = Col.IntegerField():cid(73):null():max_length(32),
        MainCircuitVINStatus = Col.IntegerField():cid(74):null():max_length(8):default(255),
        BackupCircuitVINStatus = Col.IntegerField():cid(75):null():max_length(8):default(255),
        Health = Col.IntegerField():cid(76):null():max_length(8):default(255),
        IsUpgrading = Col.BooleandField():cid(77):null(),
        NormalAndRedundancySupported = Col.BooleandField():cid(78):null(),
        MfrSpecificStatus = Col.IntegerField():cid(79):null():max_length(8):default(255),
        CMLStatus = Col.IntegerField():cid(80):null():max_length(8),
        OtherStatus = Col.IntegerField():cid(81):null():max_length(8),
        EfficiencyCurve = Col.JsonField():cid(82):null(),
        PowerLevel = Col.TextField():cid(83):null():default('\'N/A\''),
        HardwareVersion = Col.TextField():cid(84):null(),
        PowerState = Col.TextField():cid(85):null():default('\'N/A\''),
        VOUTDebounceMilliseconds = Col.IntegerField():cid(86):null():max_length(32),
        DepthOfDischargeVolts = Col.IntegerField():cid(87):null():max_length(32),
        CapacityMicrofarads = Col.IntegerField():cid(88):null():max_length(32),
        PhysicalInterface = Col.TextField():cid(89):null(),
        RefFrudata = Col.JsonField():cid(90):null(),
        UnsupportedProperties = Col.JsonField():cid(91):null(),
        AlarmStatus = Col.IntegerField():cid(92):null():max_length(32),
        PreAlarmStatus = Col.IntegerField():cid(93):null():max_length(32),
        RefSMCChip = Col.JsonField():cid(94):null(),
        UpgradeSupported = Col.BooleandField():cid(95):null():default(true),
        InputState = Col.IntegerField():cid(96):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_onepower'])
    obj.PsuSlot = db:Table('t_psu_slot', {
        SlotNumber = Col.IntegerField():cid(1):primary_key():max_length(8),
        SlotI2cAddr = Col.IntegerField():cid(2):null():max_length(8),
        FruI2cAddr = Col.IntegerField():cid(3):null():max_length(8),
        Presence = Col.IntegerField():cid(4):null():max_length(8):default(255),
        I2cChip = Col.JsonField():cid(5):null(),
        PsuChip = Col.JsonField():cid(6):null(),
        PsuBackupChip = Col.JsonField():cid(7):null(),
        FruChip = Col.JsonField():cid(8):null(),
        OutputState = Col.IntegerField():cid(9):null():max_length(8),
        FruSource = Col.IntegerField():cid(10):null():max_length(8),
        IsSupportPowerOnUpgrade = Col.BooleandField():cid(11):null():default(true)
    }):create_if_not_exist(datas and datas['t_psu_slot'])
    obj.AclostRecordTable = db:Table('t_aclost_record', {
        Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off'),
        CurTime = Col.IntegerField():cid(2):persistence_key('protect_power_off'):null():max_length(32),
        CurTimeSource = Col.TextField():cid(3):persistence_key('protect_power_off'):null(),
        Flag = Col.IntegerField():cid(4):persistence_key('protect_power_off'):null():max_length(32),
        ResetFlag = Col.IntegerField():cid(5):persistence_key('protect_reset'):null():max_length(8):default(0),
        ShieldAclostEventRecord = Col.IntegerField():cid(6):persistence_key('protect_power_off'):null():max_length(8)
            :default(255)
    }):create_if_not_exist(datas and datas['t_aclost_record'])
    obj.PowerConfiguration = db:Table('t_power_configuration', {
        SinglePsuSupport = Col.IntegerField():cid(1):null():max_length(8):default(0),
        Id = Col.IntegerField():cid(2):primary_key():max_length(8):default(1),
        MinAvailablePSUCountForUpgrade = Col.IntegerField():cid(3):null():max_length(8):default(255)
    }):create_if_not_exist(datas and datas['t_power_configuration'])
    obj.PowerOutputEfficiencyCurve = db:Table('t_power_efficiency_curve', {
        Position = Col.TextField():cid(1):primary_key(),
        PartNumber = Col.TextField():cid(2):primary_key(),
        InputVoltage = Col.IntegerField():cid(3):primary_key():max_length(16),
        LoadPercentRange = Col.JsonField():cid(4):null(),
        EfficiencyCurve = Col.JsonField():cid(5):null(),
        PowerLevel = Col.TextField():cid(6):null():default('\'N/A\'')
    }):create_if_not_exist(datas and datas['t_power_efficiency_curve'])

    obj.tables = db.tables
    return setmetatable(obj, Power_mgmtDBDatabase)
end

function Power_mgmtDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function Power_mgmtDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function Power_mgmtDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function Power_mgmtDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function Power_mgmtDBDatabase:exec(...)
    return self.db:exec(...)
end

return Power_mgmtDBDatabase.new
