-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-12-18
-- Description: DO NOT EDIT; Code generated by "client.lua.mako"
local class = require 'mc.class'
local app_base = require 'mc.client_app_base'
local mdb_service = require 'mc.mdb.mdb_service'
local subscribe_signal = require 'mc.mdb.subscribe_signal'

local get_non_virtual_interface_objects = mdb_service.get_non_virtual_interface_objects
local foreach_non_virtual_interface_objects = mdb_service.foreach_non_virtual_interface_objects

local Performance = require 'debug.json_types.Performance'

---@class power_mgmt_client: BasicClient
local power_mgmt_client = class(app_base.Client)

function power_mgmt_client:GetPerformanceObjects()
    return get_non_virtual_interface_objects(self:get_bus(), 'bmc.kepler.Debug.Performance', true)
end

function power_mgmt_client:ForeachPerformanceObjects(cb)
    return foreach_non_virtual_interface_objects(self:get_bus(), 'bmc.kepler.Debug.Performance', cb, true)
end

function power_mgmt_client:OnPerformancePropertiesChanged(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_properties_changed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Debug.Performance')
end

function power_mgmt_client:OnPerformanceInterfacesAdded(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_added(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Debug.Performance')
end

function power_mgmt_client:OnPerformanceInterfacesRemoved(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_interfaces_removed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Debug.Performance')
end

function power_mgmt_client:ctor()
    self.signal_slots = {}
end

---@type power_mgmt_client
return power_mgmt_client.new('power_mgmt')
