-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-12-18
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local black_box_intf_types = require 'debug.json_types.BlackBox'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'

local OnePowerDebug = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Debug.BlackBox'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Debug.BlackBox'] = {
            ['DumpPsuBlackbox'] = {
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'ReadOnly'},
                ['displayDescription'] = 'Dump PSU blackbox data. (file path: /var/log/ps_black_box.log). For example: dumppsublackbox OnePowerDebug_0_010109.',
                ['cmdName'] = 'dumppsublackbox'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Debug/Chassis/:ChassisId/PowerMgmt/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Debug.BlackBox'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['DumpPsuBlackbox'] = privilege.ReadOnly}},
            ['interface_types'] = black_box_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('OnePowerDebug', OnePowerDebug):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerDebugBlackBoxDumpPsuBlackbox(cb)
    class('OnePowerDebug')['bmc.kepler.Debug.BlackBox'].DumpPsuBlackbox = function(obj, ctx, ...)
        local req = black_box_intf_types.DumpPsuBlackboxReq.new(...):validate(nil, nil, true)
        local rsp = black_box_intf_types.DumpPsuBlackboxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
